/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.utils;

import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.IIncludedShareableEntity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.model.utils.SelectorContext;
import com.ibm.cic.common.core.model.utils.SelectorExpander;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.logging.Logger;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ContentCollection
extends AbstractCollection {
    private static final int FLAG_RESOLVE_SKIP = 0;
    private static final int FLAG_RESOLVE_FORCE = 1;
    public static final int FLAG_RESOLVE_NORMAL = 2;
    private final IContent content;
    private final LinkedProperties contentProperties;
    private final boolean includeIUs;
    private final int resolveFlags;
    private final IProgressMonitor progressMonitor;
    private Collection<IContent> contentCollection = null;
    private boolean keepExpander;
    private SelectorExpander expander;
    private boolean includeAllSuArtifactsDuringExpansion = true;

    public boolean isIncludeAllSuArtifactsDuringExpansion() {
        return this.includeAllSuArtifactsDuringExpansion;
    }

    public void setIncludeAllSuArtifactsDuringExpansion(boolean includeAllSuArtifactsDuringExpansion) {
        this.includeAllSuArtifactsDuringExpansion = includeAllSuArtifactsDuringExpansion;
    }

    protected ContentCollection(IContent content, LinkedProperties properties, int resolveFlags, boolean includeIUs, IProgressMonitor monitor) {
        this(content, properties, resolveFlags, includeIUs, true, monitor);
    }

    protected ContentCollection(IContent content, LinkedProperties properties, int resolveFlags, boolean includeIUs, boolean includeAllSuArtifacts, IProgressMonitor monitor) {
        this.content = content;
        this.resolveFlags = resolveFlags;
        this.contentProperties = properties;
        this.includeIUs = includeIUs;
        this.progressMonitor = monitor;
        this.expander = null;
        this.keepExpander = false;
        this.includeAllSuArtifactsDuringExpansion = includeAllSuArtifacts;
    }

    public ContentCollection(IContent content, LinkedProperties properties, boolean includeIUs, IProgressMonitor monitor) {
        this(content, properties, 0, includeIUs, monitor);
    }

    public ContentCollection(IOfferingOrFix offeringOrFix, LinkedProperties properties, int resolveFlags, boolean includeIUs, IProgressMonitor monitor) {
        this((IContent)offeringOrFix, properties, resolveFlags, includeIUs, monitor);
    }

    public ContentCollection(IContent content) {
        this(content, null, false, null);
    }

    public void setKeepExpander(boolean keepExpander) {
        this.keepExpander = keepExpander;
    }

    public SelectorExpander getExpander() {
        return this.expander;
    }

    @Override
    public Iterator<IContent> iterator() {
        this.init();
        return this.contentCollection.iterator();
    }

    @Override
    public int size() {
        this.init();
        return this.contentCollection.size();
    }

    public Collection<IContent> getCollection() {
        this.init();
        return Collections.unmodifiableCollection(this.contentCollection);
    }

    protected IShareableEntity findShareableEntity(IIncludedShareableEntity ise, IProgressMonitor monitor) {
        return ise.getShareableEntity();
    }

    protected IAssembly findAssembly(IOfferingOrFix oof, IProgressMonitor monitor) {
        return oof.getAssembly();
    }

    protected SelectorExpander createSelectorExpander(IShareableEntity se, Set<IContentSelector> selectors) {
        return new SelectorExpander(se, selectors, this.includeIUs){

            @Override
            protected IShareableEntity findShareableEntity(IIncludedShareableEntity ise, IProgressMonitor monitor) {
                return ContentCollection.this.findShareableEntity(ise, monitor);
            }
        };
    }

    private IStatus resolve(IOfferingOrFix oof, IProgressMonitor monitor) {
        if (this.resolveFlags != 0) {
            return RepositoryUtils.resolve(oof, this.resolveFlags == 1, monitor);
        }
        return Status.OK_STATUS;
    }

    private void init() {
        if (this.contentCollection != null) {
            return;
        }
        LinkedHashSet<IContent> set = new LinkedHashSet<IContent>();
        if (this.content instanceof IOfferingOrFix) {
            IOfferingOrFix oof = (IOfferingOrFix)this.content;
            set.add(oof);
            SplitProgressMonitor pm = new SplitProgressMonitor(this.progressMonitor, 3);
            IStatus status = this.resolve(oof, pm.next());
            Logger.getGlobalLogger().statusNotOK(status);
            IAssembly assembly = this.findAssembly(oof, pm.next());
            if (assembly != null) {
                this.preProcessSE(assembly);
                this.addShareableEntitiesAndFragments(set, assembly, this.supportsProfileSharing(oof), pm.next());
            }
            if (this.includeIUs) {
                this.addOfferingOrFixIUs(set, oof, this.contentProperties);
            }
        } else if (this.content instanceof IShareableEntity) {
            IShareableEntity se = (IShareableEntity)this.content;
            this.preProcessSE(se);
            this.addShareableEntitiesAndFragments(set, se, this.includeAllSuArtifactsDuringExpansion, this.progressMonitor);
        } else if (!(this.content instanceof IInstallableUnit)) {
            throw new AssertionError((Object)("unexpected content type: " + this.content));
        }
        this.contentCollection = set;
    }

    private void addShareableEntitiesAndFragments(Set<IContent> set, IShareableEntity se, boolean includeAllSuArtifacts, IProgressMonitor monitor) {
        Set selectors = se.getSelectors();
        SelectorContext selectorContext = new SelectorContext(se, selectors, this.contentProperties, true);
        selectorContext.setIncludeAllSuArtifacts(includeAllSuArtifacts);
        SelectorExpander exp = this.createSelectorExpander(se, selectors);
        if (this.keepExpander) {
            this.expander = exp;
        }
        exp.expand(selectorContext, monitor);
        for (SelectorExpander.ShareableEntityAndSelection seAndSel : exp.getShareableEntitiesAndSelection()) {
            IShareableEntity selSe = seAndSel.getSE();
            this.preProcessSE(selSe);
            set.add(selSe);
        }
        for (ISuFragment fragment : exp.getSuFragments()) {
            this.preProcessFragment(fragment);
            set.add(fragment);
        }
        if (this.includeIUs) {
            IInstallableUnit[] iInstallableUnitArray = exp.getIUs();
            int n = iInstallableUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                IInstallableUnit iu = iInstallableUnitArray[n2];
                set.add(iu);
                ++n2;
            }
        }
    }

    protected void preProcessSE(IShareableEntity se) {
    }

    protected void preProcessFragment(ISuFragment fragment) {
    }

    protected void addOfferingOrFixIU(Set<IContent> set, IInstallableUnit iu) {
        set.add(iu);
    }

    private void addOfferingOrFixIUs(Set<IContent> set, IOfferingOrFix oof, LinkedProperties predefines) {
        Collection<IInstallableUnit> ius = OfferingUtil.getOfferingIUs(oof, predefines);
        for (IInstallableUnit iu : ius) {
            this.addOfferingOrFixIU(set, iu);
        }
    }

    private boolean supportsProfileSharing(IOfferingOrFix oof) {
        if (!(oof instanceof IOffering)) {
            return true;
        }
        IOffering offering = (IOffering)oof;
        Set shareSet = OfferingProperty.getProfileShareSet(offering);
        return !shareSet.isEmpty() || OfferingProperty.isExtension(offering);
    }
}

