/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal.validation;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.model.internal.validation.ValidatorDescriptor;
import com.ibm.cic.common.core.model.validation.IValidator;
import com.ibm.cic.common.core.model.validation.ValidationCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ValidatorRegistry {
    public static final ValidatorRegistry INSTANCE = new ValidatorRegistry();
    public static final String EXTENSION_ID = "modelValidators";
    public static final String EXTENSION_TAG_NAME = "modelValidator";
    private Set overrides;
    private List[] validatorsByCategory;
    private boolean hasInstantiatedValidators;

    private ValidatorRegistry() {
        this.loadValidatorExtensions();
    }

    private void reset() {
        this.validatorsByCategory = new List[ValidationCategory.getCount()];
        this.hasInstantiatedValidators = false;
    }

    public void loadValidatorExtensions() {
        this.reset();
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(ComIbmCicCommonCorePlugin.getPluginId(), EXTENSION_ID);
        this.overrides = new HashSet(4);
        IConfigurationElement[] iConfigurationElementArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ValidationCategory cat;
            IConfigurationElement config = iConfigurationElementArray[n2];
            ValidatorDescriptor desc = new ValidatorDescriptor(config);
            String overridden = desc.getOverrides();
            if (overridden != null && overridden.length() > 0) {
                this.overrides.add(overridden);
            }
            if ((cat = ValidationCategory.getByName(desc.getCategory())) != null) {
                LinkedList<ValidatorDescriptor> descriptors = this.validatorsByCategory[cat.getLevel()];
                if (descriptors == null) {
                    this.validatorsByCategory[cat.getLevel()] = descriptors = new LinkedList<ValidatorDescriptor>();
                }
                descriptors.add(desc);
            }
            ++n2;
        }
    }

    public List getValidators(ValidationCategory category) {
        List result;
        if (!this.hasInstantiatedValidators) {
            this.instantiateValidators();
        }
        return (result = this.validatorsByCategory[category.getLevel()]) == null ? Collections.EMPTY_LIST : result;
    }

    private void instantiateValidators() {
        int i = 0;
        while (i < this.validatorsByCategory.length) {
            List descriptors = this.validatorsByCategory[i];
            if (descriptors != null) {
                ArrayList<IValidator> validators = new ArrayList<IValidator>(descriptors.size());
                for (ValidatorDescriptor desc : descriptors) {
                    IValidator validator;
                    if (this.overrides.contains(desc.getValidatorClassName()) || (validator = desc.getValidator()) == null) continue;
                    validators.add(validator);
                }
                validators.trimToSize();
                this.validatorsByCategory[i] = validators;
            }
            ++i;
        }
        this.overrides = null;
        this.hasInstantiatedValidators = true;
    }

    public boolean isEmpty() {
        int i = 0;
        while (i < this.validatorsByCategory.length) {
            if (this.validatorsByCategory[i] != null && !this.validatorsByCategory[i].isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void enable() {
        this.loadValidatorExtensions();
    }

    public void refresh() {
        this.loadValidatorExtensions();
    }

    public void disable() {
        this.reset();
    }
}

