/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.model.adapterdata.DefaultAdapterDataParser;
import com.ibm.cic.common.core.model.adapterdata.IAdapterDataParser;
import com.ibm.cic.common.core.model.internal.Messages;
import com.ibm.cic.common.logging.Logger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class Util {
    private static final Logger log = Logger.getLogger(Util.class);
    private static final String PT_PARSER = "adapterDataParser";
    private static final String PT_ADAPTERID_ATTR = "adapterId";
    private static final String PT_CLASS_ATTR = "class";
    private static Map adapterDataParsers = null;

    public static Collection getAdapterIds() {
        if (adapterDataParsers == null) {
            adapterDataParsers = Util.initializeExtensions(PT_PARSER);
        }
        return adapterDataParsers.keySet();
    }

    public static IAdapterDataParser getAdapterDataParser(String adapterId) {
        Object extension;
        if (adapterDataParsers == null) {
            adapterDataParsers = Util.initializeExtensions(PT_PARSER);
        }
        if ((extension = Util.getAdapterDataExtension(adapterDataParsers, adapterId)) instanceof IAdapterDataParser) {
            return (IAdapterDataParser)extension;
        }
        if (extension != null) {
            log.error(Messages.Util_class_for_extension_point_does_not_implement, extension.getClass(), PT_PARSER, "IAdapterDataParser");
        }
        return new DefaultAdapterDataParser();
    }

    private static Object getAdapterDataExtension(Map extensions, String adapterId) {
        Object obj = extensions.get(adapterId);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof IConfigurationElement)) {
            return obj;
        }
        IConfigurationElement element = (IConfigurationElement)obj;
        Object extension = null;
        try {
            extension = element.createExecutableExtension(PT_CLASS_ATTR);
        }
        catch (CoreException e) {
            log.error(Messages.Util_failed_to_create_executable_extension, element.getAttribute(PT_CLASS_ATTR), e.getMessage());
        }
        return extension;
    }

    private static Map initializeExtensions(String extPointId) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(ComIbmCicCommonCorePlugin.getPluginId(), extPointId);
        if (point == null) {
            return new HashMap(0);
        }
        IExtension[] extensions = point.getExtensions();
        HashMap<String, IConfigurationElement> result = new HashMap<String, IConfigurationElement>(extensions.length);
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (extPointId.equalsIgnoreCase(element.getName())) {
                    String adapterId = element.getAttribute(PT_ADAPTERID_ATTR);
                    Object prev = result.get(adapterId);
                    if (prev != null) {
                        log.error(Messages.Util_more_than_one_extension_for, extPointId, adapterId, prev, element);
                    }
                    result.put(adapterId, element);
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    private Util() {
    }

    public static boolean hasApplicabilityFlag(IStatus status, int flag) {
        if (status == Status.CANCEL_STATUS) {
            return false;
        }
        return (status.getCode() & flag) != 0;
    }
}

