/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.model.PredefinedSelectors;
import com.ibm.cic.common.core.model.internal.Messages;
import com.ibm.cic.common.core.model.internal.SelectionOperator;
import com.ibm.cic.common.core.model.internal.Util;
import com.ibm.cic.common.core.model.utils.ExtensionBundleUtils;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public abstract class SelectionExpression
implements ISelectionExpression {
    private static final Logger log = Logger.getLogger(SelectionExpression.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());

    static ISelectionExpression.ISelectedById createSelectedById(String id) {
        return new WithIdOnly(id);
    }

    public static ISelectionExpression.ISelectedByPredefinedId createSelectedByPredefinedId(String id, String value) {
        return new WithPredefinedId(id, value);
    }

    public static ISelectionExpression.ISelectedByBundle createSelectedByBundle(String id, String className) {
        return new WithBundle(id, className);
    }

    public static ISelectionExpression.ISelectedByTarget createSelectedByTarget(String id) {
        return new WithTarget(id);
    }

    static ISelectionExpression.ISelectedByOperator createSelectedByOperator(SelectionOperator operator) {
        return new WithOperator(operator);
    }

    static ISelectionExpression create(String id, String value) {
        if (PredefinedSelectors.isVariable(id) || PredefinedSelectors.contains(id)) {
            return SelectionExpression.createSelectedByPredefinedId(id, value);
        }
        return SelectionExpression.createSelectedById(id);
    }

    private static class BadExpr
    implements ISelectionExpression {
        private final IStatus status;

        BadExpr(IStatus status) {
            this.status = status;
        }

        @Override
        public IStatus evaluate(ISelectionExpression.EvaluationContext context) {
            return this.status;
        }
    }

    private static class WithBundle
    extends SelectionExpression
    implements ISelectionExpression.ISelectedByBundle {
        private static final int STATUS_CODE_LOAD_FAILURE = 256;
        private static final int STATUS_CODE_LOAD_EXCEPTION = 512;
        private static final int STATUS_CODE_CLASS_LOAD_FAILURE = 768;
        private static final int STATUS_CODE_CLASS_CAST_EXCEPTION = 1024;
        private static final int STATUS_CODE_CLASS_LOAD_EXCEPTION = 1280;
        private static final int STATUS_CODE_BUNDLE_NOT_AN_EXTN = 1536;
        private static final int STATUS_CODE_EXTN_POINT_EXCEPTION = 1792;
        private static final int STATUS_CODE_EXCEPTION = 2048;
        private static final int STATUS_CODE_BUNDLE_STOPPING = 2304;
        private static final int STATUS_CODE_BUNDLE_CLASS_NOT_AN_EXTN = 2560;
        private static final String CHECK_AGENT_UPDATE = "com.ibm.check.agent.update";
        private static final String CHECK_AGENT13_UPDATE = "com.ibm.cic.check.agent13.update";
        private final String bundleId;
        private final String className;
        private Version bundleVersion;
        private ISelectionExpression userExpr;
        private static final String NAMESPACE = ComIbmCicCommonCorePlugin.getPluginId();
        private static final String EXPR_EXTN_PT = "modelSelectorExpression";
        private static final String EXPR_EXTN_PT_FQN = String.valueOf(NAMESPACE) + '.' + "modelSelectorExpression";
        private static final String CLASS_ATTR = "class";
        private static final ExtensionBundleUtils.ExtensionBundleClassFinder CLASS_FINDER = new ExtensionBundleUtils.ExtensionBundleClassFinder(){

            @Override
            protected IExtension[] findMatchingExtension(Object context, String extensionPointNamespace, String extensionPointName, String bundleId) throws CoreException {
                try {
                    return super.findMatchingExtension(context, extensionPointNamespace, extensionPointName, bundleId);
                }
                catch (CoreException e) {
                    throw e;
                }
                catch (Exception e) {
                    String errMsg = NLS.bind(Messages.SelectionExpression_ExceptionCaughtWhileProcessingExtensionsForExtnPoint, (Object)EXPR_EXTN_PT_FQN, (Object)e.getLocalizedMessage());
                    throw new CoreException((IStatus)Statuses.WARNING.get(1792, e, errMsg, new Object[0]));
                }
            }

            @Override
            protected IConfigurationElement findMatchingClass(Object context, String bundleId, String className, IExtension[] extensions) throws CoreException {
                try {
                    return super.findMatchingClass(context, bundleId, className, extensions);
                }
                catch (CoreException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)Statuses.WARNING.get(1280, e, Messages.SelectionExpression_ExceptionCaughtWhileProcessingExtension, extensions, e.getLocalizedMessage()));
                }
            }

            @Override
            protected void onNoMatchingExtensionFound(Object context, String extensionPointNamespace, String extensionPointName, String bundleId) throws CoreException {
                throw new CoreException((IStatus)Statuses.WARNING.get(1536, Messages.SelectionExpression_BundleDoesNotProvideForExtnPoint, bundleId, EXPR_EXTN_PT_FQN));
            }

            @Override
            protected IConfigurationElement onNoMatchingConfigurationFound(Object context, IExtension[] extensions, String bundleId, String className, IConfigurationElement[] configs) throws CoreException {
                ICicStatus status = Statuses.WARNING.get(2560, Messages.SelectionExpression_BundleDoesNotProvideForClass, bundleId, className, EXPR_EXTN_PT_FQN);
                if (WithBundle.offeringToleratesPre_1_2((ISelectionExpression.EvaluationContext)context)) {
                    log.status(status);
                    return configs[0];
                }
                throw new CoreException((IStatus)status);
            }
        };

        WithBundle(String bundleId, String className) {
            Assert.isNotNull((Object)bundleId);
            this.bundleId = bundleId;
            this.className = className;
            this.userExpr = null;
            this.bundleVersion = null;
        }

        @Override
        public String getBundleId() {
            return this.bundleId;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public IStatus evaluate(ISelectionExpression.EvaluationContext context) {
            String msg;
            IStatus status;
            Assert.isNotNull((Object)context);
            if (context.mustIgnoreBundles()) {
                return new Status(1, ComIbmCicCommonCorePlugin.getPluginId(), 0, null, null);
            }
            this.loadBundleAndFetchOrRefreshExpr(context);
            try {
                status = this.userExpr.evaluate(context);
                Assert.isNotNull((Object)status);
            }
            catch (Throwable e) {
                String errMsg = NLS.bind(Messages.SelectionExpression_ExceptionCaughtWhileEvaluatingExpressionInBundle, (Object)this.bundleId);
                status = Statuses.ERROR.get(2048, e, errMsg, new Object[0]);
            }
            if (!status.isOK() && (msg = status.getMessage()) != null && msg.trim().length() != 0 && !Util.hasApplicabilityFlag(status, 8)) {
                log.status(status);
            }
            if ("com.ibm.check.ibm.jre.visiblefeature".equals(this.bundleId) && 2 == status.getSeverity()) {
                status = new Status(4, status.getPlugin(), status.getCode(), status.getMessage(), status.getException());
            }
            log.debug("Evaluate {0} = {1}", this, status.isOK() ? "OK" : status);
            return status;
        }

        private void loadBundleAndFetchOrRefreshExpr(ISelectionExpression.EvaluationContext context) {
            IStatus status;
            block7: {
                try {
                    if (CHECK_AGENT13_UPDATE.equals(this.bundleId) || CHECK_AGENT_UPDATE.equals(this.bundleId)) {
                        status = Status.OK_STATUS;
                        break block7;
                    }
                    Bundle bundle = Platform.getBundle((String)this.bundleId);
                    if (bundle == null) {
                        status = Statuses.ERROR.get(256, Messages.SelectionExpression_FailedToLoadBundle, this.bundleId);
                        break block7;
                    }
                    if ((bundle.getState() & 0x10) != 0) {
                        status = Statuses.ERROR.get(2304, Messages.SelectionExpression_FailedToLoadBundleStopping, this.bundleId);
                        break block7;
                    }
                    bundle.start();
                    if (!bundle.getVersion().equals((Object)this.bundleVersion)) {
                        this.userExpr = WithBundle.getUserDefinedExpr(context, this.bundleId, this.className);
                        this.bundleVersion = bundle.getVersion();
                    }
                    return;
                }
                catch (CoreException e) {
                    status = Statuses.ERROR.getMultiStatus(512, new IStatus[]{e.getStatus()}, Messages.SelectionExpression_FailedToLoadBundleCoreException, this.bundleId);
                }
                catch (Throwable e) {
                    status = Statuses.ERROR.getMultiStatus(512, null, e, Messages.SelectionExpression_FailedToLoadBundleException, this.bundleId);
                }
            }
            this.userExpr = new BadExpr(status);
            this.bundleVersion = null;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(32);
            sb.append("bundle:").append(this.bundleId);
            if (this.bundleVersion != null) {
                sb.append('_').append(this.bundleVersion);
            }
            if (this.className != null) {
                sb.append(' ').append(this.className);
            }
            return sb.toString();
        }

        private static ISelectionExpression getUserDefinedExpr(ISelectionExpression.EvaluationContext context, String bundleId, String className) throws CoreException {
            IConfigurationElement config = WithBundle.findMatchingConfiguration(context, bundleId, className);
            String classAttr = config.getAttribute(CLASS_ATTR);
            try {
                ISelectionExpression expr = (ISelectionExpression)config.createExecutableExtension(CLASS_ATTR);
                return expr;
            }
            catch (CoreException e) {
                if (e.getStatus() != null) {
                    throw e;
                }
                String errMsg = NLS.bind(Messages.SelectionExpression_FailedToLoadClassDueTo, (Object)classAttr, (Object)e.getLocalizedMessage());
                throw new CoreException((IStatus)Statuses.WARNING.get(768, e, errMsg, new Object[0]));
            }
            catch (ClassCastException cce) {
                String errMsg = NLS.bind(Messages.SelectionExpression_ClassShouldImplement, (Object)classAttr, (Object)ISelectionExpression.class.getName());
                throw new CoreException((IStatus)Statuses.WARNING.get(1024, cce, errMsg, new Object[0]));
            }
            catch (Exception e) {
                String errMsg = NLS.bind(Messages.SelectionExpression_FailedToLoadClassDueTo, (Object)classAttr, (Object)e.getLocalizedMessage());
                throw new CoreException((IStatus)Statuses.WARNING.get(768, e, errMsg, new Object[0]));
            }
        }

        private static IConfigurationElement findMatchingConfiguration(ISelectionExpression.EvaluationContext context, String bundleId, String className) throws CoreException {
            return CLASS_FINDER.findMatchingConfigurationElement(context, NAMESPACE, EXPR_EXTN_PT, bundleId, className);
        }

        private static boolean offeringToleratesPre_1_2(ISelectionExpression.EvaluationContext context) {
            if (!(context instanceof IAdaptable)) {
                return true;
            }
            IAdaptable adaptable = (IAdaptable)context;
            IOfferingOrFix oof = (IOfferingOrFix)adaptable.getAdapter(IOfferingOrFix.class);
            if (oof == null) {
                return true;
            }
            return OfferingUtil.isMinimumAgentToleranceLessThan(oof, new Version(1, 2, 0));
        }
    }

    private static class WithIdOnly
    extends SelectionExpression
    implements ISelectionExpression.ISelectedById {
        private final String id;

        WithIdOnly(String id) {
            Assert.isNotNull((Object)id);
            if (PredefinedSelectors.contains(id)) {
                throw new IllegalArgumentException(NLS.bind(Messages.SelectionExpression_SelectedByStmtShouldHaveValue, (Object)"selectedBy", (Object)id));
            }
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public IStatus evaluate(ISelectionExpression.EvaluationContext context) {
            Assert.isNotNull((Object)context);
            return SelectionOperator.fixNull(context.evaluate(this.id, null));
        }

        public String toString() {
            return this.id;
        }
    }

    private static class WithOperator
    extends SelectionExpression
    implements ISelectionExpression.ISelectedByOperator {
        private final SelectionOperator operator;

        WithOperator(SelectionOperator operator) {
            Assert.isLegal((boolean)operator.validate(), (String)NLS.bind(Messages.SelectionExpression_InvalidOperator, (Object)operator.getOpImage()));
            this.operator = operator;
        }

        @Override
        public ISelectionExpression.ISelectionOperator getOperator() {
            return this.operator;
        }

        @Override
        public IStatus evaluate(ISelectionExpression.EvaluationContext context) {
            Assert.isNotNull((Object)context);
            return this.operator.execute(context);
        }

        public String toString() {
            return this.operator.toString();
        }
    }

    private static class WithPredefinedId
    extends SelectionExpression
    implements ISelectionExpression.ISelectedByPredefinedId {
        private final String id;
        private final String value;

        WithPredefinedId(String id, String value) {
            Assert.isNotNull((Object)id);
            if (!PredefinedSelectors.contains(id) && !PredefinedSelectors.isVariable(id)) {
                throw new IllegalArgumentException(NLS.bind(Messages.SelectionExpression_SelectedByStmtShouldNotHaveValue, (Object)"selectedBy", (Object)id));
            }
            this.id = id;
            this.value = value;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public IStatus evaluate(ISelectionExpression.EvaluationContext context) {
            IStatus result;
            Assert.isNotNull((Object)context);
            if (PredefinedSelectors.isVariable(this.id) || context.canEvaluatePredefineds()) {
                result = SelectionOperator.fixNull(context.evaluate(this.id, this.value));
            } else {
                IStatus iStatus = result = PredefinedSelectors.matches(this.id, this.value) ? Status.OK_STATUS : Status.CANCEL_STATUS;
            }
            if (result == Status.CANCEL_STATUS) {
                String msg = String.valueOf(this.id) + " = " + this.value;
                result = Statuses.ERROR.get(msg, new Object[0]);
            }
            return result;
        }

        public String toString() {
            if (this.value != null && this.value.length() > 0) {
                return String.valueOf(this.id) + "==" + this.value;
            }
            return this.id;
        }
    }

    private static class WithTarget
    extends SelectionExpression
    implements ISelectionExpression.ISelectedByTarget {
        private final String targetId;

        public WithTarget(String targetId) {
            this.targetId = targetId;
        }

        public String toString() {
            return this.targetId;
        }

        @Override
        public String getTargetId() {
            return this.targetId;
        }

        @Override
        public IStatus evaluate(ISelectionExpression.EvaluationContext context) {
            return ((ISelectionExpression.SuFragmentEvaluationContext)context).evaluateInTarget(this.targetId);
        }
    }
}

