/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallationContext;
import com.ibm.cic.common.core.model.InstallationContextScope;
import com.ibm.cic.common.core.model.internal.ShareableUnit;
import com.ibm.icu.util.StringTokenizer;
import org.osgi.framework.Version;

public class InstallationContext
extends ShareableUnit
implements IInstallationContext {
    private boolean isShareable = true;
    private boolean isQualifiable = false;
    private InstallationContextScope scope = InstallationContextScope.NONE_SCOPE;
    private String[] adaptorTypes;

    public InstallationContext(IIdentity id, Version version) {
        super(id, version);
    }

    @Override
    public boolean definesAnInstallationContext() {
        return true;
    }

    @Override
    public boolean isShareable() {
        return this.isShareable;
    }

    @Override
    public void setIsShareable(boolean shareable) {
        this.isShareable = shareable;
    }

    @Override
    public boolean isQualifiable() {
        return this.isQualifiable;
    }

    @Override
    public void setIsQualifiable(boolean qualifiable) {
        this.isQualifiable = qualifiable;
    }

    @Override
    public InstallationContextScope getScope() {
        return this.scope;
    }

    @Override
    public void setScope(InstallationContextScope scope) {
        this.scope = scope;
    }

    @Override
    public String[] getAdaptorTypes() {
        return this.adaptorTypes != null ? this.adaptorTypes : new String[]{};
    }

    @Override
    public void setAdaptorTypes(String[] adaptorTypes) {
        this.adaptorTypes = adaptorTypes;
    }

    @Override
    public void setAdaptorTypes(String adaptors) {
        if (adaptors != null) {
            StringTokenizer tokenizer = new StringTokenizer(adaptors, ",");
            this.adaptorTypes = new String[tokenizer.countTokens()];
            int index = 0;
            while (index < this.adaptorTypes.length && tokenizer.hasMoreTokens()) {
                this.adaptorTypes[index] = tokenizer.nextToken().trim();
                ++index;
            }
        } else {
            this.adaptorTypes = new String[0];
        }
    }

    @Override
    public String getAdaptorTypesImage() {
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        while (index < this.adaptorTypes.length) {
            buffer.append(String.valueOf(this.adaptorTypes[index]) + (index < this.adaptorTypes.length - 1 ? ", " : ""));
            ++index;
        }
        return buffer.toString();
    }

    @Override
    public String[] getPropertyKeys() {
        return this.getProperties().getPropertyKeys();
    }
}

