/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.internal.AbstractFeatureBase;
import java.util.ArrayList;
import java.util.List;

public class FeatureGroup
extends AbstractFeatureBase
implements IFeatureGroup {
    private List children;
    private boolean exclusive;

    public FeatureGroup() {
        this.setMutuallyExclusiveChildren(false);
    }

    @Override
    public List getChildren() {
        if (this.children == null) {
            this.children = new ArrayList(2);
        }
        return this.children;
    }

    @Override
    public void addChild(IFeatureBase child) {
        this.getChildren().add(child);
        this.setMyselfAsParentOf(child);
    }

    @Override
    public List getGroups() {
        ArrayList<IFeatureBase> groups = new ArrayList<IFeatureBase>();
        if (this.children != null) {
            for (IFeatureBase nextChild : this.children) {
                if (!(nextChild instanceof IFeatureGroup)) continue;
                groups.add(nextChild);
            }
        }
        return groups;
    }

    @Override
    public void addGroup(IFeatureGroup group) {
        this.getChildren().add(group);
        this.setMyselfAsParentOf(group);
    }

    @Override
    public List getFeatures() {
        ArrayList<IFeatureBase> features = new ArrayList<IFeatureBase>();
        if (this.children != null) {
            for (IFeatureBase nextChild : this.children) {
                if (!(nextChild instanceof IFeature)) continue;
                features.add(nextChild);
            }
        }
        return features;
    }

    @Override
    public void addFeature(IFeature feature) {
        this.getChildren().add(feature);
        this.setMyselfAsParentOf(feature);
    }

    @Override
    public boolean hasMutuallyExclusiveChildren() {
        return this.exclusive;
    }

    @Override
    public void setMutuallyExclusiveChildren(boolean value) {
        this.exclusive = value;
    }

    @Override
    protected String getElementImage() {
        return "featureGroup";
    }

    private void setMyselfAsParentOf(IFeatureBase child) {
        if (child instanceof AbstractFeatureBase) {
            AbstractFeatureBase offspring = (AbstractFeatureBase)child;
            offspring.setParent(this);
        }
    }
}

