/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class EnumMapper {
    public static final int UNKNOWN = -1;
    private final int lastEnum;
    private final String[] enumToName;
    private final Map nameToEnum;
    private final int[] allEnums;

    public EnumMapper(int lastEnum, Class enumClass) {
        this.lastEnum = lastEnum;
        this.enumToName = new String[lastEnum + 1];
        Field[] fields = enumClass.getDeclaredFields();
        this.nameToEnum = new HashMap(fields.length);
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int modifiers = field.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) {
                String name = EnumMapper.normalizeName(field.getName());
                try {
                    int value = field.getInt(null);
                    if (value >= 0 && value <= lastEnum) {
                        this.enumToName[value] = name;
                        this.nameToEnum.put(name, value);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        this.allEnums = new int[this.nameToEnum.size()];
        int i = 0;
        int phase = 0;
        while (phase < this.enumToName.length) {
            if (this.enumToName[phase] != null) {
                this.allEnums[i++] = phase;
            }
            ++phase;
        }
    }

    public int[] getAllEnums() {
        return this.allEnums;
    }

    public String[] getAllNames() {
        return this.enumToName;
    }

    public int nameToEnum(String s) {
        Integer enumValue = (Integer)this.nameToEnum.get(EnumMapper.normalizeName(s));
        return enumValue == null ? -1 : enumValue;
    }

    public String enumToName(int enumValue) {
        String name;
        if (enumValue >= 0 && enumValue <= this.lastEnum && (name = this.enumToName[enumValue]) != null) {
            return name;
        }
        return "_unknown_";
    }

    private static String normalizeName(String name) {
        return name.toLowerCase(Locale.ENGLISH);
    }
}

