/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.internal.BuilderDataContainer;
import com.ibm.cic.common.core.model.internal.RequiredShareableEntity;
import com.ibm.cic.common.core.model.internal.SelExprHelper;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class ContentSelector
extends BuilderDataContainer
implements IContentSelector {
    private IIdentity id;
    private IShareableEntity shareableEntity;
    private boolean isPrivate = false;
    private boolean isRestricted;
    private boolean isInternal = false;
    private ISelectionExpression expr;
    private Information information;
    protected Set internalSelections;
    protected Set requiredShareableEntities;

    public ContentSelector(IIdentity id) {
        this.id = id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IContentSelector) {
            IContentSelector that = (IContentSelector)obj;
            return this.getIdentity().equals(that.getIdentity());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<selector id='").append(this.id).append("'");
        if (this.isPrivate) {
            sb.append(" private='").append(this.isPrivate).append("'");
        }
        if (this.isRestricted) {
            sb.append(" restricted='");
            sb.append(this.isRestricted);
            sb.append("'");
        }
        if (this.isInternal) {
            sb.append(" internal='");
            sb.append(this.isInternal);
            sb.append("'");
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public IShareableEntity getShareableEntity() {
        return this.shareableEntity;
    }

    @Override
    public void setShareableEntity(IShareableEntity shareableEntity) {
        this.shareableEntity = shareableEntity;
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate;
    }

    @Override
    public Information getInformation() {
        return this.information;
    }

    @Override
    public void setInformation(Information information) {
        this.information = information;
    }

    @Override
    public ISelectionExpression getExpression() {
        return this.expr;
    }

    @Override
    public void setExpression(ISelectionExpression expr) {
        this.expr = expr;
    }

    @Override
    public boolean isExpressionReferencing(IContentSelector selector) {
        return SelExprHelper.isExpressionReferencing(this, selector);
    }

    @Override
    public void setKeepPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    @Override
    public IIdentity getIdentity() {
        return this.id;
    }

    @Override
    public void setIdentity(IIdentity id) {
        this.id = id;
    }

    @Override
    public Set getInternalSelections() {
        if (this.internalSelections == null) {
            this.internalSelections = new LinkedHashSet(2);
        }
        return this.internalSelections;
    }

    @Override
    public Set getRequiredShareableEntities() {
        if (this.requiredShareableEntities == null) {
            this.requiredShareableEntities = new LinkedHashSet(2);
        }
        return this.requiredShareableEntities;
    }

    public void addRequiredShareableEntity(RequiredShareableEntity rse) {
        this.getRequiredShareableEntities().add(rse);
        rse.setContainingSelector(this);
    }

    @Override
    public boolean isRestricted() {
        return this.isRestricted;
    }

    @Override
    public void setRestricted(boolean value) {
        this.isRestricted = value;
    }

    @Override
    public boolean isInternal() {
        return this.isInternal;
    }

    @Override
    public void setInternal(boolean value) {
        this.isInternal = value;
    }
}

