/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IInstallableUnit;
import org.osgi.framework.Version;

public class ContentIdVersion {
    private final Class cls;
    private final String id;
    private final Version version;

    private ContentIdVersion(Class cls, String id, Version version) {
        this.cls = cls;
        this.id = id;
        this.version = version;
    }

    public String getId() {
        return this.id;
    }

    public Version getVersion() {
        return this.version;
    }

    public static ContentIdVersion create(IContent content) {
        if (content instanceof IInstallableUnit) {
            IInstallableUnit iu = (IInstallableUnit)content;
            return new ContentIdVersion(content.getClass(), iu.getQualifiedId().getId(), content.getVersion());
        }
        return new ContentIdVersion(content.getClass(), content.getIdentity().getId(), content.getVersion());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ContentIdVersion)) {
            return false;
        }
        ContentIdVersion that = (ContentIdVersion)obj;
        return this.id.equals(that.id) && this.version.equals((Object)that.version) && this.cls.equals(that.cls);
    }

    public int hashCode() {
        return this.id.hashCode() ^ this.version.hashCode();
    }

    public String toString() {
        return String.valueOf(this.id) + "_" + this.version;
    }
}

