/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.model.FeatureKind;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.model.ISelectionExpressionContainer;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.internal.BuilderDataContainer;
import com.ibm.cic.common.core.model.internal.Util;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

abstract class AbstractFeatureBase
extends BuilderDataContainer
implements IFeatureBase,
ISelectionExpressionContainer {
    private FeatureKind kind;
    private Information information;
    private IFeatureGroup parent;
    private ISelectionExpression expression;
    private ISelectionExpressionContainer kindExprHolder;

    AbstractFeatureBase() {
    }

    @Override
    public FeatureKind getKind() {
        return this.kind;
    }

    @Override
    public void setKind(FeatureKind kind) {
        this.kind = kind;
        this.kindExprHolder = FeatureKind.DYNAMICALLY_SELECTED.equals(this.kind) ? new KindExprHodler() : null;
    }

    @Override
    public Information getInformation() {
        return this.information;
    }

    @Override
    public IFeatureGroup getParent() {
        return this.parent;
    }

    @Override
    public void setInformation(Information info) {
        this.information = info;
    }

    @Override
    public boolean isRequired() {
        return this.kind.isRequired();
    }

    @Override
    public boolean isSelectedByDefault() {
        return this.isSelectedByDefault(ISelectionExpression.NULL_EVALUATION_CONTEXT);
    }

    @Override
    public boolean isSelectedByDefault(ISelectionExpression.EvaluationContext context) {
        if (this.kind.isSelectedByDefault()) {
            return true;
        }
        if (this.hasKindExpression()) {
            if (context.mustIgnoreBundles()) {
                return true;
            }
            IStatus status = this.getKindExpression().evaluate(context);
            assert (status == null || status.getSeverity() != 1);
            return status == null ? false : status.isOK();
        }
        return false;
    }

    @Override
    public boolean isVisible() {
        if (this.parent != null) {
            return this.kind.isVisible() && this.parent.isVisible();
        }
        return this.kind.isVisible();
    }

    @Override
    public IStatus evaluateApplicability(ISelectionExpression.EvaluationContext context) {
        IStatus status;
        ISelectionExpression expr = this.getExpression();
        IStatus iStatus = status = expr == null ? Status.OK_STATUS : expr.evaluate(context);
        assert (status == null || status.getSeverity() != 1);
        return status == null ? Status.CANCEL_STATUS : status;
    }

    @Override
    public boolean hasApplicabilityFlag(IStatus applicabilityStatus, int flag) {
        return Util.hasApplicabilityFlag(applicabilityStatus, flag);
    }

    @Override
    public ISelectionExpression getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(ISelectionExpression expr) {
        this.expression = expr;
    }

    public final String toString() {
        String more;
        FeatureKind fk;
        StringBuffer sb = new StringBuffer("<");
        sb.append(this.getElementImage());
        Information info = this.getInformation();
        if (info != null) {
            sb.append(" name='").append(info.getName()).append('\'');
        }
        if ((fk = this.getKind()) != null) {
            sb.append(" kind='").append(fk).append('\'');
        }
        if ((more = this.getAdditionalAttributes()) != null) {
            if (!more.startsWith(" ")) {
                sb.append(" ");
            }
            sb.append(more);
        }
        sb.append("/>");
        return sb.toString();
    }

    protected String getAdditionalAttributes() {
        return null;
    }

    protected abstract String getElementImage();

    protected void setParent(IFeatureGroup group) {
        this.parent = group;
    }

    boolean hasKindExpression() {
        return this.kindExprHolder != null && this.kindExprHolder.getExpression() != null;
    }

    ISelectionExpression getKindExpression() {
        if (this.kindExprHolder != null) {
            return this.kindExprHolder.getExpression();
        }
        return null;
    }

    ISelectionExpressionContainer getKindExpressionHolder() {
        return this.kindExprHolder;
    }

    private static final class KindExprHodler
    implements ISelectionExpressionContainer {
        private ISelectionExpression expr;

        private KindExprHodler() {
        }

        @Override
        public ISelectionExpression getExpression() {
            return this.expr;
        }

        @Override
        public void setExpression(ISelectionExpression expr) {
            this.expr = expr;
        }
    }
}

