/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.expander;

import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IIncludedShareableEntity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallationContext;
import com.ibm.cic.common.core.model.IRequiredShareableEntity;
import com.ibm.cic.common.core.model.ISelectionExpressionManipulator;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IShareableItem;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.expander.IContextState;
import com.ibm.cic.common.core.model.expander.SelectorExpander;
import com.ibm.cic.common.core.utils.MapList;
import com.ibm.cic.common.core.utils.MapSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

class SimpleContextState
implements IContextState {
    static final IIdentity DUMMY = new SimpleIdentity("<dummy>");
    private final IIdentity id;
    private final SimpleContextState parent;
    private MapSet<IIdentity, IIdentity> dependents = MapSet.newHash();
    private final MapSet<IIdentity, IRequiredShareableEntity> icMap = MapSet.newLinkedHash();
    private final MapSet<IIdentity, IShareableEntity> candidates = MapSet.newHash();
    private final MapSet<IIdentity, ISuFragment> fragments = MapSet.newLinkedHash();
    private Map<IIdentity, SimpleContextState> children = Collections.emptyMap();
    private final Set<IShareableEntity> parentSEs = new LinkedHashSet<IShareableEntity>();

    SimpleContextState() {
        this(null, null);
    }

    SimpleContextState(IIdentity id, SimpleContextState parent) {
        this.id = id;
        this.parent = parent;
    }

    SimpleContextState createSubContext(IIdentity childId) {
        return new SimpleContextState(childId, this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(32);
        sb.append(this.isRoot() ? "root" : this.id.getId()).append(" (");
        sb.append(this.dependents.size()).append(" SEs, ");
        if (!this.fragments.isEmpty()) {
            sb.append(this.fragments.size()).append(" fragments, ");
        }
        sb.append(this.getSubContexts().size()).append(" children)");
        return sb.toString();
    }

    @Override
    public IIdentity getIdentity() {
        return this.id;
    }

    @Override
    public String getFullId() {
        if (this.isRoot()) {
            return "<root>";
        }
        if (this.parent.isRoot()) {
            return this.id.getId();
        }
        return String.valueOf(this.parent.getFullId()) + '/' + this.id.getId();
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public IContextState getParent() {
        return this.parent;
    }

    boolean hasSuFragments() {
        return !this.fragments.isEmpty() || this.parent != null && this.parent.hasSuFragments();
    }

    @Override
    public MapSet<IIdentity, ISuFragment> getSuFragments() {
        if (this.parent == null) {
            return this.fragments;
        }
        MapSet<IIdentity, ISuFragment> parentFragments = this.parent.getSuFragments();
        if (parentFragments.isEmpty()) {
            return this.fragments;
        }
        if (this.fragments.isEmpty()) {
            return parentFragments;
        }
        MapSet<IIdentity, ISuFragment> result = MapSet.newLinkedHash(this.fragments.size() + parentFragments.size());
        result.addAll(this.fragments);
        result.addAll(parentFragments);
        return result;
    }

    Set<IIdentity> getDependents(IIdentity seId) {
        return this.dependents.get(seId);
    }

    Set<IIdentity> getAllSeIds() {
        return this.dependents.keySet();
    }

    int getCandidateCount() {
        return this.candidates.size();
    }

    Set<IShareableEntity> getCandidates(IIdentity seId) {
        return this.candidates.get(seId);
    }

    @Override
    public Set<IShareableEntity> getParentSEs() {
        return Collections.unmodifiableSet(this.parentSEs);
    }

    public Collection<? extends SimpleContextState> getSubContexts() {
        return this.children.values();
    }

    SimpleContextState getSubContext(IIdentity childId) {
        SimpleContextState child;
        if (this.children.isEmpty()) {
            this.children = new LinkedHashMap<IIdentity, SimpleContextState>(2);
        }
        if ((child = this.children.get(childId)) == null) {
            child = this.createSubContext(childId);
            this.children.put(childId, child);
        }
        return child;
    }

    protected void add(SimpleContextState that) {
        this.dependents.addAll(that.dependents);
        this.icMap.addAll(that.icMap);
        this.candidates.addAll(that.candidates);
        this.parentSEs.addAll(that.parentSEs);
        this.fragments.addAll(that.fragments);
        for (IIdentity childId : that.children.keySet()) {
            this.getSubContext(childId).add(that.getSubContext(childId));
        }
    }

    void addFragment(ISuFragment fragment) {
        this.fragments.add(fragment.getIdentity(), fragment);
    }

    void addCandidate(IShareableEntity se) {
        this.candidates.add(se.getIdentity(), se);
    }

    protected void addInclude(IIncludedShareableEntity ise, IShareableEntity includer) {
        this.addDependent(ise.getIdentity(), includer.getIdentity(), true);
    }

    protected void addRequire(IRequiredShareableEntity rse, IShareableEntity requirer) {
        this.addDependent(rse.getShareableId(), requirer.getIdentity(), false);
        if (rse.requiresInstallationContext()) {
            IShareableEntity parentSE = rse.getContainingSelector().getShareableEntity();
            this.icMap.add(parentSE.getIdentity(), rse);
        }
    }

    private void addDependent(IIdentity seId, IIdentity dependentId, boolean isInclude) {
        if (!seId.equals(dependentId)) {
            if (this.dependents.add(seId, dependentId)) {
                String msg = isInclude ? "In {0}: {1} included by {2}" : "In {0}: {1} required by {2}";
                SelectorExpander.log.debug(msg, this.id, seId, dependentId);
            }
            if (!this.dependents.contains(dependentId)) {
                this.dependents.add(dependentId, DUMMY);
            }
        }
    }

    void freeMemory() {
        this.dependents = null;
    }

    SimpleContextState getIC(IShareableEntity se, ISelectionExpressionManipulator exprParent) {
        for (IRequiredShareableEntity requiredIC : this.icMap.get(se.getIdentity())) {
            if (!exprParent.isExpressionReferencing(requiredIC.getContainingSelector())) continue;
            IIdentity contextId = requiredIC.getShareableId();
            SimpleContextState subContext = this.getSubContext(contextId);
            subContext.parentSEs.add(se);
            return subContext;
        }
        return null;
    }

    @Override
    public boolean hasToleranceError() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ensureSubContext(IIdentity childId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IInstallableUnit> getIUs(IShareableItem si) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<IInstallableUnit> getIUs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IInstallationContext getInstallationContext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<IContentSelector> getSelected(IShareableEntity se) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<IShareableEntity> getShareableEntities() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<IIdentity, VersionRange> getTolerances(IShareableEntity se) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkRSEs(Map<IIdentity, Version> selectedSEs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IInstallableUnit> getSelectedIUs(IShareableUnit su, ISuFragment fragment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MapList<ISuFragment, IShareableUnit> getFragmentMap() {
        throw new UnsupportedOperationException();
    }
}

