/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.adapterdata;

import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IErrorReporter;
import com.ibm.cic.common.core.model.adapterdata.IInstallSizeInfo;
import com.ibm.cic.common.core.model.adapterdata.IXMLConstants;
import com.ibm.cic.common.downloads.SizeInfo;
import org.xml.sax.Attributes;

public class SizeInfoParserHelper
implements IXMLConstants {
    private final IErrorReporter reporter;

    public SizeInfoParserHelper(IErrorReporter reporter) {
        this.reporter = reporter;
    }

    public IInstallSizeInfo parseSizeInfoElement(String element, String qName, Attributes attributes) {
        SizeInfo sizeInfo = new SizeInfo();
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("installSize")) {
                try {
                    sizeInfo.setInstallSize(Long.parseLong(value));
                }
                catch (NumberFormatException numberFormatException) {
                    this.reporter.invalidAttributeValue(element, name, value);
                }
            } else {
                this.reporter.unexpectedAttribute("sizeInfo", name, value);
            }
            ++i;
        }
        final long installSize = sizeInfo.getInstallSize();
        return new IInstallSizeInfo(){

            @Override
            public IArtifact getArtifact() {
                return null;
            }

            @Override
            public long getInstallSize() {
                return installSize;
            }

            public String toString() {
                return SizeInfoParserHelper.toXML(this);
            }
        };
    }

    public static String toXML(IInstallSizeInfo installSizeInfo) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('<');
        buffer.append("sizeInfo");
        buffer.append(' ');
        buffer.append("installSize");
        buffer.append("='");
        buffer.append(installSizeInfo.getInstallSize());
        buffer.append("' ");
        buffer.append("/>");
        return buffer.toString();
    }
}

