/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model;

import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.ISelectableNode;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class Walker {
    private boolean canHaveUnresolvedIncludes = false;
    private final Set visitedContent = new HashSet();

    public void doOffering(IOffering offering) throws Exception {
    }

    public void doFix(IFix fix) throws Exception {
    }

    public void doAssembly(IAssembly assembly) throws Exception {
    }

    public void doShareableUnit(IShareableUnit su) throws Exception {
    }

    public void doSuFragment(ISuFragment suFragment) throws Exception {
    }

    public void doInstallableUnit(IInstallableUnit iu) throws Exception {
    }

    public void doUnit(IContent unit) throws Exception {
    }

    public void doOffering(IOffering offering, IProgressMonitor monitor) throws Exception {
        monitor.beginTask(null, 1);
        try {
            this.doOffering(offering);
        }
        finally {
            monitor.done();
        }
    }

    public void doFix(IFix fix, IProgressMonitor monitor) throws Exception {
        monitor.beginTask(null, 1);
        try {
            this.doFix(fix);
        }
        finally {
            monitor.done();
        }
    }

    public void doAssembly(IAssembly assembly, IProgressMonitor monitor) throws Exception {
        monitor.beginTask(null, 1);
        try {
            this.doAssembly(assembly);
        }
        finally {
            monitor.done();
        }
    }

    public void doInstallableUnit(IInstallableUnit iu, IProgressMonitor monitor) throws Exception {
        monitor.beginTask(null, 1);
        try {
            this.doInstallableUnit(iu);
        }
        finally {
            monitor.done();
        }
    }

    public void doShareableUnit(IShareableUnit su, IProgressMonitor monitor) throws Exception {
        monitor.beginTask(null, 1);
        try {
            this.doShareableUnit(su);
        }
        finally {
            monitor.done();
        }
    }

    public void doSuFragment(ISuFragment suFragment, IProgressMonitor monitor) throws Exception {
        monitor.beginTask(null, 1);
        try {
            this.doSuFragment(suFragment);
        }
        finally {
            monitor.done();
        }
    }

    public void doUnit(IContent unit, IProgressMonitor monitor) throws Exception {
        monitor.beginTask(null, 1);
        try {
            this.doUnit(unit);
        }
        finally {
            monitor.done();
        }
    }

    public Walker allowUnresolvedIncludes() {
        this.canHaveUnresolvedIncludes = true;
        return this;
    }

    protected boolean canHaveUnresolvedIncludes() {
        return this.canHaveUnresolvedIncludes;
    }

    protected IContent getContent(ISelectableNode include) {
        return include.getContent();
    }

    protected IAssembly getAssembly(IOfferingOrFix offeringOrFix) {
        return offeringOrFix.getAssembly();
    }

    public final void walkIncludes(IContent root) throws InvocationTargetException {
        this.walkIncludes(root, null);
    }

    public final void walkIncludesUnchecked(IContent root) {
        try {
            this.walkIncludes(root);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e.getTargetException());
        }
    }

    public final void walkIncludesUnchecked(IContent root, IProgressMonitor monitor) {
        try {
            this.walkIncludes(root, monitor);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e.getTargetException());
        }
    }

    public final void walkIncludes(IContent root, IProgressMonitor monitor) throws InvocationTargetException {
        int[] nArray;
        if (root == null) {
            if (this.canHaveUnresolvedIncludes()) {
                return;
            }
            throw new IllegalArgumentException("Null content!");
        }
        if (this.visitedContent.contains(root)) {
            return;
        }
        this.visitedContent.add(root);
        List children = root.hasChildren() ? root.getChildren() : Collections.EMPTY_LIST;
        int childCost = root instanceof IShareableEntity ? 20 : 1;
        int childrenCost = children.size() * childCost;
        if (root instanceof IOfferingOrFix) {
            int[] nArray2 = new int[4];
            nArray2[0] = 1;
            nArray2[1] = 1;
            nArray2[2] = 95;
            nArray = nArray2;
            nArray2[3] = childrenCost;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 1;
            nArray3[1] = 1;
            nArray = nArray3;
            nArray3[2] = childrenCost;
        }
        int[] costs = nArray;
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, costs);
        try {
            block28: {
                try {
                    this.doUnit(root, pm.next());
                    if (root instanceof IOfferingOrFix) {
                        IOfferingOrFix offeringOrFix = (IOfferingOrFix)root;
                        if (offeringOrFix instanceof IOffering) {
                            this.doOffering((IOffering)offeringOrFix, pm.next());
                        } else if (offeringOrFix instanceof IFix) {
                            this.doFix((IFix)offeringOrFix, pm.next());
                        } else {
                            throw new AssertionError((Object)("Bad type: " + root));
                        }
                        IAssembly asm = this.getAssembly(offeringOrFix);
                        this.walkIncludes(asm, pm.next());
                        break block28;
                    }
                    if (root instanceof IAssembly) {
                        IAssembly asm = (IAssembly)root;
                        this.doAssembly(asm, pm.next());
                        break block28;
                    }
                    if (root instanceof IShareableUnit) {
                        IShareableUnit su = (IShareableUnit)root;
                        this.doShareableUnit(su, pm.next());
                        break block28;
                    }
                    if (root instanceof ISuFragment) {
                        ISuFragment suFragment = (ISuFragment)root;
                        this.doSuFragment(suFragment, pm.next());
                        break block28;
                    }
                    if (root instanceof IInstallableUnit) {
                        this.doInstallableUnit((IInstallableUnit)root, pm.next());
                        break block28;
                    }
                    throw new AssertionError((Object)("unexpected unit type: " + root));
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
            if (pm.isCanceled()) {
                return;
            }
            SplitProgressMonitor pm2 = new SplitProgressMonitor(pm.next(), children.size());
            for (Object nextChild : children) {
                IContent contentChild = null;
                if (nextChild instanceof IContent) {
                    contentChild = (IContent)nextChild;
                } else if (nextChild instanceof ISelectableNode) {
                    ISelectableNode include = (ISelectableNode)nextChild;
                    contentChild = this.getContent(include);
                }
                if (contentChild == null) {
                    if (!this.canHaveUnresolvedIncludes()) {
                        throw new AssertionError((Object)("unresolved include in " + root + ": " + nextChild));
                    }
                    continue;
                }
                this.walkIncludes(contentChild, pm2.next());
                if (!pm.isCanceled()) continue;
                return;
            }
        }
        finally {
            pm.done();
        }
    }
}

