/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model;

import com.ibm.cic.common.core.model.internal.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InstallationContextScope {
    private static final ArrayList installContextScopes = new ArrayList();
    private static int nextOrdinal = 0;
    public static final InstallationContextScope NOT_A_SCOPE = new InstallationContextScope("NotAnInstallContextScope", Messages.NotAnInstallContextScope);
    public static final InstallationContextScope SYSTEM_SCOPE = new InstallationContextScope("System", Messages.SystemInstallContextScope);
    public static final InstallationContextScope PROFILE_SCOPE = new InstallationContextScope("Profile", Messages.ProfileInstallContextScope);
    public static final InstallationContextScope NONE_SCOPE = new InstallationContextScope("None", Messages.NoneInstallContextScope);
    private final transient String displayName;
    private final transient String name;
    private final int ordinal;

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public final int getOrdinal() {
        return this.ordinal;
    }

    public String toString() {
        return this.getName();
    }

    public static InstallationContextScope nameToInstallContextScope(String s) {
        for (InstallationContextScope nextScope : InstallationContextScope.getInstallContextScopes()) {
            if (!nextScope.name.equals(s)) continue;
            return nextScope;
        }
        return NOT_A_SCOPE;
    }

    public static InstallationContextScope valueToInstallContextScope(int value) {
        return value >= 0 && value < installContextScopes.size() ? (InstallationContextScope)installContextScopes.get(value) : NOT_A_SCOPE;
    }

    public static List getInstallContextScopes() {
        return Collections.unmodifiableList(installContextScopes);
    }

    protected InstallationContextScope(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
        this.ordinal = nextOrdinal++;
        installContextScopes.add(this.ordinal, this);
    }
}

