/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model;

import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IBuilderData;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IFixApplicableOffering;
import com.ibm.cic.common.core.model.IFixCategory;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IIncludedShareableEntity;
import com.ibm.cic.common.core.model.IIncludedSuFragment;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallableUnitSelector;
import com.ibm.cic.common.core.model.IInstallationContext;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IProblemResolved;
import com.ibm.cic.common.core.model.IProblemsResolved;
import com.ibm.cic.common.core.model.IRequiredShareableEntity;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IShareableEntitySelector;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.IncludedShareableEntity;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.build.internal.BuilderData;
import com.ibm.cic.common.core.model.internal.Assembly;
import com.ibm.cic.common.core.model.internal.Feature;
import com.ibm.cic.common.core.model.internal.FeatureGroup;
import com.ibm.cic.common.core.model.internal.Fix;
import com.ibm.cic.common.core.model.internal.FixApplicableOffering;
import com.ibm.cic.common.core.model.internal.FixCategory;
import com.ibm.cic.common.core.model.internal.IncludedSuFragment;
import com.ibm.cic.common.core.model.internal.InstallableUnit;
import com.ibm.cic.common.core.model.internal.InstallableUnitSelector;
import com.ibm.cic.common.core.model.internal.InstallationContext;
import com.ibm.cic.common.core.model.internal.Offering;
import com.ibm.cic.common.core.model.internal.Problem;
import com.ibm.cic.common.core.model.internal.ProblemsResolved;
import com.ibm.cic.common.core.model.internal.RequiredShareableEntity;
import com.ibm.cic.common.core.model.internal.ShareableEntitySelector;
import com.ibm.cic.common.core.model.internal.ShareableUnit;
import com.ibm.cic.common.core.model.internal.SuFragment;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class CicFactory {
    private static final CicFactory m_cicFactory = new CicFactory();

    public IAssembly createAssembly(IIdentity id, Version version) {
        return new Assembly(id, version);
    }

    public IAssembly createAssembly(String id, String version) {
        return new Assembly(new SimpleIdentity(id), new Version(version));
    }

    public IShareableUnit createShareableUnit(IIdentity id, Version version) {
        return new ShareableUnit(id, version);
    }

    public IShareableUnit createShareableUnit(String id, String version) {
        return new ShareableUnit(new SimpleIdentity(id), new Version(version));
    }

    public ISuFragment createSuFragment(IIdentity id, Version version) {
        return new SuFragment(id, version);
    }

    public ISuFragment createSuFragment(String id, String version) {
        return new SuFragment(new SimpleIdentity(id), new Version(version));
    }

    public IInstallationContext createInstallationContext(IIdentity id, Version version) {
        return new InstallationContext(id, version);
    }

    public IInstallationContext createInstallationContext(String id, String version) {
        return new InstallationContext(new SimpleIdentity(id), new Version(version));
    }

    public IInstallableUnit createInstallableUnit(IIdentity id, Version version) {
        return new InstallableUnit(id, version);
    }

    public IInstallableUnit createInstallableUnit(String id, String version) {
        return new InstallableUnit(new SimpleIdentity(id), new Version(version));
    }

    public IFix createFix(IIdentity id, Version version) {
        return new Fix(id, version);
    }

    public IFix createFix(String id, String version) {
        return new Fix(new SimpleIdentity(id), new Version(version));
    }

    public IOffering createOffering(IIdentity id, Version version) {
        return new Offering(id, version);
    }

    public IOffering createOffering(String id, String version) {
        return new Offering(new SimpleIdentity(id), new Version(version));
    }

    public IFeature createFeature(IIdentity id) {
        return new Feature(id);
    }

    public IFeatureGroup createFeatureGroup() {
        return new FeatureGroup();
    }

    public IInstallableUnitSelector createInstallableUnitSelector(IIdentity id) {
        return new InstallableUnitSelector(id);
    }

    public IShareableEntitySelector createShareableEntitySelector(IIdentity id) {
        return new ShareableEntitySelector(id);
    }

    public IIncludedShareableEntity createIncludedShareableEntity(IShareableEntity shareableEntity, VersionRange tolerance) {
        return new IncludedShareableEntity(shareableEntity, tolerance);
    }

    public IIncludedShareableEntity createIncludedShareableEntity(IIdentity id, Version version, VersionRange tolerance) {
        return new IncludedShareableEntity(id, version, tolerance);
    }

    public IIncludedShareableEntity createIncludedShareableEntity(IShareableEntity shareableEntity) {
        return new IncludedShareableEntity(shareableEntity);
    }

    public IIncludedSuFragment createIncludedSuFragment(ISuFragment suFragment) {
        return new IncludedSuFragment(suFragment);
    }

    public IIncludedSuFragment createIncludedSuFragment(IIdentity id, Version version) {
        return new IncludedSuFragment(id, version);
    }

    public IRequiredShareableEntity createRequiredShareableEntity(IIdentity shareableId, VersionRange tolerance) {
        RequiredShareableEntity rse = new RequiredShareableEntity(shareableId);
        rse.setTolerance(tolerance);
        return rse;
    }

    public IFixApplicableOffering createFixApplicableOffering(IIdentity offeringId, VersionRange tolerance) {
        FixApplicableOffering applicableOffering = new FixApplicableOffering(offeringId, tolerance);
        return applicableOffering;
    }

    public IFixCategory createFixCategory(String id, String name) {
        FixCategory category = new FixCategory(id, name);
        return category;
    }

    public IProblemResolved createProblem(String id, String displayId) {
        Problem problem = new Problem(id, displayId);
        return problem;
    }

    public IProblemsResolved createProblemsResolved() {
        ProblemsResolved resolves = new ProblemsResolved();
        return resolves;
    }

    public IBuilderData createBuildData(String name) {
        return new BuilderData(name);
    }

    public static CicFactory getInstance() {
        return m_cicFactory;
    }
}

