/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.volrepo;

import com.ibm.cic.common.core.artifactrepo.IArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperation;
import com.ibm.cic.common.core.artifactrepo.base.IMultiArtifactOperationArguments;
import com.ibm.cic.common.core.artifactrepo.base.MultiArtifactOperationOptions;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.DiskUtil;
import com.ibm.cic.common.core.artifactrepo.impl.IArtifactGet;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.artifactrepo.impl.RepoAs;
import com.ibm.cic.common.core.internal.artifactrepo.ArtifactSession;
import com.ibm.cic.common.core.internal.repository.RepositoryList;
import com.ibm.cic.common.core.internal.volrepo.DiskMounter;
import com.ibm.cic.common.core.internal.volrepo.IDiskMounter;
import com.ibm.cic.common.core.internal.volrepo.Messages;
import com.ibm.cic.common.core.internal.volrepo.VolumeAtocUtil;
import com.ibm.cic.common.core.internal.volrepo.VolumeSetReader;
import com.ibm.cic.common.core.internal.volrepo.VolumeSetReaderHelperClassic;
import com.ibm.cic.common.core.internal.volrepo.WrappedLocator;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.msdrepo.MasterSetupDiskRepository;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.IRepositoryPool;
import com.ibm.cic.common.core.repository.PrivateRepositoryPools;
import com.ibm.cic.common.core.repository.RepositoryContext;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.repository.StatusCodes;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.volrepo.DiskTagFile;
import com.ibm.cic.common.core.volrepo.IVolumeRepositoryStatusCodes;
import com.ibm.cic.common.core.volrepo.VolumeBase;
import com.ibm.cic.common.core.volrepo.VolumeRepository;
import com.ibm.cic.common.core.volrepo.VolumesArtifactTableOfContents;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class VolumeSetReaderHelperViaMasterDisk
extends VolumeBase
implements IVolumeRepositoryStatusCodes,
VolumeSetReader.IVolumeSetReaderHelper {
    private DiskMounter diskMounter;
    private String fDiskLabel;
    private final VolumeRepository.IExtDisk1Info extDisk1;
    private IRepositoryPool privatePool;
    private RepositoryGroup innerGroup;
    private DiskArtifactRepo currentDiskArtifactRepo;
    private IArtifactGet artifactGet;

    public VolumeSetReaderHelperViaMasterDisk(VolumeRepository.IExtDisk1Info extDisk1) {
        this.extDisk1 = extDisk1;
    }

    @Override
    public void dispose() {
        if (this.diskMounter != null) {
            this.diskMounter.refresh();
        }
        if (this.innerGroup != null) {
            this.innerGroup.removeAllRepositories();
        }
        if (this.privatePool != null) {
            PrivateRepositoryPools.INSTANCE.releasePrivatePool(this.privatePool);
        }
        this.currentDiskArtifactRepo = null;
    }

    @Override
    public void refresh(boolean askForDisk1) {
        if (this.innerGroup != null) {
            this.innerGroup.refresh();
        }
        this.extDisk1.refresh();
        if (this.diskMounter != null) {
            this.diskMounter.refresh();
        }
    }

    @Override
    public IStatus getStatus(boolean reEvaluate, boolean askForDisk, IProgressMonitor monitor) {
        if (reEvaluate && this.diskMounter != null) {
            this.diskMounter.refresh();
        }
        return Status.OK_STATUS;
    }

    private RepositoryGroup getInnerGroup() {
        if (this.innerGroup == null) {
            String name = "Inner for " + this.extDisk1.getDiskSetId();
            this.privatePool = PrivateRepositoryPools.INSTANCE.createPrivateRepositoryPool(name);
            this.innerGroup = new RepositoryGroup(name, new RepositoryList(), this.privatePool);
        }
        return this.innerGroup;
    }

    @Override
    public IRepository getMetaRepo(IProgressMonitor monitor) {
        return this.extDisk1.getInnerMetaRepo();
    }

    @Override
    public IStatus ensureInsertedDisk(int diskIndex, IProgressMonitor monitor) {
        String diskLabel = this.getDiskLabelNullOnException();
        if (this.diskMounter == null) {
            try {
                this.diskMounter = this.extDisk1.getDiskMounterFactory(diskLabel).mount(null, diskIndex);
            }
            catch (CoreException e) {
                IStatus status = e.getStatus();
                return status;
            }
        }
        return this.diskMounter.ensureInsertedDisk(diskLabel, diskIndex, monitor);
    }

    @Override
    public boolean canFindAvailableDisks() {
        return this.extDisk1.canFindAvailableDisks(this.diskMounter);
    }

    @Override
    public boolean isDiskAvailable(IVolumeAccessByDisk.IDisk disk, IProgressMonitor monitor) throws CoreException {
        if (this.diskMounter != null) {
            IStatus status = this.diskMounter.ensureInsertedDiskNoPrompting(disk.getDiskIndex(), monitor);
            if (status.matches(8)) {
                throw new CoreException(status);
            }
            return status.isOK();
        }
        this.diskMounter = this.extDisk1.findDisk(disk.getDiskNumber());
        return this.diskMounter != null;
    }

    private String getDiskLabelNullOnException() {
        if (this.fDiskLabel == null) {
            try {
                IArtifactSession session = null;
                IProgressMonitor monitor = null;
                VolumeAtocUtil atocUtil = this.getVolumeArtifactToc(session, monitor);
                this.fDiskLabel = atocUtil.getDiskSet().getLabel();
            }
            catch (IOException e) {
                MasterSetupDiskRepository.log.error(e);
            }
            catch (CoreException e) {
                MasterSetupDiskRepository.log.status(e.getStatus());
            }
        }
        return this.fDiskLabel;
    }

    @Override
    public DiskTagFile.DiskTagProperties getDiskTagProperties() {
        return this.extDisk1.getDiskTagProperties();
    }

    @Override
    public VolumeAtocUtil getVolumeArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException, IOException {
        return this.extDisk1.getVolumeAtocUtil(session, monitor);
    }

    @Override
    public IRepository getCurrentDiskArtifactRepo(IArtifactSession session) throws CoreException {
        if (this.currentDiskArtifactRepo == null) {
            this.initCurrentDiskArtifactRepo();
        } else {
            IDiskMounter.IMountedDisk mountedDisk;
            IDiskMounter.IMountedDisk artifactDisk = this.currentDiskArtifactRepo.getDisk();
            if (!artifactDisk.equals(mountedDisk = this.diskMounter.getMountedDisk())) {
                IReadArtifactRepo rar;
                if (session != null && (rar = (IReadArtifactRepo)this.currentDiskArtifactRepo.getAdRepo().getAdapter(IReadArtifactRepo.class)) != null) {
                    ArtifactSession.asSessionAtoc(session).setArtifactToc(rar, null);
                }
                this.innerGroup.removeRepository(this.currentDiskArtifactRepo.getAdRepo());
                this.currentDiskArtifactRepo = null;
                this.initCurrentDiskArtifactRepo();
            }
        }
        return this.currentDiskArtifactRepo.getAdRepo();
    }

    private IRepository createArtifactRepo(String name, ICicLocation location) throws CoreException {
        String version = this.diskMounter.getMountedDisk().getDiskLayoutVersion();
        IRepositoryInfo repInfo = null;
        RepositoryGroup group = this.getInnerGroup();
        repInfo = "0".equals(version) ? group.createRepositoryInfo(name, "Remote", "0.0.0.1", location, null) : group.createRepositoryInfo(name, "ShortName", "0.0.0.1", location, null);
        RepositoryContext.setRequiredContext(repInfo, "EnclosingVolumeRepository");
        return RepositoryUtils.addSpecificInnerRepository(group, repInfo, true, null);
    }

    private void initCurrentDiskArtifactRepo() throws CoreException {
        ICicLocation diskRoot = this.diskMounter.getMountedDisk().getRoot();
        ICicLocation artifactRoot = diskRoot.append("ad");
        IRepository arepo = this.createArtifactRepo("ad", artifactRoot);
        this.currentDiskArtifactRepo = new DiskArtifactRepo(this.diskMounter.getMountedDisk(), arepo);
    }

    private VolumeSetReaderHelperClassic.IGetDiskInfoHelper getDiskInfoHelper(final IRepository outerRepo) {
        VolumeSetReaderHelperClassic.IGetDiskInfoHelper getHelper = new VolumeSetReaderHelperClassic.IGetDiskInfoHelper(){

            @Override
            public VolumesArtifactTableOfContents.DiskInfo getDiskInfo(IArtifactSession s, IArtifact a, IProgressMonitor m) throws CoreException, IOException {
                SubMonitor sm = SubMonitor.convert((IProgressMonitor)m, (int)2);
                VolumeAtocUtil datocUtil = VolumeSetReaderHelperViaMasterDisk.this.getVolumeArtifactToc(s, (IProgressMonitor)sm.newChild(1));
                return datocUtil.getDiskInfo(s, a, (IProgressMonitor)sm.newChild(1));
            }

            @Override
            public VolumeSetReader.IVolumeSetReaderHelper getVsrHelper() {
                return VolumeSetReaderHelperViaMasterDisk.this;
            }

            @Override
            public IRepository getOuterRepository() {
                return outerRepo;
            }
        };
        return getHelper;
    }

    @Override
    public IArtifactGet getArtifactGet(IRepository outerRepo) {
        if (this.artifactGet == null) {
            this.artifactGet = new ViaMasterDiskArtifactGet(outerRepo);
        }
        return this.artifactGet;
    }

    @Override
    public void useArtifactLocatorsOnDisk(VolumeSetReader vsr, IArtifactSession session, IVolumeAccessByDisk.IDiskOperation diskOperation, IMultiArtifactOperationArguments artifactsOnDisk, MultiArtifactOperationOptions options, VolumeAtocUtil.OrderedDisks usedDisks, IVolumeAccessByDisk.IDisk disk, int subRepoIndex, IProgressMonitor monitor) {
        IRepository masterRepo = null;
        IMultiArtifactOperationArguments[] arrArgs = null;
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)120);
        try {
            masterRepo = this.extDisk1.getMasterDiskSetArtifactRepo((IProgressMonitor)sm.newChild(10));
            arrArgs = this.splitArtifactsOnMasterAndNotMaster(session, diskOperation, usedDisks, artifactsOnDisk, disk, masterRepo, (IProgressMonitor)sm.newChild(10));
        }
        catch (CoreException e) {
            if (e.getStatus().matches(8)) {
                artifactsOnDisk.setFailedOperationStatus(e.getStatus());
                return;
            }
            String msg = NLS.bind((String)Messages.VolumeSetReaderHelperViaMasterDisk_FailedToDetermineArtifactsOnMasterDisk, (Object)vsr.getRepository().getLocation());
            CicMultiStatus ms = Statuses.ST.createMultiStatusWithChild(e.getStatus(), msg, new Object[0]);
            artifactsOnDisk.setFailedOperationStatus(ms);
            return;
        }
        catch (IOException e) {
            String msg = NLS.bind((String)Messages.VolumeSetReaderHelperViaMasterDisk_FailedToDetermineArtifactsOnMasterDisk, (Object)vsr.getRepository().getLocation());
            ICicStatus status = Statuses.ERROR.get(e, msg, new Object[0]);
            artifactsOnDisk.setFailedOperationStatus(status);
            return;
        }
        sm.setWorkRemaining(artifactsOnDisk.getRecordCount());
        IMultiArtifactOperationArguments onMasterDisk = arrArgs[0];
        DiskUtil.Disk pseudoDisk = new DiskUtil.Disk(MasterSetupDiskRepository.PSEUDO_MASTER_DISK_SET, 1);
        IVolumeAccessByDisk.IDiskSetDisks allUsedOnPseudoDisks = MasterSetupDiskRepository.PSEUDO_MASTER_DISK_SET.useAllDisks();
        diskOperation.useDisk(session, masterRepo, pseudoDisk, allUsedOnPseudoDisks, onMasterDisk, options, (IProgressMonitor)sm.newChild(onMasterDisk.getRecordCount()));
        IStatus status = onMasterDisk.getFailedOperationStatus();
        if (status.matches(12)) {
            artifactsOnDisk.setFailedOperationStatus(status);
            return;
        }
        IMultiArtifactOperationArguments notOnMasterDisk = arrArgs[1];
        VolumeSetReaderHelperClassic.useArtifactLocatorsOnDisk(vsr, this, session, diskOperation, notOnMasterDisk, options, usedDisks, disk, subRepoIndex, monitor);
        status = notOnMasterDisk.getFailedOperationStatus();
        artifactsOnDisk.setFailedOperationStatus(status);
    }

    private IMultiArtifactOperationArguments[] splitArtifactsOnMasterAndNotMaster(IArtifactSession session, IVolumeAccessByDisk.IDiskOperation diskOperation, VolumeAtocUtil.OrderedDisks usedDisks, IMultiArtifactOperationArguments args, IVolumeAccessByDisk.IDisk disk, IRepository masterRepo, IProgressMonitor monitor) throws CoreException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)110);
        try {
            IMultiArtifactOperationArguments onMasterDisk = diskOperation.getOperation().createArguments();
            IMultiArtifactOperationArguments notOnMasterDisk = diskOperation.getOperation().createArguments();
            sm.setWorkRemaining(args.getRecords().size());
            for (IArtifactOperation.IArtifactOperationRecord element : args.getRecords()) {
                IArtifactOperation.IArtifactOperationRecord dlRecord = element;
                IArtifact artifact = diskOperation.getArtifact(dlRecord);
                if (artifact == null) continue;
                IStatus status = RepoAs.IArtifactGet(masterRepo).existsArtifact(session, artifact, (IProgressMonitor)sm.newChild(1));
                if (StatusCodes.isContentFound(status)) {
                    onMasterDisk.addRecord(dlRecord);
                    continue;
                }
                if (status.matches(12)) {
                    throw new CoreException(status);
                }
                notOnMasterDisk.addRecord(dlRecord);
            }
            IMultiArtifactOperationArguments[] iMultiArtifactOperationArgumentsArray = new IMultiArtifactOperationArguments[]{onMasterDisk, notOnMasterDisk};
            return iMultiArtifactOperationArgumentsArray;
        }
        finally {
            monitor.done();
        }
    }

    private static class DiskArtifactRepo {
        private final IDiskMounter.IMountedDisk disk;
        private final IRepository adRepo;

        public DiskArtifactRepo(IDiskMounter.IMountedDisk disk, IRepository adRepo) {
            this.disk = disk;
            this.adRepo = adRepo;
        }

        public IRepository getAdRepo() {
            return this.adRepo;
        }

        public IDiskMounter.IMountedDisk getDisk() {
            return this.disk;
        }
    }

    private class ViaMasterDiskArtifactGet
    implements IArtifactGet {
        private final IArtifactGet classicGet;

        public ViaMasterDiskArtifactGet(IRepository outerRepo) {
            VolumeSetReaderHelperClassic.IGetDiskInfoHelper diskInfoHelper = VolumeSetReaderHelperViaMasterDisk.this.getDiskInfoHelper(outerRepo);
            this.classicGet = VolumeSetReaderHelperClassic.getArtifactGet(diskInfoHelper);
        }

        @Override
        public IStatus existsArtifact(IArtifactSession session, IArtifact artifact, IProgressMonitor monitor) {
            return this.classicGet.existsArtifact(session, artifact, monitor);
        }

        /*
         * Loose catch block
         */
        @Override
        public IStatus getArtifactFile(IArtifactSession session, IArtifact artifact, IPath destination, IProgressMonitor monitor) {
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
            try {
                IRepository repo = null;
                try {
                    repo = VolumeSetReaderHelperViaMasterDisk.this.extDisk1.getMasterDiskSetArtifactRepo((IProgressMonitor)sm.newChild(1));
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    if (monitor != null) {
                        monitor.done();
                    }
                    return iStatus;
                }
                catch (IOException e) {
                    IStatus iStatus;
                    block15: {
                        IStatus status;
                        iStatus = status = AbstractReadArtifactRepo.createGetArtifactFileError(artifact, destination, e);
                        if (monitor == null) break block15;
                        monitor.done();
                    }
                    return iStatus;
                }
                if (repo != null) {
                    IStatus status = RepoAs.IArtifactGet(repo).existsArtifact(session, artifact, (IProgressMonitor)sm.newChild(1));
                    if (StatusCodes.isContentFound(status)) {
                        IStatus iStatus = status = RepoAs.IArtifactGet(repo).getArtifactFile(session, artifact, destination, (IProgressMonitor)sm.newChild(1));
                        return iStatus;
                    }
                    if (status.matches(12)) {
                        IStatus iStatus = status;
                        return iStatus;
                    }
                }
                sm.setWorkRemaining(1);
                IStatus iStatus = this.classicGet.getArtifactFile(session, artifact, destination, (IProgressMonitor)sm.newChild(1));
                return iStatus;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }

        /*
         * Loose catch block
         */
        @Override
        public IStatus getArtifactLocator(IArtifactSession session, IArtifact artifact, IProgressMonitor monitor, IArtifactLocator[] result) {
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
            try {
                IRepository repo = null;
                try {
                    repo = VolumeSetReaderHelperViaMasterDisk.this.extDisk1.getMasterDiskSetArtifactRepo((IProgressMonitor)sm.newChild(1));
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    if (monitor != null) {
                        monitor.done();
                    }
                    return iStatus;
                }
                catch (IOException e) {
                    IStatus iStatus;
                    block18: {
                        IStatus status;
                        iStatus = status = AbstractReadArtifactRepo.createGetArtifactLocatorError(artifact, null, (Exception)e);
                        if (monitor == null) break block18;
                        monitor.done();
                    }
                    return iStatus;
                }
                if (repo != null) {
                    IStatus status = RepoAs.IArtifactGet(repo).existsArtifact(session, artifact, (IProgressMonitor)sm.newChild(1));
                    if (StatusCodes.isContentFound(status)) {
                        IArtifactLocator[] myResult = new IArtifactLocator[1];
                        status = RepoAs.IArtifactGet(repo).getArtifactLocator(session, artifact, (IProgressMonitor)sm.newChild(1), myResult);
                        if (result != null) {
                            if (myResult[0] != null) {
                                IRepository msdRepo = this.getRepository();
                                result[0] = new WrappedLocator(msdRepo.getRepositoryReference(), myResult[0]);
                            } else {
                                result[0] = null;
                            }
                        }
                        IStatus iStatus = status;
                        return iStatus;
                    }
                    if (status.matches(12)) {
                        IStatus iStatus = status;
                        return iStatus;
                    }
                }
                sm.setWorkRemaining(1);
                IStatus iStatus = this.classicGet.getArtifactLocator(session, artifact, (IProgressMonitor)sm.newChild(1), result);
                return iStatus;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }

        @Override
        public IRepository getRepository() {
            return this.classicGet.getRepository();
        }
    }
}

