/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.volrepo;

import com.ibm.cic.common.core.internal.artifactrepo.ScanForDiskUtil;
import com.ibm.cic.common.core.internal.volrepo.CachedDiskLocations;
import com.ibm.cic.common.core.internal.volrepo.DiskMountUtil;
import com.ibm.cic.common.core.internal.volrepo.IDiskMounter;
import com.ibm.cic.common.core.internal.volrepo.MountedDisk;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.volrepo.DiskPrompter;
import com.ibm.cic.common.core.volrepo.IDiskChangePrompter;
import com.ibm.cic.common.core.volrepo.IDiskInsertedValidator;
import com.ibm.cic.common.core.volrepo.IVolumeRepositoryStatusCodes;
import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DiskMounter
implements IDiskMounter,
IVolumeRepositoryStatusCodes {
    private String fDiskSetId;
    private IDiskMounter.IMountedDisk fMountedDisk;
    private final CachedDiskLocations fCachedDisks = new CachedDiskLocations();

    public DiskMounter(boolean askForDisk, ICicLocation diskLocation, String diskLabel, String diskSetId, Integer diskIndex) throws CoreException {
        IDiskMounter.IMountedDisk[] out = new MountedDisk[1];
        this.fDiskSetId = diskSetId;
        IStatus status = DiskMountUtil.mountInitialDisk(diskLocation, diskSetId, diskIndex, out);
        if (status.isOK()) {
            this.fMountedDisk = out[0];
            assert (this.fMountedDisk != null);
            this.fDiskSetId = this.fMountedDisk.getDiskSetId();
            this.fCachedDisks.cacheAutoDetectedDisk(this.fMountedDisk);
            return;
        }
        if (status.matches(4) && askForDisk && diskIndex != null) {
            this.promptInsertDisk(diskLocation, diskLabel, diskIndex);
            return;
        }
        throw new CoreException(status);
    }

    private void promptInsertDisk(ICicLocation previousLocation, String diskLabel, final int diskIndex) throws CoreException {
        MountedDisk[] out;
        IDiskChangePrompter prompter = DiskPrompter.INSTANCE.getPrompter();
        IStatus status = prompter.promptInsertDisk(new IDiskInsertedValidator(out = new MountedDisk[1]){
            private final /* synthetic */ MountedDisk[] val$out;
            {
                this.val$out = mountedDiskArray;
            }

            @Override
            public IStatus validateDisk(ICicLocation diskLocation) {
                boolean[] refIsNewDisk = null;
                if (DiskMounter.this.fMountedDisk != null) {
                    return DiskMountUtil.mountNextDisk(diskLocation, DiskMounter.this.fMountedDisk, diskIndex, this.val$out, refIsNewDisk);
                }
                return DiskMountUtil.mountInitialDisk(diskLocation, DiskMounter.this.fDiskSetId, diskIndex, this.val$out);
            }
        }, previousLocation, diskLabel, this.fDiskSetId, diskIndex + 1);
        if (status.matches(12)) {
            throw new CoreException(status);
        }
        assert (status.isOK());
        this.fMountedDisk = out[0];
        assert (this.fMountedDisk != null);
        this.fDiskSetId = this.fMountedDisk.getDiskSetId();
    }

    private File getFindAvailableDisksRootDir() {
        File parentDir;
        block6: {
            File mountedDir;
            block5: {
                ICicLocation currentRoot = this.fMountedDisk.getRoot();
                if (DiskMountUtil.isSimulatedMountPoint(currentRoot)) {
                    DiskMountUtil.log.debug("No proposed dir for simulated moint point {0}.", currentRoot);
                    return null;
                }
                try {
                    mountedDir = FileURLUtil.locationToFile(currentRoot.toString());
                    parentDir = mountedDir.getParentFile();
                    if (parentDir != null) break block5;
                    DiskMountUtil.log.debug("No parent dir for {0}.", mountedDir);
                    return null;
                }
                catch (MalformedURLException e) {
                    DiskMountUtil.log.error(e);
                    return null;
                }
            }
            if (ScanForDiskUtil.isDiskFolderCandidate(mountedDir, this.fMountedDisk.getDiskSetId(), this.fMountedDisk.getDiskIndex() + 1)) break block6;
            return null;
        }
        return parentDir;
    }

    @Override
    public boolean canFindAvailableDisks() {
        return this.getFindAvailableDisksRootDir() != null;
    }

    private DiskMounter findDisk(int diskIndex, IProgressMonitor monitor) {
        assert (this.fMountedDisk != null);
        File dir = this.getFindAvailableDisksRootDir();
        if (dir == null) {
            return null;
        }
        DiskMounter foundDisk = ScanForDiskUtil.findDiskFolder(dir, this.fMountedDisk.getDiskSetId(), diskIndex + 1);
        return foundDisk;
    }

    @Override
    public IStatus ensureInsertedDiskNoPrompting(int diskIndex, IProgressMonitor monitor) {
        DiskMounter diskMounter;
        boolean[] refIsNewDisk = new boolean[1];
        IDiskMounter.IMountedDisk[] refMountedDisk = new MountedDisk[1];
        IStatus status = DiskMountUtil.ensureMountedDisk(this.fMountedDisk, diskIndex, refMountedDisk, refIsNewDisk);
        if (status.matches(8)) {
            return status;
        }
        if (status.isOK()) {
            if (refIsNewDisk[0]) {
                this.fMountedDisk = refMountedDisk[0];
                assert (this.fMountedDisk != null);
            }
            return status;
        }
        IDiskMounter.IMountedDisk cachedMountedDisk = this.fCachedDisks.getCachedAutoDetectedDisk(this.fDiskSetId, diskIndex);
        if (cachedMountedDisk != null) {
            status = DiskMountUtil.ensureMountedDisk(cachedMountedDisk, diskIndex, refMountedDisk, refIsNewDisk);
            if (status.matches(8)) {
                return status;
            }
            if (status.isOK()) {
                this.fMountedDisk = cachedMountedDisk;
                return status;
            }
            if (status.matches(4)) {
                this.fCachedDisks.invalidate(cachedMountedDisk);
            }
        }
        if ((diskMounter = this.findDisk(diskIndex, monitor)) != null) {
            this.fMountedDisk = diskMounter.getMountedDisk();
            this.fCachedDisks.cacheAutoDetectedDisk(this.fMountedDisk);
            return Status.OK_STATUS;
        }
        return status;
    }

    @Override
    public IStatus ensureInsertedDisk(String diskLabel, int diskIndex, IProgressMonitor monitor) {
        IStatus status = this.ensureInsertedDiskNoPrompting(diskIndex, monitor);
        if (status.isOK() || status.matches(8)) {
            return status;
        }
        if (this.fMountedDisk == null) {
            assert (status.matches(4));
            return status;
        }
        try {
            this.promptInsertDisk(this.fMountedDisk.getRoot(), diskLabel, diskIndex);
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    @Override
    public IDiskMounter.IMountedDisk getMountedDisk() {
        return this.fMountedDisk;
    }

    @Override
    public void refresh() {
        this.fCachedDisks.clear();
    }
}

