/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.volrepo;

import com.ibm.cic.common.core.internal.volrepo.DiskMountUtil;
import com.ibm.cic.common.core.internal.volrepo.IDiskMounter;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class CachedDiskLocations {
    private final LinkedHashSet fCacheDiskLocations = new LinkedHashSet();

    public synchronized IDiskMounter.IMountedDisk getCachedAutoDetectedDisk(String diskSetId, int diskIndex) {
        for (IDiskMounter.IMountedDisk mountedDisk : this.fCacheDiskLocations) {
            if (mountedDisk.getDiskIndex() != diskIndex || !mountedDisk.getDiskSetId().equals(diskSetId)) continue;
            return mountedDisk;
        }
        return null;
    }

    public synchronized void invalidate(IDiskMounter.IMountedDisk cachedMountedDisk) {
        this.fCacheDiskLocations.remove(cachedMountedDisk);
    }

    public synchronized void cacheAutoDetectedDisk(IDiskMounter.IMountedDisk mountedDisk) {
        if (this.fCacheDiskLocations.remove(mountedDisk)) {
            DiskMountUtil.log.debug("Caching more than once should never occur {0}.", mountedDisk);
        }
        this.fCacheDiskLocations.add(mountedDisk);
    }

    public synchronized void refresh(String diskSetId) {
        Iterator iterator = this.fCacheDiskLocations.iterator();
        while (iterator.hasNext()) {
            IDiskMounter.IMountedDisk mountedDisk = (IDiskMounter.IMountedDisk)iterator.next();
            if (!mountedDisk.getDiskSetId().equals(diskSetId)) continue;
            iterator.remove();
        }
    }

    public synchronized void clear() {
        this.fCacheDiskLocations.clear();
    }
}

