/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.utils;

import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IOffering;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UniqueFeatureIdGenerator {
    private final Map fidMap = new HashMap(4);

    public UniqueFeatureIdGenerator(IOffering offering) {
        if (offering != null) {
            this.collectFeatureIds(offering.getFeatureGroup());
        }
    }

    private void collectFeatureIds(IFeatureGroup group) {
        if (group == null) {
            return;
        }
        List children = group.getChildren();
        for (Object child : children) {
            if (child instanceof IFeature) {
                this.collectFeatureId((IFeature)child);
                continue;
            }
            if (!(child instanceof IFeatureGroup)) continue;
            this.collectFeatureIds((IFeatureGroup)child);
        }
    }

    private void collectFeatureId(IFeature feature) {
        String idStr = feature.getIdentity().getId();
        if (idStr == null) {
            idStr = feature.getSelectorIdentity().getId();
        }
        this.generateIdFrom(idStr);
    }

    public String generateIdFrom(String selIdStr) {
        Integer rank;
        Integer oldRank;
        if (selIdStr == null || selIdStr.length() == 0) {
            selIdStr = "feature";
        }
        if ((oldRank = this.fidMap.put(selIdStr, rank = Integer.valueOf(1))) != null) {
            rank = oldRank + 1;
            this.fidMap.put(selIdStr, rank);
        }
        if (rank > 1) {
            return String.valueOf(selIdStr) + '_' + rank;
        }
        if ("feature".equals(selIdStr)) {
            return String.valueOf(selIdStr) + "_1";
        }
        return selIdStr;
    }
}

