/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.utils;

import com.ibm.cic.common.core.internal.utils.IServiceabilityProvider;
import com.ibm.cic.common.logging.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class CicServiceabilityProvider
implements IServiceabilityProvider {
    private static Logger log = null;
    private final Map<String, String> msgToUid = new IdentityHashMap<String, String>();
    private final Map<String, String> msgToExplanation = new IdentityHashMap<String, String>();
    private final Map<String, String> msgToUserAction = new IdentityHashMap<String, String>();

    private static Logger getLogger() {
        if (log == null) {
            log = Logger.getLogger();
        }
        return log;
    }

    @Override
    public String getUid(String msg) {
        return this.msgToUid.get(msg);
    }

    @Override
    public String getExplanation(String msg) {
        return this.msgToExplanation.get(msg);
    }

    @Override
    public String getUserAction(String msg) {
        return this.msgToUserAction.get(msg);
    }

    @Override
    public void initializeMessages(Class messagesClass) {
        Field[] fieldArray = messagesClass.getDeclaredFields();
        HashMap<String, String> keyToMsg = new HashMap<String, String>(fieldArray.length);
        Field[] fieldArray2 = fieldArray;
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            int mods = field.getModifiers();
            if (Modifier.isPublic(mods) && Modifier.isStatic(mods) && !Modifier.isFinal(mods) && field.getType() == String.class) {
                try {
                    String key = field.getName();
                    String value = (String)field.get(null);
                    Suffix suffix = Suffix.get(key);
                    if (suffix == null) {
                        keyToMsg.put(key, value);
                    } else {
                        String msg = (String)keyToMsg.get(suffix.getPrefix(key));
                        if (msg == null) {
                            CicServiceabilityProvider.getLogger().errorNoUid("Message for {0} not yet seen in {1}", key, messagesClass);
                        } else {
                            switch (suffix) {
                                case UID: {
                                    this.msgToUid.put(msg, value.trim());
                                    break;
                                }
                                case EXPLANATION: {
                                    this.msgToExplanation.put(msg, value);
                                    break;
                                }
                                case USER_ACTION: {
                                    this.msgToUserAction.put(msg, value);
                                }
                            }
                        }
                    }
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
            }
            ++n2;
        }
    }

    private static enum Suffix {
        UID("$uid"),
        EXPLANATION("$explanation"),
        USER_ACTION("$useraction");

        private final String suffix;

        static Suffix get(String key) {
            Suffix[] suffixArray = Suffix.values();
            int n = suffixArray.length;
            int n2 = 0;
            while (n2 < n) {
                Suffix suffix = suffixArray[n2];
                if (key.endsWith(suffix.suffix)) {
                    return suffix;
                }
                ++n2;
            }
            return null;
        }

        private Suffix(String suffix) {
            this.suffix = suffix;
        }

        String getPrefix(String key) {
            return key.substring(0, key.length() - this.suffix.length());
        }
    }
}

