/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.utils;

import com.ibm.cic.common.logging.Logger;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Plugin;

public class CicCommonCoreTrace {
    public boolean enabled;
    protected Logger log;

    public CicCommonCoreTrace(Plugin plugin) {
        this(plugin.getBundle().getSymbolicName());
    }

    public CicCommonCoreTrace(String pluginSymbolicName) {
        String debugOption = String.valueOf(pluginSymbolicName) + "/debug";
        this.log = Logger.getLoggerUsingDebug(debugOption);
        this.enabled = this.log.isDebugLoggable();
    }

    public CicCommonCoreTrace(Plugin plugin, String option) {
        this.log = Logger.getLoggerUsingDebug(option);
        this.enabled = this.log.isDebugLoggable();
    }

    public Logger getLog() {
        return this.log;
    }

    public void println(String message) {
        if (this.enabled) {
            this.log.debug(message);
        }
    }

    public void println(String message, String arg) {
        if (this.enabled) {
            this.println(message, new String[]{arg});
        }
    }

    public void println(String message, String arg1, String arg2) {
        if (this.enabled) {
            this.println(message, new String[]{arg1, arg2});
        }
    }

    public void println(String message, Object[] args) {
        if (this.enabled) {
            this.println(MessageFormat.format(message, args));
        }
    }
}

