/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.utils;

import com.ibm.cic.common.core.internal.utils.CicCommonCoreTrace;
import com.ibm.cic.common.logging.LogUtil;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class CicCommonCorePluginTrace
extends CicCommonCoreTrace {
    protected static final String PARENTHESIS_OPEN = "(";
    protected static final String PARENTHESIS_CLOSE = ")";
    protected static final String PREFIX_CATCHING = "CAUGHT ";
    protected static final String PREFIX_THROWING = "THROWN ";
    protected static final String PREFIX_ENTERING = "ENTERING ";
    protected static final String PREFIX_EXITING = "EXITING ";
    protected static final String SEPARATOR_METHOD = "#";
    protected static final String SEPARATOR_PARAMETER = ", ";
    protected static final String SEPARATOR_RETURN = ":";
    protected static final String SEPARATOR_SPACE = " ";
    private static final int CLASS_INDEX = 0;
    private static final int METHOD_INDEX = 1;
    public boolean traceEntering;
    public boolean traceExiting;
    public boolean traceCatching;
    public boolean traceThrowing;
    private static final String DEBUG_OPTION = "/debug/";
    public static final String METHODS_ENTERING = "/debug/methods/entering";
    public static final String METHODS_EXITING = "/debug/methods/exiting";
    public static final String EXCEPTIONS_CATCHING = "/debug/exceptions/catching";
    public static final String EXCEPTIONS_THROWING = "/debug/exceptions/throwing";

    public CicCommonCorePluginTrace(Plugin plugin) {
        super(plugin);
        String pluginId = plugin.getBundle().getSymbolicName();
        this.traceEntering = this.isEnabled(pluginId, METHODS_ENTERING);
        this.traceExiting = this.isEnabled(pluginId, METHODS_EXITING);
        this.traceCatching = this.isEnabled(pluginId, EXCEPTIONS_CATCHING);
        this.traceThrowing = this.isEnabled(pluginId, EXCEPTIONS_THROWING);
    }

    public CicCommonCorePluginTrace(String pluginSymbolicName) {
        super(pluginSymbolicName);
    }

    private boolean isEnabled(String pluginId, String attr) {
        if (!this.enabled) {
            return false;
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)(String.valueOf(pluginId) + attr)))) {
            return true;
        }
        assert (attr.startsWith(DEBUG_OPTION));
        return Boolean.TRUE.toString().equalsIgnoreCase(this.log.getAttr(attr.substring(DEBUG_OPTION.length())));
    }

    protected static String getArgumentString(Object argument) {
        return String.valueOf(argument);
    }

    protected static String getArgumentsString(Object[] arguments) {
        StringBuffer buffer = new StringBuffer();
        if (arguments != null) {
            int i = 0;
            while (i < arguments.length) {
                buffer.append(CicCommonCorePluginTrace.getArgumentString(arguments[i]));
                if (i < arguments.length - 1) {
                    buffer.append(SEPARATOR_PARAMETER);
                }
                ++i;
            }
        }
        return buffer.toString();
    }

    protected static String[] getStackTraceInfo() {
        String methodName = null;
        String className = null;
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        String traceName = CicCommonCorePluginTrace.class.getName();
        String throwableName = Throwable.class.getName();
        StackTraceElement[] stackTraceElementArray = stackTrace;
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            className = stackTraceElement.getClassName();
            if (!className.equals(traceName) && !className.equals(throwableName)) {
                methodName = stackTraceElement.getMethodName();
                break;
            }
            ++n2;
        }
        return new String[]{className, methodName};
    }

    protected void printStackTrace(Throwable throwable) {
        StringBuffer sb = new StringBuffer();
        LogUtil.appendStackTrace(-1, sb, 0, throwable);
        this.println(sb.toString());
    }

    public void catching(Throwable throwable) {
        if (this.traceCatching) {
            String[] traceInfo = CicCommonCorePluginTrace.getStackTraceInfo();
            this.println(PREFIX_CATCHING + String.valueOf(throwable.getMessage()) + SEPARATOR_SPACE + PARENTHESIS_OPEN + traceInfo[0] + SEPARATOR_METHOD + traceInfo[1] + PARENTHESIS_CLOSE);
            this.printStackTrace(throwable);
        }
    }

    public void throwing(Throwable throwable) {
        if (this.traceThrowing) {
            String[] traceInfo = CicCommonCorePluginTrace.getStackTraceInfo();
            this.println(PREFIX_THROWING + String.valueOf(throwable.getMessage()) + SEPARATOR_SPACE + PARENTHESIS_OPEN + traceInfo[0] + SEPARATOR_METHOD + traceInfo[1] + PARENTHESIS_CLOSE);
            this.printStackTrace(throwable);
        }
    }

    public void entering() {
        if (this.traceEntering) {
            this.entering(new Object[0]);
        }
    }

    public void entering(Object parameter) {
        if (this.traceEntering) {
            this.entering(new Object[]{parameter});
        }
    }

    public void entering(Object[] parameters) {
        if (this.traceEntering) {
            String[] traceInfo = CicCommonCorePluginTrace.getStackTraceInfo();
            this.println(PREFIX_ENTERING + traceInfo[1] + PARENTHESIS_OPEN + CicCommonCorePluginTrace.getArgumentsString(parameters) + PARENTHESIS_CLOSE);
        }
    }

    public void exiting(Object[] returnValue) {
        if (this.traceExiting) {
            String[] traceInfo = CicCommonCorePluginTrace.getStackTraceInfo();
            this.println(PREFIX_EXITING + traceInfo[1] + SEPARATOR_RETURN + CicCommonCorePluginTrace.getArgumentsString(returnValue));
        }
    }

    public void exiting(Object returnValue) {
        if (this.traceExiting) {
            String[] traceInfo = CicCommonCorePluginTrace.getStackTraceInfo();
            this.println(PREFIX_EXITING + traceInfo[1] + SEPARATOR_RETURN + CicCommonCorePluginTrace.getArgumentString(returnValue));
        }
    }

    public void exiting() {
        if (this.traceExiting) {
            String[] traceInfo = CicCommonCorePluginTrace.getStackTraceInfo();
            this.println(PREFIX_EXITING + traceInfo[1]);
        }
    }
}

