/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.preferences;

import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class ProxyPreferenceInternalUtil {
    private final HashMap mapSelectTags = new HashMap(3);
    private final HashMap mapTags = new HashMap(5);
    private final Set validProxyKeys = new LinkedHashSet(10);
    private static Set validTargetProtocols;
    private static ICicPreferenceConstants.PreferenceTag globalSocksHostTag;
    private static ICicPreferenceConstants.PreferenceTag globalSocksPortTag;
    private static ICicPreferenceConstants.PreferenceTag globalHttp11HostTag;
    private static ICicPreferenceConstants.PreferenceTag globalHttp11PortTag;
    public static final ProxyPreferenceInternalUtil INSTANCE;
    public static final String PROXY_TYPE_NONE = "NO_PROXY";
    public static final String SOCKS = "SOCKS";
    public static final String HTTP11 = "HTTP11";

    static {
        globalSocksHostTag = ICicPreferenceConstants.ProxyPreferences.getSocksProxyHost();
        globalSocksPortTag = ICicPreferenceConstants.ProxyPreferences.getSocksProxyPort();
        globalHttp11HostTag = ICicPreferenceConstants.ProxyPreferences.getProxyHost("http");
        globalHttp11PortTag = ICicPreferenceConstants.ProxyPreferences.getProxyPort("http");
        INSTANCE = new ProxyPreferenceInternalUtil();
    }

    private ProxyPreferenceInternalUtil() {
        this.validProxyKeys.add(new ProxyTagsKey(HTTP11, "http", true));
        this.validProxyKeys.add(new ProxyTagsKey(HTTP11, "http", false));
        this.validProxyKeys.add(new ProxyTagsKey(SOCKS, "http", true));
        this.validProxyKeys.add(new ProxyTagsKey(SOCKS, "http", false));
        this.validProxyKeys.add(new ProxyTagsKey(HTTP11, "https", true));
        this.validProxyKeys.add(new ProxyTagsKey(HTTP11, "https", false));
        this.validProxyKeys.add(new ProxyTagsKey(SOCKS, "https", true));
        this.validProxyKeys.add(new ProxyTagsKey(SOCKS, "https", false));
        this.validProxyKeys.add(new ProxyTagsKey(SOCKS, "ftp", true));
        this.validProxyKeys.add(new ProxyTagsKey(SOCKS, "ftp", false));
    }

    private void checkValidProxyTagsKey(ProxyTagsKey key) {
        assert (this.validProxyKeys.contains(key));
    }

    public Set getValidProxyKeys() {
        return Collections.unmodifiableSet(this.validProxyKeys);
    }

    public static Set getValidTargetProtocols() {
        if (validTargetProtocols == null) {
            validTargetProtocols = new LinkedHashSet();
            validTargetProtocols.add("http");
            validTargetProtocols.add("https");
            validTargetProtocols.add("ftp");
        }
        return Collections.unmodifiableSet(validTargetProtocols);
    }

    public static void checkTargetProtocol(String targetProtocol) {
        if (targetProtocol == null) {
            throw new NullPointerException("targetProtocol");
        }
        assert (ProxyPreferenceInternalUtil.getValidTargetProtocols().contains(targetProtocol));
    }

    public ProxySelectTags getProxySelectTags(String targetProtocol) {
        ProxyPreferenceInternalUtil.checkTargetProtocol(targetProtocol);
        Object o = this.mapSelectTags.get(targetProtocol);
        if (o == null) {
            this.mapSelectTags.put(targetProtocol, new ProxySelectTags(targetProtocol));
            o = this.mapSelectTags.get(targetProtocol);
        }
        return (ProxySelectTags)o;
    }

    public ProxyTags getProxyTags(ProxyTagsKey tagsKey) {
        this.checkValidProxyTagsKey(tagsKey);
        Object o = this.mapTags.get(tagsKey);
        if (o == null) {
            this.mapTags.put(tagsKey, new ProxyTags(tagsKey));
            o = this.mapTags.get(tagsKey);
        }
        return (ProxyTags)o;
    }

    public static IEclipsePreferences getEclipseProxyPrefs() {
        CicPreferenceManager prefs = CicPreferenceManager.getInstance();
        return prefs.getCurrentPreferenceHandler().getPreferences();
    }

    public boolean isProxyEnabled(ProxySelectTags tags, IEclipsePreferences prefs) {
        return prefs.getBoolean(tags.getEnabledTag().key(), false);
    }

    public boolean isProxyEnabled(ProxySelectTags tags) {
        return this.isProxyEnabled(tags, ProxyPreferenceInternalUtil.getEclipseProxyPrefs());
    }

    public boolean useSocksProxy(ProxySelectTags tags, IEclipsePreferences prefs) {
        return prefs.getBoolean(tags.getUseSocksTag().key(), false);
    }

    public boolean useSocksProxy(ProxySelectTags tags) {
        return this.useSocksProxy(tags, ProxyPreferenceInternalUtil.getEclipseProxyPrefs());
    }

    private static ICicPreferenceConstants.PreferenceTag getProxyHostTag(String proxyProtocol, String targetProtocol, boolean useCommon) {
        if (useCommon) {
            ICicPreferenceConstants.PreferenceTag tag = null;
            if (proxyProtocol.equals(HTTP11)) {
                tag = globalHttp11HostTag;
            } else {
                assert (proxyProtocol.equals(SOCKS));
                tag = globalSocksHostTag;
            }
            return tag;
        }
        ICicPreferenceConstants.PreferenceTag tag = null;
        if (proxyProtocol.equals(HTTP11)) {
            tag = ICicPreferenceConstants.ProxyPreferences.getHttp11ProxyHost(targetProtocol);
        } else {
            assert (proxyProtocol.equals(SOCKS));
            tag = ICicPreferenceConstants.ProxyPreferences.getSocksProxyHost(targetProtocol);
        }
        return tag;
    }

    private static ICicPreferenceConstants.PreferenceTag getProxyPortTag(String proxyProtocol, String targetProtocol, boolean useCommon) {
        if (useCommon) {
            ICicPreferenceConstants.PreferenceTag tag = null;
            if (proxyProtocol.equals(HTTP11)) {
                tag = globalHttp11PortTag;
            } else {
                assert (proxyProtocol.equals(SOCKS));
                tag = globalSocksPortTag;
            }
            return tag;
        }
        ICicPreferenceConstants.PreferenceTag tag = null;
        if (proxyProtocol.equals(HTTP11)) {
            tag = ICicPreferenceConstants.ProxyPreferences.getHttp11ProxyPort(targetProtocol);
        } else {
            assert (proxyProtocol.equals(SOCKS));
            tag = ICicPreferenceConstants.ProxyPreferences.getSocksProxyPort(targetProtocol);
        }
        return tag;
    }

    public String getProxyHost(ProxyTags proxyTags, IEclipsePreferences prefs) {
        String v = prefs.get(proxyTags.hostTag.key(), "");
        return v;
    }

    public String getProxyHost(ProxyTags proxyTags) {
        return this.getProxyHost(proxyTags, ProxyPreferenceInternalUtil.getEclipseProxyPrefs());
    }

    public String getProxyPort(ProxyTags proxyTags, IEclipsePreferences prefs) {
        String v = prefs.get(proxyTags.portTag.key(), "");
        return v;
    }

    public String getProxyPort(ProxyTags proxyTags) {
        return this.getProxyPort(proxyTags, ProxyPreferenceInternalUtil.getEclipseProxyPrefs());
    }

    public static class ProxySelectTags {
        private final String targetProtocol;
        private final ICicPreferenceConstants.PreferenceTag enabledTag;
        private final ICicPreferenceConstants.PreferenceTag useSocksTag;

        private ProxySelectTags(String targetProtocol) {
            this.targetProtocol = targetProtocol;
            this.enabledTag = ICicPreferenceConstants.ProxyPreferences.getProxyEnabled(targetProtocol);
            this.useSocksTag = ICicPreferenceConstants.ProxyPreferences.getProxyUseSocks(targetProtocol);
        }

        public String getTargetProtocol() {
            return this.targetProtocol;
        }

        public ICicPreferenceConstants.PreferenceTag getEnabledTag() {
            return this.enabledTag;
        }

        public ICicPreferenceConstants.PreferenceTag getUseSocksTag() {
            return this.useSocksTag;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.targetProtocol);
            sb.append(" ");
            sb.append(this.enabledTag);
            sb.append(" ");
            sb.append(this.useSocksTag);
            return sb.toString();
        }
    }

    public static class ProxyTags {
        private final ProxyTagsKey tagsKey;
        private final ICicPreferenceConstants.PreferenceTag hostTag;
        private final ICicPreferenceConstants.PreferenceTag portTag;

        private ProxyTags(ProxyTagsKey tagsKey) {
            this.tagsKey = tagsKey;
            this.hostTag = ProxyPreferenceInternalUtil.getProxyHostTag(tagsKey.proxyProtocol, tagsKey.targetProtocol, tagsKey.useCommon);
            this.portTag = ProxyPreferenceInternalUtil.getProxyPortTag(tagsKey.proxyProtocol, tagsKey.targetProtocol, tagsKey.useCommon);
        }

        public ICicPreferenceConstants.PreferenceTag getHostTag() {
            return this.hostTag;
        }

        public ICicPreferenceConstants.PreferenceTag getPortTag() {
            return this.portTag;
        }

        public ProxyTagsKey getKey() {
            return this.tagsKey;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.tagsKey).append(':').append(this.hostTag.key()).append(' ').append(this.portTag.key());
            return sb.toString();
        }
    }

    public static class ProxyTagsKey {
        public String proxyProtocol;
        public String targetProtocol;
        public boolean useCommon;

        public ProxyTagsKey(String proxyProtocol, String targetProtocol, boolean useCommon) {
            assert (proxyProtocol.equals(ProxyPreferenceInternalUtil.HTTP11) || proxyProtocol.equals(ProxyPreferenceInternalUtil.SOCKS));
            ProxyPreferenceInternalUtil.checkTargetProtocol(targetProtocol);
            this.proxyProtocol = proxyProtocol;
            this.targetProtocol = targetProtocol;
            this.useCommon = useCommon;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.proxyProtocol.hashCode();
            result = 31 * result + this.targetProtocol.hashCode();
            result = 31 * result + (this.useCommon ? 1 : 0);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProxyTagsKey other = (ProxyTagsKey)obj;
            if (this.useCommon != other.useCommon) {
                return false;
            }
            if (!this.proxyProtocol.equals(other.proxyProtocol)) {
                return false;
            }
            return this.targetProtocol.equals(other.targetProtocol);
        }

        public String getProxyProtocol() {
            return this.proxyProtocol;
        }

        public String getTargetProtocol() {
            return this.targetProtocol;
        }

        public String toString() {
            String s = String.valueOf(this.proxyProtocol) + ".for." + this.targetProtocol;
            if (this.useCommon) {
                s = String.valueOf(s) + "(Common)";
            }
            return s;
        }
    }
}

