/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.downloads;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.downloads.Messages;
import com.ibm.cic.common.core.internal.downloads.httpclient.StrictHostnameVerifier;
import com.ibm.cic.common.downloads.NonsecureConnectionManager;
import com.ibm.cic.common.logging.Logger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.eclipse.core.runtime.Plugin;

public class CicX509TrustManager
implements X509TrustManager {
    private X509TrustManager standardTrustManager = CicX509TrustManager.getStandardTrustManager();
    private static final Logger log = Logger.getLogger(CicX509TrustManager.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());

    private static X509TrustManager getStandardTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init((KeyStore)null);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers.length == 0) {
            throw new NoSuchAlgorithmException("no trust manager found");
        }
        return (X509TrustManager)trustmanagers[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        this.standardTrustManager.checkClientTrusted(certificates, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        block6: {
            if (certificates != null && log.isDebugLoggable()) {
                log.debug("Server certificate chain:");
                int i = 0;
                while (i < certificates.length) {
                    log.debug("X509Certificate[{0}]={1}]", i, certificates[i]);
                    ++i;
                }
            }
            if (certificates == null || certificates.length == 0) {
                this.standardTrustManager.checkServerTrusted(certificates, authType);
                return;
            }
            try {
                this.standardTrustManager.checkServerTrusted(certificates, authType);
                String hostName = NonsecureConnectionManager.getSSLConnectingHost();
                if (hostName != null) {
                    this.verifyHostname(hostName, certificates[0]);
                    break block6;
                }
                log.error(Messages.CicX509ThrustManager_hostnameNotSet);
                throw new CertificateException(Messages.CicX509ThrustManager_hostnameNotSet);
            }
            catch (CertificateException ce) {
                String host = NonsecureConnectionManager.getSSLConnectingHost();
                if (NonsecureConnectionManager.INSTANCE.continueConnectionWithInvalidCertificates(host, certificates, authType, ce)) break block6;
                throw ce;
            }
        }
    }

    public void verifyHostname(String expectedAddress, X509Certificate certificate) throws CertificateException {
        try {
            new StrictHostnameVerifier().verify(expectedAddress, certificate);
        }
        catch (SSLException e) {
            throw new CertificateException(e.getMessage());
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }
}

