/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.artifactrepo;

import com.ibm.cic.common.core.artifactrepo.impl.AbstractArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractContentLocator;
import com.ibm.cic.common.core.internal.downloads.DownloadedIncompleteUsingFile;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.repository.ZipRepository;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.UserNames;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.downloads.DownloadedFile;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.downloads.IDownloadedFile;
import com.ibm.cic.common.downloads.ITransferMonitor;
import com.ibm.cic.common.downloads.ResumableDownloadProgress;
import com.ibm.cic.common.downloads.SimpleContentInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class JarArtifactLocator
extends AbstractArtifactLocator {
    private final String file;

    public JarArtifactLocator(ZipRepository artifactRepoInstance, IArtifact artifact, IContentInfo contentInfo, String file) {
        super(artifactRepoInstance, artifact, contentInfo);
        this.file = file;
    }

    @Override
    public ZipRepository getArtifactRepository() {
        return (ZipRepository)super.getArtifactRepository();
    }

    @Override
    public UserNames getUserNames() {
        return new UserNames(this.getLogicalName(), this.file.toString());
    }

    @Override
    public IStatus validateExists(int severity, IProgressMonitor monitor) {
        ZipRepository repo = this.getArtifactRepository();
        ZipEntry entry = null;
        try {
            if (repo.getStatus(false, null).isOK()) {
                ZipFile zfi = new ZipFile(repo.getArcHandler().getName());
                entry = zfi.getEntry(this.file);
                zfi.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (entry == null) {
            return AbstractContentLocator.makeDoesNotExistStatus(severity, repo.getUserNames(), this, null);
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IDownloadedFile doDownloadToFileNoValidationNoResumeRetry(IDownloadSession session, IPath destination, ITransferMonitor transferPerformance, ResumableDownloadProgress.IResumableDownloadProgress progress, long[] outReadBytes) {
        ICicStatus status;
        File copiedFile = destination.toFile();
        SimpleContentInfo ci = null;
        DownloadedIncompleteUsingFile downloadIncomplete = null;
        try {
            status = this.downloadToFileNoValidation(session, destination, transferPerformance, progress, outReadBytes);
            SimpleContentInfo sci = new SimpleContentInfo();
            sci.setSize(outReadBytes[0]);
            ci = sci;
        }
        catch (FileNotFoundException e) {
            status = this.createErrorDownloadToFile(copiedFile, e);
            downloadIncomplete = new DownloadedIncompleteUsingFile(copiedFile);
            copiedFile = null;
        }
        catch (IOException e) {
            status = this.createErrorDownloadToFile(copiedFile, e);
            downloadIncomplete = new DownloadedIncompleteUsingFile(copiedFile);
            copiedFile = null;
        }
        if (progress.isCanceled()) {
            status = ICicStatus.CANCEL_STATUS;
        }
        return new DownloadedFile(status, copiedFile, ci, downloadIncomplete);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " at " + this.getArtifactRepository().getLocationStr() + '@' + this.file.toString();
    }

    private ICicStatus downloadToFileNoValidation(IDownloadSession session, IPath destination, ITransferMonitor transferPerformance, ResumableDownloadProgress.ITransferProgress progress, long[] outReadBytes) throws IOException {
        File copiedFile = destination.toFile();
        outReadBytes[0] = 0L;
        if (transferPerformance.isCanceled()) {
            return ICicStatus.CANCEL_STATUS;
        }
        try (ZipFile zfi = new ZipFile(this.getArtifactRepository().getArcHandler().getName());){
            ZipEntry entry = zfi.getEntry(this.file);
            outReadBytes[0] = FileUtil.copyStream(entry.getSize(), zfi.getInputStream(entry), copiedFile, UserOptions.getDownloadSyncOnClose(), transferPerformance);
        }
        return ICicStatus.OK_STATUS;
    }
}

