/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.artifactrepo;

import com.ibm.cic.common.core.artifactrepo.base.ArtifactOperationStatusSummary;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperation;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ArtifactOperationHistory
implements IArtifactOperation.IArtifactOperationHistory {
    private final ArrayList results = new ArrayList();

    public ArtifactOperationHistory(IArtifactOperation.IArtifactOperationResult result) {
        this.results.add(result);
    }

    public ArtifactOperationHistory(IStatus status) {
        this.results.add(status);
    }

    @Override
    public int getHistoryCount() {
        return this.results.size();
    }

    @Override
    public IStatus getHistoryStatus(int index) {
        return (IStatus)this.results.get(index);
    }

    @Override
    public IStatus getLastStatus() {
        return (IStatus)this.results.get(0);
    }

    private boolean isRequestedOnTop() {
        Object o;
        boolean isRequested = false;
        if (this.results.size() > 0 && (o = this.results.get(0)) == IArtifactOperation.STATUS_OK_REQUESTED) {
            isRequested = true;
        }
        return isRequested;
    }

    @Override
    public void setHistoryStatus(ILog log, IStatus status) {
        if (this.isRequestedOnTop()) {
            this.results.set(0, status);
        } else {
            this.results.add(0, status);
        }
        if (log != null && !status.isOK()) {
            log.log(status);
        }
    }

    @Override
    public IStatus getTotalStatus() {
        return ArtifactOperationHistory.getTotalStatus(this.results);
    }

    public static IStatus getTotalStatus(Collection statusCollection) {
        ArtifactOperationStatusSummary summary = new ArtifactOperationStatusSummary(statusCollection);
        if (summary.getRealOKMultiStatus().hasChildren()) {
            return summary.getRealOKMultiStatus().getChild(0);
        }
        if (summary.matchesMostSevereStatus(8)) {
            return summary.getCancelStatus();
        }
        if (summary.matchesMostSevereNonCancelOrNotFound(4)) {
            return summary.getMostSevereNonCancelOrNotFound();
        }
        if (summary.getNotFoundMultiStatus().hasChildren()) {
            if (summary.getNotFoundMultiStatus().getChildren().length == 1) {
                return summary.getNotFoundMultiStatus().getChild(0);
            }
            IStatus status = summary.getNotFoundMultiStatus().getChild(0);
            int code = status.getCode();
            String msg = Messages.ArtifactOperationRecord_results_not_found;
            IStatus[] children = summary.getNotFoundMultiStatus().getChildren();
            CicMultiStatus ms = Statuses.ST.createMultiStatus(code, children, msg, new Object[0]);
            return ms;
        }
        if (summary.getWarningMultiStatus().hasChildren()) {
            int code = 5;
            String msg = Messages.ArtifactOperationRecord_results;
            IStatus[] children = summary.getWarningMultiStatus().getChildren();
            CicMultiStatus ms = Statuses.ST.createMultiStatus(code, children, msg, new Object[0]);
            return ms;
        }
        return Status.OK_STATUS;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.results.size()) {
            sb.append(" res[");
            sb.append(i);
            sb.append("]=");
            String str = this.getHistoryStatus(i).getMessage();
            sb.append(str);
            ++i;
        }
        return sb.toString();
    }
}

