/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.agentAndAuthor;

import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Plugin;

public class TruncatedArtifactWarningExceptions {
    private static final Logger log = Logger.getLogger(TruncatedArtifactWarningExceptions.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());

    public static void saveLocationTruncationExceptions(File file, String comment, Map exceptions) throws IOException {
        ArrayList sorted = new ArrayList(exceptions.keySet());
        Collections.sort(sorted);
        LinkedHashMap<String, String> sortedMap = new LinkedHashMap<String, String>(sorted.size());
        for (String key : sorted) {
            Object value = exceptions.get(key);
            sortedMap.put(key, value.toString());
        }
        FileOutputStream out = new FileOutputStream(file);
        TruncatedArtifactWarningExceptions.store(sortedMap, out, comment);
    }

    public static Map readLocationTruncationExceptions(File file) throws FileNotFoundException, IOException {
        return TruncatedArtifactWarningExceptions.readLocationTruncationExceptions(file.toString(), new FileInputStream(file));
    }

    public static Map readLocationTruncationExceptions(String source, InputStream in) throws FileNotFoundException, IOException {
        LinkedHashMap<String, Long> locationTruncationExceptions = null;
        Properties properties = new Properties();
        TruncatedArtifactWarningExceptions.load(properties, in);
        locationTruncationExceptions = new LinkedHashMap<String, Long>(properties.size());
        TruncatedArtifactWarningExceptions.parseTruncationExceptions(source, properties, locationTruncationExceptions);
        return locationTruncationExceptions;
    }

    public static void parseTruncationExceptions(String source, Properties properties, Map<String, Long> map) {
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> element;
            Map.Entry<Object, Object> entry = element = iterator.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            try {
                map.put(key, new Long(value));
            }
            catch (NumberFormatException e) {
                log.error(Messages.TruncatedArtifactWarningExceptions_IgnoringEntry, value, key, source, e);
            }
        }
    }

    private static void load(Properties properties, InputStream in) throws IOException {
        try {
            properties.load(in);
        }
        finally {
            FileUtil.close(in);
        }
    }

    private static void store(LinkedHashMap exceptions, OutputStream out, String comment) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        try {
            if (comment != null) {
                writer.write(35);
                writer.write(LogUtil.fixNewlines(comment));
                writer.newLine();
            }
            writer.write(35);
            writer.write(new Date().toString());
            writer.newLine();
            for (Map.Entry entry : exceptions.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                writer.write(key);
                writer.write(61);
                writer.write(value);
                writer.newLine();
            }
            writer.flush();
        }
        finally {
            FileUtil.close(out);
        }
    }
}

