/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.downloads;

import com.ibm.cic.common.core.internal.downloads.NullHasIsCanceledMonitor;
import com.ibm.cic.common.downloads.DownloadContext;
import com.ibm.cic.common.downloads.IDownloadContext;
import com.ibm.cic.common.downloads.IHasIsCanceled;
import com.ibm.cic.common.downloads.IRestorePrevious;
import com.ibm.cic.common.downloads.ITransferMonitor;
import com.ibm.cic.common.downloads.handlerImpl.DownloadCancelMonitorUtil;
import org.eclipse.core.runtime.IProgressMonitor;

public class DownloadContextThreadLocalInheritedAndGlobal {
    private static final DownloadContext globalContext = new DownloadContext();
    private static InheritableThreadLocal threadContext = new InheritableThreadLocal(){

        @Override
        protected Object initialValue() {
            return new DownloadContext();
        }
    };
    public static final IDownloadContext CONTEXT = new ThreadThenGlobalDownloadContext();

    public static DownloadContext getThreadContext() {
        return (DownloadContext)threadContext.get();
    }

    public static DownloadContext getGlobalContext() {
        return globalContext;
    }

    public static IHasIsCanceled getDownloadCancelMonitor() {
        IDownloadContext ctxt = CONTEXT;
        return DownloadCancelMonitorUtil.getDownloadCancelMonitor(ctxt);
    }

    public static IHasIsCanceled getDownloadCancelMonitorNotNull() {
        IHasIsCanceled cancelMonitor = DownloadContextThreadLocalInheritedAndGlobal.getDownloadCancelMonitor();
        if (cancelMonitor == null) {
            cancelMonitor = NullHasIsCanceledMonitor.INSTANCE;
        }
        return cancelMonitor;
    }

    public static boolean isDownloadCanceled() {
        IHasIsCanceled cancelMonitor = DownloadContextThreadLocalInheritedAndGlobal.getDownloadCancelMonitorNotNull();
        return cancelMonitor.isCanceled();
    }

    public static CancelMonitorRestorePrevious setupDownloadHandlerCancel(IProgressMonitor monitor) {
        IHasIsCanceled uiCancelMonitor = DownloadCancelMonitorUtil.getDownloadUICancelMonitor(CONTEXT);
        IRestorePrevious restorePrevious = null;
        if (uiCancelMonitor == null) {
            IHasIsCanceled cancelMonitor = DownloadContextThreadLocalInheritedAndGlobal.makeCancelMonitor(monitor);
            restorePrevious = DownloadCancelMonitorUtil.setContextCancelMonitor(DownloadContextThreadLocalInheritedAndGlobal.getThreadContext(), cancelMonitor);
            return new CancelMonitorRestorePrevious(restorePrevious, cancelMonitor);
        }
        return new CancelMonitorRestorePrevious(null, uiCancelMonitor);
    }

    public static CancelMonitorRestorePrevious setupDownloadHandlerCancel(ITransferMonitor transferMonitor) {
        assert (transferMonitor != null);
        IHasIsCanceled uiCancelMonitor = DownloadCancelMonitorUtil.getDownloadUICancelMonitor(CONTEXT);
        IRestorePrevious restorePrevious = null;
        if (uiCancelMonitor == null) {
            restorePrevious = DownloadCancelMonitorUtil.setContextCancelMonitor(DownloadContextThreadLocalInheritedAndGlobal.getThreadContext(), transferMonitor);
            return new CancelMonitorRestorePrevious(restorePrevious, transferMonitor);
        }
        return new CancelMonitorRestorePrevious(null, uiCancelMonitor);
    }

    private static IHasIsCanceled makeCancelMonitor(final IProgressMonitor monitor) {
        IHasIsCanceled cancelMonitor = new IHasIsCanceled(){

            @Override
            public boolean isCanceled() {
                boolean b;
                boolean bl = b = monitor != null ? monitor.isCanceled() : false;
                if (b) {
                    DownloadContextThreadLocalInheritedAndGlobal.easyBreakPointWhenCanceled();
                }
                return b;
            }
        };
        return cancelMonitor;
    }

    private static void easyBreakPointWhenCanceled() {
    }

    public static class CancelMonitorRestorePrevious
    implements IRestorePrevious {
        private final IRestorePrevious restorePrevious;
        private final IHasIsCanceled cancelMonitor;

        CancelMonitorRestorePrevious(IRestorePrevious restorePrevious, IHasIsCanceled cancelMonitor) {
            this.restorePrevious = restorePrevious;
            this.cancelMonitor = cancelMonitor;
        }

        public IHasIsCanceled getCancelMonitor() {
            return this.cancelMonitor;
        }

        @Override
        public void restore() {
            if (this.restorePrevious != null) {
                this.restorePrevious.restore();
            }
        }
    }

    private static final class ThreadThenGlobalDownloadContext
    implements IDownloadContext {
        private ThreadThenGlobalDownloadContext() {
        }

        @Override
        public Object get(Object key) {
            DownloadContext dc = (DownloadContext)threadContext.get();
            Object value = dc.get(key);
            if (value != null) {
                return value;
            }
            return globalContext.get(key);
        }

        @Override
        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(Object key) {
            throw new UnsupportedOperationException();
        }
    }
}

