/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.cmd;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.ServiceRepositoryUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class ConsoleRepositoryUtils {
    public static CicMultiStatus openServiceRepositories(final ServiceRepositoryUtils.IOpenServiceRepo openCallback, IRepositoryGroup group, IOffering[] offerings, IProgressMonitor monitor) {
        final CicMultiStatus ms = Statuses.ST.createMultiStatus(Messages.SilentRepositoryUtils_problemsConnectingServiceRepos, new Object[0]);
        ServiceRepositoryUtils.loadServiceRepositories(new ServiceRepositoryUtils.DefaultOpenServiceRepo(){

            @Override
            public IRepository openServiceRepository(IRepositoryGroup destinationGroup, IOffering offering, IRepositoryInfo repInfo) throws CoreException {
                try {
                    return openCallback.openServiceRepository(destinationGroup, offering, repInfo);
                }
                catch (CoreException e) {
                    CicMultiStatus ms2 = Statuses.ST.createMultiStatus(Messages.SilentRepositoryUtils_problemConnectingToServiceRepo, repInfo.getLocationStr(), ConsoleRepositoryUtils.formatOffering(offering));
                    ms2.add(e.getStatus());
                    ms.add(ms2);
                    throw e;
                }
            }
        }, null, null, group, offerings, monitor);
        return ms;
    }

    protected static String formatOffering(IOffering offering) {
        return NLS.bind("{0}_{1} : {2} : {3}", offering.getIdentity().getId(), offering.getVersion(), offering.getName(), OfferingUtil.getDisplayableVersion(offering));
    }
}

