/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.cmd;

import com.ibm.cic.common.core.cmd.CmdIterator;
import com.ibm.cic.common.core.cmd.CmdParamList;
import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CmdParamProperties
extends CmdParamList {
    private Map<String, String> value;

    public CmdParamProperties(String id, String header) {
        super(id, header);
    }

    @Override
    public Object getObjVal() {
        return this.value;
    }

    @Override
    protected IStatus loadCommandLineData(CmdIterator cmdData, boolean testOnly) {
        IStatus status = super.loadCommandLineData(cmdData, testOnly);
        if (!status.isOK()) {
            return status;
        }
        List listValue = (List)super.getObjVal();
        this.value = new LinkedHashMap<String, String>(listValue.size());
        ArrayList<String> invalidKeys = new ArrayList<String>();
        for (String entry : listValue) {
            int charIndex = entry.indexOf("=");
            if (charIndex == -1) {
                invalidKeys.add(entry);
                continue;
            }
            if (testOnly) continue;
            this.value.put(entry.substring(0, charIndex), entry.substring(charIndex + 1));
        }
        if (!invalidKeys.isEmpty()) {
            StringBuilder errMsg = new StringBuilder();
            errMsg.append(NLS.bind(Messages.Cmd_Error_Incorrect_Parameter_Format, (Object)this.id(), (Object)this.getStrVal()));
            if (listValue.size() > 1) {
                errMsg.append(CommonDef.EOL);
                errMsg.append(NLS.bind(Messages.Cmd_Error_Incorrect_Parameter_KeyNoValue, (Object)Util.toString(invalidKeys, new Util.Formatter())));
            }
            return Statuses.ERROR.get(8006, errMsg.toString(), new Object[0]);
        }
        return Status.OK_STATUS;
    }

    @Override
    public CmdParamProperties makeCopy() {
        assert (this.value == null);
        return new CmdParamProperties(this.id(), this.getHeader());
    }

    @Override
    public void reset() {
        super.reset();
        this.value.clear();
    }
}

