/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.cmd;

import com.ibm.cic.common.core.cmd.ACmdParam;
import com.ibm.cic.common.core.cmd.CmdIterator;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CmdParamDir
extends ACmdParam {
    public CmdParamDir(String id, String header) {
        super(id, header);
    }

    @Override
    public CmdParamDir makeCopy() {
        CmdParamDir result = new CmdParamDir(this.id(), this.getHeader());
        if (this.getStrVal() != null) {
            result.setStrValue(this.getStrVal());
        }
        return result;
    }

    @Override
    public Object getObjVal() {
        return new File(this.getStrVal());
    }

    @Override
    protected IStatus loadCommandLineData(CmdIterator cmdData, boolean testOnly) {
        IStatus return_value = Status.OK_STATUS;
        File file = new File(cmdData.getCurrentArg());
        String canonicalPath = null;
        if (!file.isFile()) {
            try {
                canonicalPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                ExceptionUtil.log.warning(e);
            }
        }
        if (canonicalPath != null) {
            if (!testOnly) {
                this.setStrValue(cmdData.getCurrentArg());
            }
        } else {
            return_value = Statuses.ERROR.get(8008, Messages.Cmd_Error_Incorrect_Parameter_BadDirectory, cmdData.getCurrentArg());
        }
        if (!testOnly) {
            cmdData.consumeCurrentArg();
        }
        return return_value;
    }
}

