/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.auth;

import com.ibm.cic.common.core.auth.PasswordChangeDirection;
import org.eclipse.equinox.internal.security.storage.SecurePreferencesWrapper;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;

public enum PasswordManager {
    INSTANCE;

    private static final String PREFERENCES_CIC_DEFAULTPASSWORDUSED = "org.eclipse.equinox.security.preferences.cic.defaultpasswordused";
    private PasswordChangeDirection passwordChangeDirection = PasswordChangeDirection.TO_ANY;
    private boolean bPasswordFileUsed = false;
    private boolean bDefaultUsed = false;
    private boolean bPasswordDialogCanceled = false;

    public void reset() {
        this.passwordChangeDirection = PasswordChangeDirection.TO_ANY;
        this.bPasswordFileUsed = false;
        this.bDefaultUsed = false;
        this.bPasswordDialogCanceled = false;
    }

    public void setChangeDirection(PasswordChangeDirection d) {
        this.passwordChangeDirection = d;
    }

    public PasswordChangeDirection getChangeDirection() {
        return this.passwordChangeDirection;
    }

    public void usePasswordFile(boolean val) {
        this.bPasswordFileUsed = val;
    }

    public boolean isPasswordFromFile() {
        return this.bPasswordFileUsed;
    }

    public void useDefault(boolean value) {
        this.bDefaultUsed = value;
    }

    public boolean isDefault() {
        return this.bDefaultUsed;
    }

    public void savePasswordUsage() throws StorageException {
        SecurePreferencesFactory.getDefault().putBoolean(PREFERENCES_CIC_DEFAULTPASSWORDUSED, this.isDefault(), false);
    }

    public boolean loadPasswordUsage() throws StorageException {
        return SecurePreferencesFactory.getDefault().getBoolean(PREFERENCES_CIC_DEFAULTPASSWORDUSED, false);
    }

    public void setPasswordDialogCanceled(boolean val) {
        this.bPasswordDialogCanceled = val;
    }

    public boolean isPasswordDialogCanceled() {
        return this.bPasswordDialogCanceled;
    }

    public boolean triggerPasswordPrompt(ISecurePreferences node) {
        String[] childrenNames;
        String[] keys;
        String[] stringArray = keys = node.keys();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                String key = stringArray[n2];
                try {
                    String encryptionModule;
                    if (node.isEncrypted(key) && node instanceof SecurePreferencesWrapper && (encryptionModule = ((SecurePreferencesWrapper)node).getModule(key)) != null && encryptionModule.equals("com.ibm.cic.security.storage.capilanopasswordprovider")) {
                        node.get(key, null);
                    }
                }
                catch (StorageException storageException) {
                    if (!this.isPasswordDialogCanceled()) break block6;
                    return false;
                }
            }
            ++n2;
        }
        String[] stringArray2 = childrenNames = node.childrenNames();
        int n3 = childrenNames.length;
        n = 0;
        while (n < n3) {
            String name = stringArray2[n];
            if (!this.triggerPasswordPrompt(node.node(name))) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

