/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.auth;

import com.ibm.cic.common.core.auth.AuthorizationInfoFromSecureStorage;
import com.ibm.cic.common.core.auth.Messages;
import com.ibm.cic.common.core.auth.PasswordManager;
import com.ibm.cic.common.core.cmd.KeyringCommands;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.ApplicationArguments;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.eclipse.internals.authstore.AuthorizationInfoFromOldKeyring;
import java.io.File;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.StorageException;

public class AuthorizationInfo {
    private static final String SECURE_STORAGE = "secure_storage";
    public static final String CMD_SECURE_PASSWORD_FILE = "-masterPasswordFile";
    public static final String CMD_SECURE_STORAGE_FILE = "-secureStorageFile";
    public static final String CAPILANO_PROVIDER_MODULE_ID = "com.ibm.cic.security.storage.capilanopasswordprovider";
    private static boolean bLegacyKeyring = false;

    public static boolean isLegacyKeyringActive() {
        return bLegacyKeyring;
    }

    public static void setLegacyKeyringActive(boolean bActive) {
        bLegacyKeyring = bActive;
    }

    public static synchronized IStatus determineKeyringMechanism(boolean isInteractiveMode) {
        boolean isMasterPasswordSet;
        IStatus result = Status.OK_STATUS;
        ApplicationArguments args = ApplicationArguments.getInstance();
        args.replace(KeyringCommands.CMD_SECURE_STORAGE_FILE, KeyringCommands.CMD_ECLIPSE_KEYRING);
        args.replace(KeyringCommands.CMD_MASTER_PASSWORD_FILE, KeyringCommands.CMD_MASTER_PASSWORD_FILE);
        boolean isSecureStorageSet = args.contains(KeyringCommands.CMD_ECLIPSE_KEYRING);
        boolean bl = isMasterPasswordSet = args.contains(KeyringCommands.CMD_MASTER_PASSWORD_FILE) || args.contains(KeyringCommands.CMD_ECLIPSE_PASSWORD);
        if (args.contains(KeyringCommands.CMD_KEYRING) && !isSecureStorageSet && !isMasterPasswordSet) {
            AuthorizationInfo.setLegacyKeyringActive(true);
            result = Statuses.WARNING.get(Messages.AuthorizationInfo_DeprecatedKeyringOptions, new Object[0]);
        } else {
            AuthorizationInfo.setLegacyKeyringActive(false);
            if (isMasterPasswordSet) {
                String passwordFile = args.getNextArg(KeyringCommands.CMD_MASTER_PASSWORD_FILE);
                if (passwordFile == null) {
                    passwordFile = args.getNextArg(KeyringCommands.CMD_ECLIPSE_PASSWORD);
                }
                if (!(result = AuthorizationInfoFromSecureStorage.verifyMasterPasswordFile(passwordFile)).isOK()) {
                    args.restore();
                }
                PasswordManager.INSTANCE.usePasswordFile(true);
            }
            if (!isSecureStorageSet) {
                File f = new File(CicCommonSettings.getApplicationDataLocation(), SECURE_STORAGE);
                args.add(KeyringCommands.CMD_ECLIPSE_KEYRING.id(), f.getAbsolutePath());
            }
            if (result.isOK()) {
                result = AuthorizationInfoFromSecureStorage.verifySecureStorageFile(isInteractiveMode);
            }
            AuthorizationInfoFromSecureStorage.setSecureStoragePreferences();
        }
        return result;
    }

    public static Map getAuthorizationInfo(URL serverUrl, String realm, String authScheme) {
        return AuthorizationInfo.isLegacyKeyringActive() ? AuthorizationInfoFromOldKeyring.getAuthorizationInfo((URL)serverUrl, (String)realm, (String)authScheme) : AuthorizationInfoFromSecureStorage.getAuthorizationInfo(serverUrl, realm, authScheme);
    }

    public static void addAuthorizationInfo(URL serverUrl, String realm, String authScheme, Map info) throws CoreException, StorageException {
        if (AuthorizationInfo.isLegacyKeyringActive()) {
            AuthorizationInfoFromOldKeyring.addAuthorizationInfo((URL)serverUrl, (String)realm, (String)authScheme, (Map)info);
        } else {
            AuthorizationInfoFromSecureStorage.addAuthorizationInfo(serverUrl, realm, authScheme, info);
        }
    }

    public static void flushAuthorizationInfo(URL serverUrl, String realm, String authScheme) throws CoreException {
        if (AuthorizationInfo.isLegacyKeyringActive()) {
            AuthorizationInfoFromOldKeyring.flushAuthorizationInfo((URL)serverUrl, (String)realm, (String)authScheme);
        } else {
            AuthorizationInfoFromSecureStorage.flushAuthorizationInfo(serverUrl, realm, authScheme);
        }
    }
}

