/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.impl.ContentInfoUtil;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserName;
import com.ibm.cic.common.downloads.DigestValue;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.downloads.IDownloaded;
import com.ibm.cic.common.downloads.IDownloadedFile;
import com.ibm.cic.common.downloads.IMutableContentInfo;
import com.ibm.cic.common.downloads.ResumableDownloadProgress;
import com.ibm.cic.common.downloads.SimpleContentInfo;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ContentInfoComputation {
    private final byte[] buf;
    static final String[] preferredAlgorithms = new String[]{"MD5", "SHA-1"};
    public static final String PREFERRED_ALGORITHM = "MD5";
    private static Object testCallbacksOnVerifyContentInfo = null;

    public ContentInfoComputation(byte[] buf) {
        this.buf = buf;
    }

    public static String[] getPreferredAlgorithms() {
        return preferredAlgorithms;
    }

    public static List getPreferredAlgorithmAsList() {
        return Collections.singletonList(PREFERRED_ALGORITHM);
    }

    public IContentInfo computeDigest(IDownloadedFile dlFile, String algorithm, ResumableDownloadProgress.IVerificationProgress progress) throws IOException {
        File file = dlFile.getFile();
        long progressLength = this.getProgressLength(dlFile);
        SimpleContentInfo newContentInfo = new SimpleContentInfo();
        ArrayList<String> algorithms = new ArrayList<String>();
        algorithms.add(algorithm);
        long size = this.computeDigests(newContentInfo, algorithms, new FileInputStream(file), progressLength, progress);
        if (progress.isCanceled()) {
            return null;
        }
        newContentInfo.setSize(size);
        return newContentInfo;
    }

    private long getProgressLength(IDownloadedFile dlFile) {
        long progressLength = Long.MIN_VALUE;
        if (dlFile.getDownloadContentInfo() != null) {
            progressLength = dlFile.getDownloadContentInfo().getSizeInfo().getDownloadSize();
        }
        if (progressLength == Long.MIN_VALUE) {
            File file = dlFile.getFile();
            progressLength = file.length();
        }
        return progressLength;
    }

    public IContentInfo computeDigest(UserName thing, InputStream is, long length, String algorithm, IProgressMonitor monitor) throws IOException {
        VerificationProgessMonitor progress = new VerificationProgessMonitor(monitor, thing.toString());
        return this.computeDigest(is, length, algorithm, progress);
    }

    public IContentInfo computeDigest(InputStream is, long length, String algorithm, ResumableDownloadProgress.IVerificationProgress progress) throws IOException {
        SimpleContentInfo newContentInfo = new SimpleContentInfo();
        ArrayList<String> algorithms = new ArrayList<String>();
        algorithms.add(algorithm);
        long size = this.computeDigests(newContentInfo, algorithms, is, length, progress);
        if (progress.isCanceled()) {
            return null;
        }
        newContentInfo.setSize(size);
        return newContentInfo;
    }

    public IContentInfo computePreferredDigest(IDownloaded dl, Collection algorithms, ResumableDownloadProgress.IVerificationProgress progress) throws IOException {
        if (algorithms.size() == 0) {
            throw new IllegalArgumentException();
        }
        String algorithm = null;
        String[] stringArray = preferredAlgorithms;
        int n = preferredAlgorithms.length;
        int n2 = 0;
        while (n2 < n) {
            String prefAlg = stringArray[n2];
            if (algorithms.contains(prefAlg)) {
                algorithm = prefAlg;
                break;
            }
            ++n2;
        }
        if (algorithm == null) {
            algorithm = (String)algorithms.iterator().next();
        }
        return this.computeDigest(dl, algorithm, progress);
    }

    public static IStatus computeDigests(IDownloadSession session, UserName thing, InputStream in, long length, String algorithm, IProgressMonitor monitor, IMutableContentInfo outContentInfo) {
        ContentInfoComputation cic = null;
        try {
            IContentInfo ciComputed;
            IStatus status;
            block8: {
                cic = session.getContentInfoComputer();
                try {
                    status = Status.OK_STATUS;
                    ciComputed = cic.computeDigest(thing, in, length, algorithm, monitor);
                    if (ciComputed != null) break block8;
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                catch (IOException e) {
                    ICicStatus status2;
                    String msg = NLS.bind(Messages.exception, (Object)thing);
                    ICicStatus iCicStatus = status2 = Statuses.ERROR.get(999, e, msg, new Object[0]);
                    return iCicStatus;
                }
            }
            DigestValue digest = ciComputed.getDigestValue(algorithm);
            outContentInfo.setDigestValue(digest);
            outContentInfo.setSize(ciComputed.getSizeInfo().getDownloadSize());
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            if (cic != null) {
                session.releaseContentInfoComputer(cic);
            }
        }
    }

    /*
     * Loose catch block
     */
    public static ICicStatus computeDigests(IDownloadSession session, UserName thing, IDownloaded dl, Collection algorithms, IProgressMonitor monitor, IMutableContentInfo outContentInfo) {
        ContentInfoComputation cic = null;
        try {
            IContentInfo ciComputed;
            cic = session.getContentInfoComputer();
            ICicStatus status = ICicStatus.OK_STATUS;
            try {
                ciComputed = cic.computeDigests(thing, dl, algorithms, monitor);
                if (ciComputed == null) {
                    ICicStatus iCicStatus = ICicStatus.CANCEL_STATUS;
                    return iCicStatus;
                }
            }
            catch (IOException e) {
                ICicStatus iCicStatus = status = Statuses.ERROR.get(999, e, Messages.exception, thing);
                if (cic != null) {
                    session.releaseContentInfoComputer(cic);
                }
                return iCicStatus;
            }
            for (String algorithm : algorithms) {
                DigestValue digest = ciComputed.getDigestValue(algorithm);
                outContentInfo.setDigestValue(digest);
            }
            outContentInfo.setSize(ciComputed.getSizeInfo().getDownloadSize());
            if (monitor.isCanceled()) {
                ICicStatus iCicStatus = ICicStatus.CANCEL_STATUS;
                return iCicStatus;
            }
            ICicStatus iCicStatus = status;
            return iCicStatus;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (cic != null) {
                session.releaseContentInfoComputer(cic);
            }
        }
    }

    public IContentInfo computeDigests(UserName thing, IDownloaded dl, Collection algorithms, IProgressMonitor monitor) throws IOException {
        if (algorithms.size() == 0) {
            throw new IllegalArgumentException();
        }
        VerificationProgessMonitor progress = new VerificationProgessMonitor(monitor, thing.toString());
        if (dl instanceof IDownloadedFile) {
            IDownloadedFile df = (IDownloadedFile)dl;
            return this.doComputeDigests(thing, df, algorithms, progress);
        }
        throw new AssertionError();
    }

    private IContentInfo doComputeDigests(UserName thing, IDownloadedFile df, Collection algorithms, ResumableDownloadProgress.IVerificationProgress progress) throws FileNotFoundException, IOException {
        File file = df.getFile();
        SimpleContentInfo newContentInfo = new SimpleContentInfo();
        long progressLength = this.getProgressLength(df);
        long size = this.computeDigests(newContentInfo, algorithms, new FileInputStream(file), progressLength, progress);
        if (progress.isCanceled()) {
            return null;
        }
        newContentInfo.setSize(size);
        return newContentInfo;
    }

    public IContentInfo computeDigest(IDownloaded dl, String algorithm, ResumableDownloadProgress.IVerificationProgress progress) throws IOException {
        if (dl instanceof IDownloadedFile) {
            IDownloadedFile df = (IDownloadedFile)dl;
            return this.computeDigest(df, algorithm, progress);
        }
        throw new AssertionError();
    }

    public long computeDigests(IMutableContentInfo newContentInfo, Collection computeDigests, InputStream stream, long progressLength, ResumableDownloadProgress.IVerificationProgress progress) throws IOException {
        if (computeDigests.size() == 0) {
            FileUtil.close(stream);
            return -1L;
        }
        if (progressLength == 0L) {
            progressLength = 1L;
        }
        InputStream in = stream;
        progress.beginVerification();
        try {
            int n;
            ArrayList<DigestInputStream> filters = new ArrayList<DigestInputStream>();
            for (String alg : computeDigests) {
                MessageDigest md;
                try {
                    md = MessageDigest.getInstance(alg);
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                    continue;
                }
                DigestInputStream din = new DigestInputStream(in, md);
                filters.add(din);
                in = din;
            }
            long size = 0L;
            while ((n = in.read(this.buf)) != -1) {
                int percent = (int)((size += (long)n) * 100L / progressLength);
                progress.updateVerificationProgress(percent);
                if (!progress.isCanceled()) continue;
                return -1L;
            }
            FileUtil.close(in);
            in = null;
            for (DigestInputStream dis : filters) {
                MessageDigest md = dis.getMessageDigest();
                newContentInfo.setDigestValue(new DigestValue(md.getAlgorithm(), md.digest()));
            }
            long l = size;
            return l;
        }
        finally {
            FileUtil.close(in);
            progress.endVerification();
        }
    }

    public static DigestValue computeDigest(String algorithm, byte[] bytes) throws NoSuchAlgorithmException {
        assert (algorithm != null);
        MessageDigest md = MessageDigest.getInstance(algorithm);
        byte[] hashValue = md.digest(bytes);
        return new DigestValue(algorithm, hashValue);
    }

    public static DigestValue computePreferredDigest(byte[] bytes) throws NoSuchAlgorithmException {
        String algorithm = ContentInfoComputation.getPreferredAlgorithms()[0];
        return ContentInfoComputation.computeDigest(algorithm, bytes);
    }

    public static class ComputeContentInfoInputStream
    extends InputStream {
        private final ArrayList filters;
        private InputStream is;
        private final IMutableContentInfo mci;
        private IContentInfo actualContentInfo;
        private long bytes;

        public ComputeContentInfoInputStream(Collection computeDigests, IMutableContentInfo mci, InputStream is) {
            this.mci = mci;
            this.filters = new ArrayList(computeDigests.size());
            this.is = is;
            this.bytes = 0L;
            this.actualContentInfo = null;
            for (String alg : computeDigests) {
                MessageDigest md;
                try {
                    md = MessageDigest.getInstance(alg);
                }
                catch (NoSuchAlgorithmException e) {
                    Logger.getGlobalLogger().error(e);
                    continue;
                }
                DigestInputStream din = new DigestInputStream(is, md);
                this.filters.add(din);
                this.is = din;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.actualContentInfo == null) {
                this.exhaustStream(new byte[4096], this.is);
                for (DigestInputStream din : this.filters) {
                    MessageDigest md = din.getMessageDigest();
                    this.mci.setDigestValue(new DigestValue(md.getAlgorithm(), md.digest()));
                }
                this.mci.setSize(this.bytes);
                this.actualContentInfo = new SimpleContentInfo(this.mci);
            }
            this.is.close();
        }

        private long exhaustStream(byte[] buf, InputStream in) throws IOException {
            try {
                int n;
                while ((n = in.read(buf)) != -1) {
                    this.bytes += (long)n;
                }
                long l = n;
                return l;
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                in.close();
            }
        }

        public IContentInfo getActualContentInfo() {
            return this.actualContentInfo;
        }

        @Override
        public int available() throws IOException {
            return this.is.available();
        }

        @Override
        public int read() throws IOException {
            int rc = this.is.read();
            if (rc != -1) {
                ++this.bytes;
            }
            return rc;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int rc = this.is.read(b);
            if (rc != -1) {
                this.bytes += (long)rc;
            }
            return rc;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int rc = this.is.read(b, off, len);
            if (rc != -1) {
                this.bytes += (long)rc;
            }
            return rc;
        }

        @Override
        public long skip(long n) throws IOException {
            return super.skip(n);
        }
    }

    public static class ComputeContentInfoOutputStream
    extends OutputStream {
        private final ArrayList filters;
        private OutputStream os;
        private final IMutableContentInfo mci;
        private long bytesWritten;

        public ComputeContentInfoOutputStream(Collection computeDigests, IMutableContentInfo mci, OutputStream os) {
            this.mci = mci;
            this.filters = new ArrayList(computeDigests.size());
            this.os = os;
            this.bytesWritten = 0L;
            for (String alg : computeDigests) {
                MessageDigest md;
                try {
                    md = MessageDigest.getInstance(alg);
                }
                catch (NoSuchAlgorithmException e) {
                    Logger.getGlobalLogger().error(e);
                    continue;
                }
                DigestOutputStream dout = new DigestOutputStream(os, md);
                this.filters.add(dout);
                this.os = dout;
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void close() throws IOException {
            try {
                this.os.close();
            }
            finally {
                ** for (dos : this.filters)
            }
lbl-1000:
            // 1 sources

            {
                md = dos.getMessageDigest();
                this.mci.setDigestValue(new DigestValue(md.getAlgorithm(), md.digest()));
                continue;
            }
lbl9:
            // 1 sources

            this.mci.setSize(this.bytesWritten);
        }

        @Override
        public void flush() throws IOException {
            this.os.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.os.write(b, off, len);
            this.bytesWritten += (long)len;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.os.write(b);
            this.bytesWritten += (long)b.length;
        }

        @Override
        public void write(int b) throws IOException {
            this.os.write(b);
            ++this.bytesWritten;
        }
    }

    public static class ContentInfoValidatingInputStream
    implements IValidatingInputStream {
        private final Object source;
        private final ComputeContentInfoInputStream is;
        private final IContentInfo expectedContentInfo;

        public ContentInfoValidatingInputStream(Object source, ComputeContentInfoInputStream is, IContentInfo expectedContentInfo) {
            assert (is != null);
            assert (expectedContentInfo != null);
            this.source = source;
            this.is = is;
            this.expectedContentInfo = expectedContentInfo;
        }

        @Override
        public Object getSource() {
            return this.source;
        }

        @Override
        public InputStream getInputStream() {
            return this.is;
        }

        @Override
        public long getContentLength() {
            long size = this.expectedContentInfo.getSizeInfo().getDownloadSize();
            if (size == Long.MIN_VALUE) {
                return -1L;
            }
            return size;
        }

        public IContentInfo getExpectedContentInfo() {
            return this.expectedContentInfo;
        }

        public IContentInfo getActualContentInfo() {
            return this.is.actualContentInfo;
        }

        @Override
        public IStatus getValidityStatus() {
            IStatus status = this.privateGetValidityStatus();
            TestCallbackOnVerifyContentInfo.fireVerifyContentInfo(this.source, this.getExpectedContentInfo(), this.getActualContentInfo(), status);
            return status;
        }

        private IStatus privateGetValidityStatus() {
            boolean okForMissingDigest = false;
            IContentInfo actual = this.is.getActualContentInfo();
            if (actual == null) {
                return Statuses.ERROR.get(24, Messages.ContentInfoComputation_actualContentInfoMissing, new Object[0]);
            }
            IStatus status = ContentInfoUtil.validate(okForMissingDigest, this.expectedContentInfo, actual, null);
            if (!status.isOK()) {
                return status;
            }
            long expectedSize = this.expectedContentInfo.getSizeInfo().getDownloadSize();
            long actualSize = actual.getSizeInfo().getDownloadSize();
            if (expectedSize != Long.MIN_VALUE && expectedSize != actualSize) {
                String msg = NLS.bind(Messages.ContentInfoComputation_mismatchedDownloadSize, (Object)expectedSize, (Object)actualSize);
                return Statuses.ERROR.get(29, msg, new Object[0]);
            }
            return Status.OK_STATUS;
        }
    }

    public static interface IValidatingInputStream {
        public Object getSource();

        public InputStream getInputStream();

        public IStatus getValidityStatus();

        public long getContentLength();
    }

    public static class NOOPValidatingInputStream
    implements IValidatingInputStream {
        private final Object source;
        private final long contentLength;
        private final InputStream is;

        public NOOPValidatingInputStream(Object source, long contentLength, InputStream is) {
            this.source = source;
            this.is = is;
            this.contentLength = contentLength;
        }

        @Override
        public IStatus getValidityStatus() {
            return Status.OK_STATUS;
        }

        @Override
        public InputStream getInputStream() {
            return this.is;
        }

        @Override
        public Object getSource() {
            return this.source;
        }

        @Override
        public long getContentLength() {
            return this.contentLength;
        }
    }

    public static class TestCallbackOnVerifyContentInfo {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TestCallbackOnVerifyContentInfo() {
            String[] stringArray = preferredAlgorithms;
            synchronized (preferredAlgorithms) {
                if (testCallbacksOnVerifyContentInfo == null) {
                    testCallbacksOnVerifyContentInfo = new ArrayList();
                }
                TestCallbackOnVerifyContentInfo.getCallbacks().add(this);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            String[] stringArray = preferredAlgorithms;
            synchronized (preferredAlgorithms) {
                TestCallbackOnVerifyContentInfo.getCallbacks().remove(this);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static List getCallbacks() {
            String[] stringArray = preferredAlgorithms;
            synchronized (preferredAlgorithms) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return (List)testCallbacksOnVerifyContentInfo;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void fireVerifyContentInfo(Object source, IContentInfo expectedContentInfo, IContentInfo actualContentInfo, IStatus status) {
            if (testCallbacksOnVerifyContentInfo == null) {
                return;
            }
            String[] stringArray = preferredAlgorithms;
            synchronized (preferredAlgorithms) {
                List l = TestCallbackOnVerifyContentInfo.getCallbacks();
                if (l.isEmpty()) {
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    return;
                }
                TestCallbackOnVerifyContentInfo[] callbacks = l.toArray(new TestCallbackOnVerifyContentInfo[l.size()]);
                // ** MonitorExit[var5_4] (shouldn't be in output)
                ValidatedInfo validated = new ValidatedInfo(source, expectedContentInfo, actualContentInfo, status);
                TestCallbackOnVerifyContentInfo[] testCallbackOnVerifyContentInfoArray = callbacks;
                int n = callbacks.length;
                int n2 = 0;
                while (n2 < n) {
                    TestCallbackOnVerifyContentInfo cb = testCallbackOnVerifyContentInfoArray[n2];
                    cb.onValidate(validated);
                    ++n2;
                }
                return;
            }
        }

        protected void onValidate(ValidatedInfo validated) {
        }
    }

    public static class ValidatedInfo {
        public final Object source;
        public final IContentInfo expectedContentInfo;
        public final IContentInfo actualContentInfo;
        public final IStatus validationStatus;

        public ValidatedInfo(Object source, IContentInfo expectedContentInfo, IContentInfo actualContentInfo, IStatus validationStatus) {
            this.source = source;
            this.expectedContentInfo = expectedContentInfo;
            this.actualContentInfo = actualContentInfo;
            this.validationStatus = validationStatus;
        }
    }

    public static class VerificationProgessMonitor
    implements ResumableDownloadProgress.IVerificationProgress {
        private final IProgressMonitor monitor;
        private final String userTextForStream;
        private int pct = 0;

        public VerificationProgessMonitor(IProgressMonitor monitor, String userTextForStream) {
            this.monitor = monitor;
            this.userTextForStream = userTextForStream;
        }

        @Override
        public void beginVerification() {
            String task = NLS.bind(Messages.task_computing_digests, (Object)this.userTextForStream);
            this.monitor.beginTask(task, 100);
        }

        @Override
        public void endVerification() {
            this.monitor.done();
        }

        @Override
        public void updateVerificationProgress(int percent) {
            if (percent > this.pct) {
                int work = percent - this.pct;
                this.monitor.worked(work);
                this.pct = percent;
            }
        }

        @Override
        public boolean isCanceled() {
            return this.monitor.isCanceled();
        }
    }
}

