/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.impl.ArtifactTableOfContents;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactTocModel;
import com.ibm.cic.common.core.artifactrepo.impl.AtocVersionInfo;
import com.ibm.cic.common.core.artifactrepo.impl.ElementHolder;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.utils.CicCommonCorePluginTrace;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.model.internal.DigestAttributes;
import com.ibm.cic.common.core.utils.MetaInfo;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.downloads.DigestValue;
import com.ibm.cic.common.downloads.DownloadException;
import com.ibm.cic.common.downloads.SimpleContentInfo;
import com.ibm.cic.common.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class ArtifactTocReader {
    private static final CicCommonCorePluginTrace trace = ComIbmCicCommonCorePlugin.getTrace();

    ArtifactTocReader() {
    }

    public static void parseToc(ArtifactTableOfContents.Parameters params, ArtifactTableOfContents.TocHolder tocHolder, InputStream input) throws IOException {
        trace.entering(tocHolder.getLocation());
        try {
            try {
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                parser.parse(input, (DefaultHandler)new TocHandler(params, tocHolder));
            }
            catch (ParserConfigurationException e) {
                Logger.getGlobalLogger().error(e.getLocalizedMessage());
                throw new IOException(e.toString());
            }
            catch (SAXException e) {
                Logger.getGlobalLogger().error(e.getLocalizedMessage());
                throw new IOException(e.toString());
            }
            catch (IOException e) {
                trace.catching(e);
                throw e;
            }
        }
        finally {
            input.close();
            trace.exiting();
        }
    }

    public static void parseContainedSet(ArtifactTableOfContents.Parameters params, ElementHolder.IHasHREF ref, ArtifactTableOfContents.ContainedSetHolder csetHolder, String location, InputStream input) throws IOException {
        trace.entering(new Object[]{csetHolder.getLocation(), location});
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(input, (DefaultHandler)new ContainedSetHandler(params, ref, csetHolder, location));
            trace.exiting();
        }
        catch (IOException e) {
            trace.catching(e);
            throw e;
        }
        catch (Exception e) {
            trace.catching(e);
            throw new DownloadException(e);
        }
    }

    private static class AbstractContentHandler
    extends DefaultHandler
    implements ArtifactTableOfContents.XMLConstants,
    AtocVersionInfo {
        protected Stack state = new Stack();
        protected final ArtifactTableOfContents.Parameters params;
        protected String location;
        protected Version version;
        private Locator locator = null;

        public AbstractContentHandler(ArtifactTableOfContents.Parameters params, String location) {
            this.params = params;
            this.location = location;
        }

        @Override
        public void processingInstruction(String target, String data) {
            if ("atoc".equals(target)) {
                this.version = MetaInfo.extractVersion(data);
            }
        }

        private Version ensureVersionCompatibility() throws SAXParseException {
            Version effective = this.version == null ? ATOC_VERSION_0 : this.version;
            if (!ATOC_TOLERANCE.isIncluded(effective)) {
                throw new SAXParseException(NLS.bind(Messages.ArtifactTocParser_incompatible_version, this.location, effective, ATOC_TOLERANCE), this.locator);
            }
            return effective;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("atoc")) {
                Object top = this.state.peek();
                if (top instanceof ArtifactTableOfContents.TocHolder) {
                    ArtifactTableOfContents.TocHolder tocHolder = (ArtifactTableOfContents.TocHolder)top;
                    String value = attributes.getValue("etag");
                    if (value != null) {
                        tocHolder.getToc().setETag(value);
                    }
                    Version effVer = this.ensureVersionCompatibility();
                    tocHolder.getToc().setVersion(effVer);
                    this.state.push(tocHolder.getToc());
                }
            } else if (qName.equals("cset")) {
                Object top;
                ArtifactTocModel.AbstractContainedSet cs;
                String href = attributes.getValue("href");
                if (href != null) {
                    ArtifactTocModel.ContainedSetReference csr = new ArtifactTocModel.ContainedSetReference();
                    csr.initHREF(href);
                    if (this.params.supportDigests()) {
                        SimpleContentInfo sci = new SimpleContentInfo();
                        DigestAttributes.setDigestValues(attributes, false, sci);
                        String sz = attributes.getValue("size");
                        if (sz != null) {
                            long size = Long.parseLong(sz);
                            sci.setSize(size);
                        }
                        csr.setContentInfo(sci);
                    }
                    cs = csr;
                } else {
                    cs = new ArtifactTocModel.ContainedSet();
                }
                String[] size = CONTAINED_SET_CAPTURED_ATTRIBUTES;
                int sz = CONTAINED_SET_CAPTURED_ATTRIBUTES.length;
                int sci = 0;
                while (sci < sz) {
                    String attr = size[sci];
                    String value = attributes.getValue(attr);
                    if (value != null) {
                        cs.setAttr(attr, value);
                        break;
                    }
                    ++sci;
                }
                String value = attributes.getValue("etag");
                if (value != null) {
                    cs.setETag(value);
                }
                if ((top = this.state.peek()) instanceof ArtifactTocModel.Toc) {
                    ArtifactTocModel.Toc tocAtTop = (ArtifactTocModel.Toc)top;
                    cs.initContainer(tocAtTop);
                    tocAtTop.getContents().add(cs);
                } else if (top instanceof ContainedSetHolderState) {
                    ContainedSetHolderState cshs = (ContainedSetHolderState)top;
                    ArtifactTableOfContents.ContainedSetHolder csh = cshs.getHolder();
                    csh.setContainedSet((ArtifactTocModel.ContainedSet)cs);
                    cs.initContainer(csh);
                    Version effVer = this.ensureVersionCompatibility();
                    ((ArtifactTocModel.ContainedSet)cs).setVersion(effVer);
                } else if (top instanceof ArtifactTocModel.ContainedSet) {
                    ArtifactTocModel.ContainedSet csetContainer = (ArtifactTocModel.ContainedSet)top;
                    if (!csetContainer.containsOnly(cs.getClass())) {
                        this.logWarning(NLS.bind(Messages.ArtifactTocReader_Ununiform_Content_Type, (Object)"cset"));
                    } else {
                        cs.initContainer(csetContainer);
                        List contained = csetContainer.getContained();
                        contained.add(cs);
                    }
                }
                this.state.push(cs);
            } else if (qName.equals("summary")) {
                Object top;
                ArtifactTocModel.Summary summary = new ArtifactTocModel.Summary();
                String value = attributes.getValue("count");
                if (value != null) {
                    summary.setCount(Integer.parseInt(value));
                }
                if ((value = attributes.getValue("totalSize")) != null) {
                    summary.setTotalSize(Long.parseLong(value));
                }
                if ((top = this.state.peek()) instanceof ArtifactTocModel.AbstractContainedSet) {
                    ArtifactTocModel.AbstractContainedSet csetContainer = (ArtifactTocModel.AbstractContainedSet)top;
                    csetContainer.setSummary(summary);
                } else if (top instanceof ArtifactTocModel.Toc) {
                    ArtifactTocModel.Toc toc = (ArtifactTocModel.Toc)top;
                    toc.setSummary(summary);
                }
                this.state.push(summary);
            } else if (qName.equals("af")) {
                ArtifactTocModel.Artifact artifact = new ArtifactTocModel.Artifact();
                String value = attributes.getValue("id");
                if (value != null) {
                    artifact.setIdString(value);
                }
                if ((value = attributes.getValue("v")) != null) {
                    artifact.setVersion(value);
                }
                if ((value = attributes.getValue("p")) != null) {
                    artifact.setPath((IPath)new Path(value));
                }
                if ((value = attributes.getValue("sz")) != null) {
                    artifact.setContentSize(Long.parseLong(value));
                }
                String valueExploded = null;
                valueExploded = attributes.getValue("ex");
                if (valueExploded != null) {
                    artifact.setExploded(Boolean.valueOf(valueExploded));
                }
                this.params.readExtraAttributes(attributes, artifact);
                Object top = this.state.peek();
                if (top instanceof ArtifactTocModel.ContainedSet) {
                    ArtifactTocModel.ContainedSet csetContainer = (ArtifactTocModel.ContainedSet)top;
                    if (!csetContainer.containsOnly(ArtifactTocModel.Artifact.class)) {
                        this.logWarning(NLS.bind(Messages.ArtifactTocReader_Ununiform_Content_Type, (Object)"af"));
                    } else {
                        artifact.initContainer(csetContainer);
                        List contained = csetContainer.getContained();
                        contained.add(artifact);
                        if (valueExploded == null && !UserOptions.maintainAtocCompatibility()) {
                            String ns = null;
                            int i = this.state.size() - 1;
                            while (i >= 0) {
                                Object o = this.state.get(i);
                                if (o instanceof ContainedSetHolderState) {
                                    ContainedSetHolderState cshs = (ContainedSetHolderState)o;
                                    ArtifactTocModel.ContainedSetReference csr = (ArtifactTocModel.ContainedSetReference)cshs.getRef();
                                    ns = ArtifactTocModel.Artifact.getFixedAttributeValue(csr, "n");
                                    break;
                                }
                                --i;
                            }
                            if (ns == null) {
                                ns = artifact.getNamespace();
                            }
                            if (ns.equals("eclipse")) {
                                String path = artifact.getPath() != null ? artifact.getPath().toString() : null;
                                boolean exploded = !CicConstants.getJarFileDotExt().equals(path);
                                artifact.setExploded(exploded);
                            }
                        }
                    }
                }
                this.state.push(artifact);
            } else if (qName.equals("dig")) {
                Object top = this.state.peek();
                if (top instanceof ArtifactTocModel.Artifact) {
                    ArtifactTocModel.Artifact artifact = (ArtifactTocModel.Artifact)top;
                    String da = attributes.getValue("da");
                    String dv = attributes.getValue("dv");
                    if (da != null && dv != null) {
                        artifact.setContentDigest(new DigestValue(da, dv));
                    }
                }
                this.state.push("dig");
            } else if (qName.equals("digs")) {
                Object top = this.state.peek();
                if (top instanceof ArtifactTocModel.Summary) {
                    ArtifactTocModel.Summary summary = (ArtifactTocModel.Summary)top;
                    String da = attributes.getValue("da");
                    String count = attributes.getValue("count");
                    if (da != null && count != null) {
                        summary.setDigestCount(da, Integer.parseInt(count));
                    }
                }
                this.state.push("digs");
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (qName.equals("atoc")) {
                this.state.pop();
            } else if (qName.equals("cset")) {
                this.state.pop();
            } else if (qName.equals("summary")) {
                this.state.pop();
            } else if (qName.equals("af")) {
                this.state.pop();
            } else if (qName.equals("dig")) {
                this.state.pop();
            } else if (qName.equals("digs")) {
                this.state.pop();
            }
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
            this.state.pop();
        }

        @Override
        public void warning(SAXParseException e) {
            this.log(2, e);
        }

        @Override
        public void error(SAXParseException e) {
            this.log(4, e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.log(4, e);
            throw e;
        }

        private void log(int severity, SAXParseException e) {
            String message = this.getMessage(e);
            ComIbmCicCommonCorePlugin.getDefault().getLog().log((IStatus)new Status(severity, ComIbmCicCommonCorePlugin.getPluginId(), severity, message, null));
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        private void logWarning(String msg) {
            if (this.locator != null) {
                String name = this.locator.getSystemId();
                int line = this.locator.getLineNumber();
                int column = this.locator.getColumnNumber();
                if (name == null) {
                    if (line > 0) {
                        msg = column <= 0 ? NLS.bind(Messages.ArtifactTocParser_error_at_line, (Object)line, (Object)msg) : NLS.bind(Messages.ArtifactTocParser_error_at_line_column, line, column, msg);
                    }
                } else if (line > 0) {
                    msg = column <= 0 ? NLS.bind(Messages.ArtifactTocParser_error_at_name_line, name, line, msg) : NLS.bind(Messages.ArtifactTocParser_error_at_name_line_column, name, line, column, msg);
                }
            }
            Status status = new Status(2, ComIbmCicCommonCorePlugin.getPluginId(), 0, msg, null);
            ComIbmCicCommonCorePlugin.log((IStatus)status);
        }

        private String getMessage(SAXParseException e) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.location);
            sb.append(": ");
            String systemId = e.getSystemId();
            if (systemId != null) {
                sb.append(systemId);
                sb.append(':');
            }
            sb.append(e.getLineNumber());
            sb.append(':');
            sb.append(e.getColumnNumber());
            sb.append(": ");
            sb.append(e.getMessage());
            return sb.toString();
        }
    }

    private static class ContainedSetHandler
    extends AbstractContentHandler {
        public ContainedSetHandler(ArtifactTableOfContents.Parameters params, ElementHolder.IHasHREF ref, ArtifactTableOfContents.ContainedSetHolder csHolder, String location) {
            super(params, location);
            this.state.push(new ContainedSetHolderState(ref, csHolder));
        }
    }

    private static class ContainedSetHolderState {
        private final ElementHolder.IHasHREF ref;
        private final ArtifactTableOfContents.ContainedSetHolder holder;

        public ContainedSetHolderState(ElementHolder.IHasHREF ref, ArtifactTableOfContents.ContainedSetHolder holder) {
            this.ref = ref;
            this.holder = holder;
        }

        public ArtifactTableOfContents.ContainedSetHolder getHolder() {
            return this.holder;
        }

        public ElementHolder.IHasHREF getRef() {
            return this.ref;
        }
    }

    private static class TocHandler
    extends AbstractContentHandler {
        public TocHandler(ArtifactTableOfContents.Parameters params, ArtifactTableOfContents.TocHolder tocHolder) {
            super(params, tocHolder.getLocation());
            this.state.push(tocHolder);
        }
    }
}

