/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.impl.ArtifactListParser;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactListVersionInfo;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.utils.CicCommonCorePluginTrace;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.model.adapterdata.impl.ArtifactKeyUtil;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.XMLWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;

public class ArtifactListWriter
implements ArtifactListParser.ArtifactListXMLConstants,
ArtifactListVersionInfo {
    private static final CicCommonCorePluginTrace trace = ComIbmCicCommonCorePlugin.getTrace();
    private static final XMLWriter.ProcessingInstruction alistPI = new XMLWriter.ProcessingInstruction("alist", "version='0.0.1'");
    private static final XMLWriter.ProcessingInstruction[] PI_ELEMENTS = new XMLWriter.ProcessingInstruction[]{alistPI};

    public static Collection getSortedArtifactKeysSet() {
        return ArtifactKeyUtil.getSortedArtifactKeysSet();
    }

    public static void write(File file, Collection artifactKeys) throws IOException {
        trace.entering(file.toString());
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            XMLWriter writer = new XMLWriter((OutputStream)fos, PI_ELEMENTS);
            writer.start("alist");
            for (IArtifactKey key : artifactKeys) {
                ArtifactListWriter.printArtifact(writer, key);
            }
            writer.end("alist");
            writer.flush();
            FileUtil.fdSync(fos.getFD());
            writer.close();
            trace.exiting();
        }
        finally {
            if (fos != null) {
                FileUtil.close(fos);
            }
        }
    }

    private static void printArtifact(XMLWriter writer, IArtifactKey key) {
        writer.start("af");
        writer.attribute("n", key.getNamespace());
        writer.attribute("q", key.getQualifier());
        writer.attribute("id", key.getId().getId());
        writer.attribute("v", key.getVersion().toString());
        IPath path = key.getPath();
        if (!path.isEmpty()) {
            writer.attribute("p", key.getPath().toString());
        }
        writer.end();
    }
}

