/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.IArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IArtifactSessionFactory;
import com.ibm.cic.common.core.artifactrepo.IContentLocator;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.base.ArtifactNewContentInfo;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractContentLocator;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.AddOption;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactFormatterUtil;
import com.ibm.cic.common.core.artifactrepo.impl.ContentInfoUtil;
import com.ibm.cic.common.core.artifactrepo.impl.IArtifactTocUpdate;
import com.ibm.cic.common.core.artifactrepo.impl.IArtifactWrite;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.artifactrepo.impl.RepoAs;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.repository.StatusCodes;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserNames;
import com.ibm.cic.common.downloads.DigestValue;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadedFile;
import com.ibm.cic.common.downloads.SimpleContentInfo;
import java.io.File;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractWriteArtifactRepo
extends AbstractReadArtifactRepo
implements IArtifactWrite {
    public static IArtifact getArtifactForToc(IArtifact artifact, IContentInfo contentInfo) {
        assert (contentInfo != null);
        ArtifactNewContentInfo artifactForToc = new ArtifactNewContentInfo(artifact, contentInfo);
        return artifactForToc;
    }

    private IArtifact getArtifactForTocExistingArtifactLogIssues(IArtifact artifact, IArtifactLocator targetLocator) {
        assert (targetLocator != null);
        IContentInfo targetContentInfo = targetLocator.getContentInfo();
        assert (targetContentInfo != null);
        if (logIWriteArtifact.isDebugLoggable()) {
            MultiStatus ms;
            long atocSize;
            File file = targetLocator.revealFile();
            long fileLen = file.length();
            if (fileLen != (atocSize = targetContentInfo.getSizeInfo().getDownloadSize())) {
                ms = new MultiStatus(ComIbmCicCommonCorePlugin.getPluginId(), 0, NLS.bind((String)"Inconsistent size determined for existing {0} at {1}.", (Object)artifact.toUserString(), (Object)file.toString()), null);
                this.addExistingAtocSizeDetails(ms, artifact, targetLocator, file, fileLen, atocSize);
                logIWriteArtifact.status((IStatus)ms);
            }
            if (atocSize == 0L) {
                ms = new MultiStatus(ComIbmCicCommonCorePlugin.getPluginId(), 0, NLS.bind((String)"Warning artifact with size 0 for existing {0} to {1}.", (Object)artifact.toUserString(), (Object)file.toString()), new Throwable());
                this.addExistingAtocSizeDetails(ms, artifact, targetLocator, file, fileLen, atocSize);
                logIWriteArtifact.status((IStatus)ms);
            }
        }
        return AbstractWriteArtifactRepo.getArtifactForToc(artifact, targetContentInfo);
    }

    private void addExistingAtocSizeDetails(MultiStatus ms, IArtifact artifact, IArtifactLocator targetLocator, File file, long fileLen, long atocSize) {
        ms.add((IStatus)Statuses.WARNING.get("File.length()={1} for ''{0}''", file.toString(), fileLen));
        ms.add((IStatus)Statuses.WARNING.get("Atoc size={0}", atocSize));
        ms.add((IStatus)Statuses.WARNING.get("Source artifact content info: {0}", artifact.getContentInfo()));
        ms.add((IStatus)Statuses.WARNING.get("Atoc content info: {0}", targetLocator.getContentInfo()));
        ms.add((IStatus)Statuses.WARNING.get("Added source artifact class name: {0}", artifact.getClass().getName()));
        ms.add((IStatus)Statuses.WARNING.get("Target repository class name: {0}", this.getRepository().getClass().getName()));
    }

    protected IArtifact getArtifactForTocLogIssues(IArtifact artifact, IContentLocator sourceLocator, IDownloadedFile dlUncached, IPath targetPath, SimpleContentInfo tocContentInfo) {
        IArtifact artifactForToc = AbstractWriteArtifactRepo.getArtifactForToc(artifact, tocContentInfo);
        if (logIWriteArtifact.isDebugLoggable()) {
            MultiStatus ms;
            long atocSize;
            File file = targetPath.toFile();
            long fileLen = file.length();
            if (fileLen != (atocSize = artifactForToc.getContentInfo().getSizeInfo().getDownloadSize())) {
                ms = new MultiStatus(ComIbmCicCommonCorePlugin.getPluginId(), 0, NLS.bind((String)"Inconsistent size determined for atoc entry while adding {0} to {1}.", (Object)sourceLocator.getUserNames().getSystemName(), (Object)targetPath.toString()), null);
                this.addAtocSizeDetails(ms, artifact, sourceLocator, dlUncached, file, fileLen, atocSize);
                logIWriteArtifact.status((IStatus)ms);
            }
            if (atocSize == 0L) {
                ms = new MultiStatus(ComIbmCicCommonCorePlugin.getPluginId(), 0, NLS.bind((String)"Warning artifact with size 0 adding {0} to {1}.", (Object)sourceLocator.getUserNames().getSystemName(), (Object)targetPath.toString()), new Throwable());
                this.addAtocSizeDetails(ms, artifact, sourceLocator, dlUncached, file, fileLen, atocSize);
                logIWriteArtifact.status((IStatus)ms);
            }
        }
        return artifactForToc;
    }

    private void addAtocSizeDetails(MultiStatus ms, IArtifact artifact, IContentLocator sourceLocator, IDownloadedFile dl, File file, long fileLen, long atocSize) {
        ms.add((IStatus)Statuses.WARNING.get("File.length()={1} for ''{0}''", file.toString(), fileLen));
        ms.add((IStatus)Statuses.WARNING.get("Computed atoc size={0}", atocSize));
        ms.add((IStatus)Statuses.WARNING.get("Added source artifact content info: {0}", artifact.getContentInfo()));
        ms.add((IStatus)Statuses.WARNING.get("Downloaded content info: {0}", dl.getDownloadContentInfo()));
        ms.add((IStatus)Statuses.WARNING.get("Added source locator content info: {0}", sourceLocator.getContentInfo()));
        ms.add((IStatus)Statuses.WARNING.get("Added source locator's expected content info: {0}", sourceLocator.getExpectedContentInfo()));
        ms.add((IStatus)Statuses.WARNING.get("Added source locator's validated content info: {0}", sourceLocator.getValidatedContentInfo()));
        ms.add((IStatus)Statuses.WARNING.get("Added source artifact class name: {0}", artifact.getClass().getName()));
        ms.add((IStatus)Statuses.WARNING.get("Added source locator class name: {0}", sourceLocator.getClass().getName()));
        ms.add((IStatus)Statuses.WARNING.get("Target repository class name: {0}", this.getRepository().getClass().getName()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IStatus addArtifactNoTocUpdate(IArtifactSession session, AddOption options, IArtifact artifact, IContentLocator source, boolean validateTargetLocatorExists, IProgressMonitor monitor, IArtifactLocator[] outTargetLocator) {
        if (artifact == null) {
            throw new NullPointerException();
        }
        if (monitor == null) {
            throw new NullPointerException();
        }
        if (source == null) {
            throw new NullPointerException("NPE source=null for artifact " + artifact.toUserString());
        }
        if (outTargetLocator == null) {
            throw new NullPointerException();
        }
        if (outTargetLocator.length != 1) {
            throw new IllegalArgumentException();
        }
        IStatus status = this.getRepository().getStatus(false, monitor);
        if (!status.isOK()) {
            return status;
        }
        if (session == null) {
            try (IArtifactSession singleCallSession = IArtifactSessionFactory.INSTANCE.createArtifactSession();){
                status = this.addArtifactNoTocUpdateChecked(singleCallSession, options, artifact, source, validateTargetLocatorExists, monitor, outTargetLocator);
                if (status.isOK()) return status;
                singleCallSession.log(status);
                return status;
            }
        } else {
            status = this.addArtifactNoTocUpdateChecked(session, options, artifact, source, validateTargetLocatorExists, monitor, outTargetLocator);
            if (status.isOK()) return status;
            session.log(status);
        }
        return status;
    }

    private IStatus getLocator(IArtifactSession session, IArtifact artifact, boolean validateTargetLocatorExists, IProgressMonitor monitor, IArtifactLocator[] result) {
        IStatus statusValidateExists;
        IStatus status = this.getArtifactLocator(session, artifact, monitor, result);
        if (!StatusCodes.isContentNotFound(status) && validateTargetLocatorExists && result[0] != null && StatusCodes.isContentNotFound(statusValidateExists = result[0].validateExists(0, monitor))) {
            return statusValidateExists;
        }
        return status;
    }

    private IStatus addArtifactNoTocUpdateChecked(IArtifactSession session, AddOption options, IArtifact artifact, IContentLocator source, boolean validateTargetLocatorExists, IProgressMonitor monitor, IArtifactLocator[] outTargetLocator) {
        assert (outTargetLocator != null);
        IArtifactLocator[] result = new IArtifactLocator[1];
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, new int[]{1, 10});
        try {
            IStatus statusGetLocator = this.getLocator(session, artifact, validateTargetLocatorExists, pm.next(), result);
            if (!StatusCodes.isContentNotFound(statusGetLocator)) {
                if (statusGetLocator.matches(8)) {
                    IStatus iStatus = statusGetLocator;
                    return iStatus;
                }
                int mismatchSeverity = options.getDigestMismatchSeverity();
                CicMultiStatus ms = this.getAddArtifactNotOverwrittenMultiStatus(artifact, source);
                if (statusGetLocator.getCode() == 26) {
                    if (mismatchSeverity != 0) {
                        ms.add(Statuses.OK.get(statusGetLocator.getCode(), Messages.add_artifact_error_when_checking_for_existing_target, new Object[0]));
                        if (options.getUpdateMode().equals(AddOption.UpdateMode.ADD_LOG_MISMATCH_AS_ERROR)) {
                            ms.add(statusGetLocator);
                            CicMultiStatus cicMultiStatus = ms;
                            return cicMultiStatus;
                        }
                        ms.add(MultiStatusUtil.recodeLevel(statusGetLocator, 4, mismatchSeverity));
                    }
                    options.addMismatchedArtifact(artifact);
                } else if (statusGetLocator.matches(4)) {
                    ms.add(Statuses.OK.get(statusGetLocator.getCode(), Messages.add_artifact_error_when_checking_for_existing_target, new Object[0]));
                    ms.add(statusGetLocator);
                    CicMultiStatus cicMultiStatus = ms;
                    return cicMultiStatus;
                }
                IArtifactLocator target = result[0];
                AbstractContentLocator.LocatorDigestCmp ldcSource = new AbstractContentLocator.LocatorDigestCmp(source);
                AbstractContentLocator.LocatorDigestCmp ldcTarget = new AbstractContentLocator.LocatorDigestCmp(target);
                String msgExpectedVsGivenFailed = Messages.digest_validation_expected_digest_mismatch;
                String msgLocatorVsGivenFailed = Messages.digest_validation_locator_digest_mismatch;
                IStatus cmpStatus = ldcSource.compare(ldcTarget, msgExpectedVsGivenFailed, msgLocatorVsGivenFailed);
                if (cmpStatus.matches(4)) {
                    if (mismatchSeverity != 0) {
                        ICicStatus statusAlreadyExist = Statuses.INFO.get(Messages.add_artifact_exist_target_digest_issue, new Object[0]);
                        ms.add(statusAlreadyExist);
                        if (options.getUpdateMode().equals(AddOption.UpdateMode.ADD_LOG_MISMATCH_AS_ERROR)) {
                            ms.add(cmpStatus);
                            CicMultiStatus cicMultiStatus = ms;
                            return cicMultiStatus;
                        }
                        ms.add(MultiStatusUtil.recodeLevel(cmpStatus, 4, mismatchSeverity));
                    }
                    options.addMismatchedArtifact(artifact);
                }
                if (cmpStatus.matches(3) && mismatchSeverity != 0) {
                    ms.add(cmpStatus);
                }
                if (options.isAddMode()) {
                    IStatus status;
                    try {
                        status = this.verifyTargetLocatorContentInfo(session, target);
                    }
                    catch (CoreException e) {
                        status = e.getStatus();
                    }
                    if (!status.isOK()) {
                        ms.add(status);
                        CicMultiStatus cicMultiStatus = ms;
                        return cicMultiStatus;
                    }
                    IArtifact artifactForToc = this.getArtifactForTocExistingArtifactLogIssues(artifact, target);
                    ((AbstractArtifactLocator)target).setArtifact(artifactForToc);
                    outTargetLocator[0] = target;
                    CicMultiStatus cicMultiStatus = ms;
                    return cicMultiStatus;
                }
                assert (options.isOverwriteMode());
                if (options.getCheckOnly()) {
                    CicMultiStatus cicMultiStatus = ms;
                    return cicMultiStatus;
                }
                boolean hasSameDigests = ContentInfoUtil.validate(true, source.getContentInfo(), target.getContentInfo(), null).getCode() == 27;
                IStatus statusAdd = Status.OK_STATUS;
                if (!hasSameDigests) {
                    statusAdd = this.doAddArtifact(session, artifact, source, pm.next(), outTargetLocator);
                } else {
                    IArtifact artifactForToc = this.getArtifactForTocExistingArtifactLogIssues(artifact, target);
                    ((AbstractArtifactLocator)target).setArtifact(artifactForToc);
                    outTargetLocator[0] = target;
                }
                IStatus iStatus = StatusUtil.newStatusKeepOldChildren(ms, statusAdd);
                return iStatus;
            }
            if (options.getCheckOnly()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            IStatus iStatus = this.doAddArtifact(session, artifact, source, pm.next(), outTargetLocator);
            return iStatus;
        }
        finally {
            pm.done();
        }
    }

    protected String[] getTocPreferredDigests(IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        boolean hasAtoc = this.hasArtifactToc(session, monitor);
        if (!hasAtoc) {
            return null;
        }
        IReadArtifactRepo.IArtifactTocCapabilities tc = this.getArtifactTocCapabilities();
        return new String[]{tc.getPreferredDigestAlgorithm()};
    }

    private IStatus verifyTargetLocatorContentInfo(IArtifactSession session, IArtifactLocator target) throws CoreException {
        IStatus status = Status.OK_STATUS;
        String[] digests = this.getTocPreferredDigests(session, (IProgressMonitor)new NullProgressMonitor());
        if (digests != null) {
            SimpleContentInfo outContentInfo = new SimpleContentInfo();
            status = this.computeOutContentInfoFromTargetLocator(session, target, digests, outContentInfo);
        }
        return status;
    }

    private IStatus computeOutContentInfoFromTargetLocator(IArtifactSession session, IArtifactLocator targetLocator, String[] digests, SimpleContentInfo outContentInfo) {
        if (digests == null) {
            throw new NullPointerException();
        }
        IStatus status = Status.OK_STATUS;
        String[] algorithms = digests;
        if (algorithms.length == 0) {
            return status;
        }
        HashSet<String> digestsToCompute = new HashSet<String>();
        IContentInfo availableContentInfo = targetLocator.getContentInfo();
        String[] stringArray = algorithms;
        int n = algorithms.length;
        int n2 = 0;
        while (n2 < n) {
            String algorithm = stringArray[n2];
            DigestValue digest = availableContentInfo.getDigestValue(algorithm);
            if (digest != null) {
                outContentInfo.setDigestValue(digest);
            } else {
                digestsToCompute.add(algorithm);
            }
            ++n2;
        }
        if (digestsToCompute.size() > 0) {
            return Statuses.ERROR.get(11, Messages.add_artifact_exist_target_has_missing_digests, digestsToCompute);
        }
        if (availableContentInfo.getSizeInfo().getDownloadSize() == Long.MIN_VALUE) {
            return Statuses.ERROR.get(11, Messages.add_artifact_exist_target_missing_size, new Object[0]);
        }
        outContentInfo.setSize(availableContentInfo.getSizeInfo().getDownloadSize());
        return status;
    }

    private IArtifactTocUpdate canUpdateToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        if (!this.hasArtifactToc(session, monitor)) {
            return null;
        }
        return RepoAs.IArtifactTocUpdate(this);
    }

    private IStatus addToToc(IArtifactSession session, IArtifactLocator target, IProgressMonitor monitor) {
        IArtifactTocUpdate tocUpdate;
        try {
            tocUpdate = this.canUpdateToc(session, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        if (tocUpdate == null) {
            return Status.OK_STATUS;
        }
        return tocUpdate.updateArtifactTocAddOrChange(session, new IArtifact[]{target.getArtifact()}, monitor);
    }

    @Override
    public IStatus addArtifact(IArtifactSession session, AddOption options, IArtifact artifact, IContentLocator source, IProgressMonitor monitor, IArtifactLocator[] outTargetLocator) {
        IStatus statusTocUpdate;
        if (artifact == null) {
            throw new NullPointerException();
        }
        if (monitor == null) {
            throw new NullPointerException();
        }
        if (source == null) {
            throw new NullPointerException();
        }
        if (outTargetLocator == null) {
            throw new NullPointerException();
        }
        if (outTargetLocator.length != 1) {
            throw new IllegalArgumentException();
        }
        IStatus status = this.getRepository().getStatus(false, monitor);
        if (!status.isOK()) {
            return status;
        }
        if (session == null) {
            try (IArtifactSession singleCallSession = IArtifactSessionFactory.INSTANCE.createArtifactSession();){
                IStatus iStatus = this.addArtifact(singleCallSession, options, artifact, source, monitor, outTargetLocator);
                return iStatus;
            }
        }
        status = this.addArtifactNoTocUpdate(session, options, artifact, source, false, monitor, outTargetLocator);
        if (status.matches(12)) {
            return status;
        }
        if (!options.getCheckOnly() && outTargetLocator[0] != null && status.getCode() != 14 && !(statusTocUpdate = this.addToToc(session, outTargetLocator[0], monitor)).isOK()) {
            if (statusTocUpdate.matches(4)) {
                return this.createAddArtifactError(artifact, statusTocUpdate);
            }
            log.status(statusTocUpdate);
        }
        return status;
    }

    protected abstract IStatus doAddArtifact(IArtifactSession var1, IArtifact var2, IContentLocator var3, IProgressMonitor var4, IArtifactLocator[] var5);

    @Override
    public IStatus removeArtifactNoTocUpdate(IArtifactSession session, IArtifactLocator locator, IProgressMonitor monitor) {
        if (locator == null) {
            throw new NullPointerException();
        }
        if (monitor == null) {
            throw new NullPointerException();
        }
        if (session == null) {
            try (IArtifactSession singleCallSession = IArtifactSessionFactory.INSTANCE.createArtifactSession();){
                IStatus iStatus = this.removeArtifactNoTocUpdate(singleCallSession, locator, monitor);
                return iStatus;
            }
        }
        IStatus status = this.getRepository().getStatus(false, monitor);
        if (status.isOK()) {
            monitor.beginTask("", 1);
            try {
                monitor.subTask(NLS.bind((String)Messages.task_remove_artifact, (Object)ArtifactFormatterUtil.toUserString(locator.getArtifactKey())));
                status = locator.validateExists(2, monitor);
                if (status.isOK()) {
                    status = this.doRemoveArtifact(session, locator, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                if (!status.isOK()) {
                    session.log(status);
                }
            }
            finally {
                monitor.done();
            }
        }
        return status;
    }

    @Override
    public IStatus removeArtifact(IArtifactSession session, IArtifactLocator locator, IProgressMonitor monitor) {
        if (locator == null) {
            throw new NullPointerException();
        }
        if (monitor == null) {
            throw new NullPointerException();
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (session == null) {
            try (IArtifactSession singleCallSession = IArtifactSessionFactory.INSTANCE.createArtifactSession();){
                IStatus iStatus = this.removeArtifact(singleCallSession, locator, monitor);
                return iStatus;
            }
        }
        IStatus status = this.getRepository().getStatus(false, monitor);
        if (status.isOK()) {
            IArtifactTocUpdate tocUpdate;
            status = this.removeArtifactNoTocUpdate(session, locator, monitor);
            if (status.matches(12)) {
                return status;
            }
            try {
                tocUpdate = this.canUpdateToc(session, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
            }
            catch (CoreException e) {
                return this.createRemoveArtifactError(locator.getArtifactKey(), e.getStatus(), null);
            }
            if (tocUpdate == null) {
                return status;
            }
            IStatus statusTocUpdate = tocUpdate.updateArtifactTocRemove(session, new IArtifact[]{locator.getArtifact()}, monitor);
            if (statusTocUpdate.matches(8)) {
                return statusTocUpdate;
            }
            if (!statusTocUpdate.isOK()) {
                if (statusTocUpdate.matches(4)) {
                    return this.createRemoveArtifactError(locator.getArtifactKey(), statusTocUpdate, null);
                }
                log.status(statusTocUpdate);
            }
        }
        return status;
    }

    protected abstract IStatus doRemoveArtifact(IArtifactSession var1, IArtifactLocator var2, IProgressMonitor var3);

    protected IStatus createAddArtifactError(IArtifact artifact, Exception e) {
        return Statuses.ERROR.get(11, e, Messages.add_artifact_failed_to_repo, artifact.toUserString(), this.getRepository().getUserNames().getPureSystemName());
    }

    protected IStatus createAddArtifactError(IArtifact artifact, IStatus child) {
        return this.createAddArtifactError(artifact, new IStatus[]{child});
    }

    protected IStatus createAddArtifactError(IArtifact artifact, IStatus[] children) {
        return Statuses.ERROR.getMultiStatus(11, children, Messages.add_artifact_failed_to_repo, artifact.toUserString(), this.getRepository().getUserNames().getPureSystemName());
    }

    private CicMultiStatus getAddArtifactNotOverwrittenMultiStatus(IArtifact artifact, IContentLocator sourceLocator) {
        UserNames locNames = new UserNames(artifact.toUserString(), sourceLocator.getUserNames().getPureSystemName());
        String logicalName = locNames.getLogicalName();
        String pureSystemName = this.getRepository().getUserNames().getPureSystemName();
        if (locNames.hasDistinctLogicalName() && locNames.hasDistinctSystemName()) {
            return Statuses.ST.createMultiStatus(14, Messages.add_artifact_to_repo_with_location, logicalName, locNames.getSystemName(), pureSystemName);
        }
        return Statuses.ST.createMultiStatus(14, Messages.add_artifact_to_repo, logicalName, pureSystemName);
    }

    protected IStatus createRemoveArtifactError(IArtifactKey key, IStatus childStatus, Exception e) {
        String userString = ArtifactFormatterUtil.toUserString(key);
        if (childStatus == null) {
            return Statuses.ERROR.get(12, e, Messages.remove_artifact_failed, userString);
        }
        return Statuses.ST.createMultiStatus(12, new IStatus[]{childStatus}, Messages.remove_artifact_failed, userString);
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IArtifactWrite.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }
}

