/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IArtifactSessionFactory;
import com.ibm.cic.common.core.artifactrepo.base.IDownload;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.downloads.DownloadContextThreadLocalInheritedAndGlobal;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.downloads.IDownloadedFile;
import com.ibm.cic.common.downloads.IHasIsCanceled;
import com.ibm.cic.common.downloads.ITransferMonitor;
import com.ibm.cic.common.downloads.TransferMonitor;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

abstract class AbstractDownload
implements IDownload {
    public ICicStatus createErrorDownloadToFile(File destination, Exception e) {
        ICicStatus status = Statuses.ERROR.get(101, e, Messages.AbstractDownload_errorDownloadToFile, this.getUserNames().getSystemName(), destination.getAbsolutePath());
        return status;
    }

    public CicMultiStatus createMultiStatusDownloadToFile(int severity, int code, File destination) {
        String msg = NLS.bind((String)Messages.AbstractDownload_downloadToFile, (Object)this.getUserNames().getSystemName(), (Object)destination.getAbsolutePath());
        CicMultiStatus status = Statuses.ST.createMultiStatus(code, msg, new Object[0]);
        return status;
    }

    @Override
    public IDownloadedFile downloadToFile(IDownloadSession session, IPath destination, IProgressMonitor monitor) {
        IDownloadedFile result;
        if (monitor == null) {
            throw new NullPointerException();
        }
        if (session == null) {
            try (IArtifactSession singleCallSession = IArtifactSessionFactory.INSTANCE.createArtifactSession();){
                result = this.downloadToFile(singleCallSession, destination, monitor);
            }
        }
        DownloadContextThreadLocalInheritedAndGlobal.CancelMonitorRestorePrevious cmrp = DownloadContextThreadLocalInheritedAndGlobal.setupDownloadHandlerCancel(monitor);
        IHasIsCanceled cancelMonitor = cmrp.getCancelMonitor();
        try {
            result = this.doDownloadToFile(session, destination, new TransferMonitor(cancelMonitor), monitor);
        }
        finally {
            cmrp.restore();
        }
        return result;
    }

    protected abstract IDownloadedFile doDownloadToFile(IDownloadSession var1, IPath var2, ITransferMonitor var3, IProgressMonitor var4);
}

