/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.IArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.IContentLocator;
import com.ibm.cic.common.core.artifactrepo.NotValidatedPolicy;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractDownload;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactToPathUtil;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactValidationUtil;
import com.ibm.cic.common.core.artifactrepo.impl.ContentInfoComputation;
import com.ibm.cic.common.core.artifactrepo.impl.ContentInfoUtil;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.downloads.DownloadedIncompleteUsingDip;
import com.ibm.cic.common.core.internal.downloads.ResumeableDownload;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.repository.StatusCodes;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.IStatusCodes;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.core.utils.UserName;
import com.ibm.cic.common.core.utils.UserNames;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.downloads.ContentInfo;
import com.ibm.cic.common.downloads.DigestUtil;
import com.ibm.cic.common.downloads.DigestValue;
import com.ibm.cic.common.downloads.DownloadHandlerDefaultRetryLevel;
import com.ibm.cic.common.downloads.DownloadInProgressManager;
import com.ibm.cic.common.downloads.DownloadRetryLevel;
import com.ibm.cic.common.downloads.DownloadedFile;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadIncomplete;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.downloads.IDownloaded;
import com.ibm.cic.common.downloads.IDownloadedFile;
import com.ibm.cic.common.downloads.IMutableContentInfo;
import com.ibm.cic.common.downloads.ITransferMonitor;
import com.ibm.cic.common.downloads.ResumableDownloadProgress;
import com.ibm.cic.common.downloads.ResumableProgressEvents;
import com.ibm.cic.common.downloads.SimpleContentInfo;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractContentLocator
extends AbstractDownload
implements IContentLocator {
    private static TestDownloadFileHook.TestCallback testCallbackHook;
    private IContentInfo locatorContentInfo;
    private SimpleContentInfo validatedContentInfo = null;
    private final IContentInfo expectedContentInfo;

    public AbstractContentLocator(IContentInfo locatorContentInfo) {
        this(locatorContentInfo, ContentInfo.EMPTY_CONTENT_INFO);
    }

    public AbstractContentLocator(IContentInfo locatorContentInfo, IContentInfo expectedContentInfo) {
        this.locatorContentInfo = new SimpleContentInfo(locatorContentInfo != null ? locatorContentInfo : ContentInfo.EMPTY_CONTENT_INFO);
        this.expectedContentInfo = new SimpleContentInfo(expectedContentInfo != null ? expectedContentInfo : ContentInfo.EMPTY_CONTENT_INFO);
    }

    @Override
    public IContentInfo getExpectedContentInfo() {
        return this.expectedContentInfo;
    }

    @Override
    public IContentInfo getContentInfo() {
        return this.locatorContentInfo;
    }

    @Override
    public void setContentInfo(IContentInfo ci) {
        this.locatorContentInfo = new SimpleContentInfo(ci != null ? ci : ContentInfo.EMPTY_CONTENT_INFO);
    }

    @Override
    public IContentInfo getValidatedContentInfo() {
        return this.getValidatedContentInfoInternal();
    }

    private SimpleContentInfo getValidatedContentInfoInternal() {
        if (this.validatedContentInfo == null) {
            this.validatedContentInfo = new SimpleContentInfo();
        }
        return this.validatedContentInfo;
    }

    public static ICicStatus makeDoesNotExistStatus(int severity, UserNames context, IContentLocator locator, Exception e) {
        if (context == null) {
            return AbstractContentLocator.makeDoesNotExistStatus(severity, locator, e);
        }
        UserNames locNames = locator.getUserNames();
        if (locNames.hasDistinctLogicalName() && locNames.hasDistinctSystemName()) {
            return Statuses.ST.createStatus(severity, 1, e, Messages.locator_does_not_exists_in_with_location, locNames.getLogicalName(), locNames.getSystemName(), context.getPureSystemName());
        }
        return Statuses.ST.createStatus(severity, 1, e, Messages.locator_does_not_exists_in, locNames.getLogicalName(), context.getPureSystemName());
    }

    public static ICicStatus makeDoesNotExistStatus(int severity, IContentLocator locator, Exception e) {
        UserNames locNames = locator.getUserNames();
        String logicalName = locNames.getLogicalName();
        if (locNames.hasDistinctLogicalName() && locNames.hasDistinctSystemName()) {
            return Statuses.ST.createStatus(severity, 1, e, Messages.locator_does_not_exists_with_location, logicalName, locNames.getSystemName());
        }
        return Statuses.ST.createStatus(severity, 1, e, Messages.locator_does_not_exists, logicalName);
    }

    @Override
    public IStatus validate(NotValidatedPolicy nvp) {
        if (UserOptions.getIgnoreUnexpectedDigest()) {
            return Status.OK_STATUS;
        }
        SimpleContentInfo sci = this.getValidatedContentInfoInternal();
        IStatus status = ContentInfoUtil.validate(nvp == NotValidatedPolicy.NVP_SILENT, this.getExpectedContentInfo(), this.getContentInfo(), sci);
        if (!status.isOK()) {
            CicMultiStatus ms = Statuses.ST.createMultiStatus(status.getCode(), Messages.pre_download_validation_failed, this.getUserNames().getLogicalName());
            ms.merge(status);
            return ms;
        }
        return status;
    }

    private static IContentInfo computeUnionValidExpected(IContentLocator locator) {
        IContentInfo validated = locator.getValidatedContentInfo();
        if (validated.getAvailableDigestsCount() > 0) {
            return ContentInfoUtil.union(locator.getExpectedContentInfo(), locator.getContentInfo());
        }
        return locator.getExpectedContentInfo();
    }

    public static ReferenceContentInfo getReferenceContentInfo(IContentLocator locator) {
        IContentInfo expectedReference;
        IStatus successCode;
        IContentInfo expandedValidExpected = UserOptions.getIgnoreUnexpectedDigest() ? ContentInfo.EMPTY_CONTENT_INFO : AbstractContentLocator.computeUnionValidExpected(locator);
        if (expandedValidExpected.getAvailableDigestsCount() > 0) {
            successCode = IStatusCodes.STATUS_OK_VALIDATION_EXPECTED_VS_DOWNLOADED;
            expectedReference = expandedValidExpected;
        } else {
            successCode = IStatusCodes.STATUS_OK_VALIDATION_LOCATOR_VS_DOWNLOADED;
            expectedReference = locator.getContentInfo();
        }
        return new ReferenceContentInfo(expectedReference, successCode);
    }

    private IStatus validateDownloaded(IDownloadSession session, NotValidatedPolicy nvp, IDownloaded dl, ResumableDownloadProgress.IVerificationProgress progress) {
        TestDownloadFileHook.TestCallback testCallback = AbstractContentLocator.getTestCallback();
        if (testCallback != null) {
            return testCallback.validateDownloaded(DoValidateDownloaded.INSTANCE, session, this, nvp, dl, progress);
        }
        return DoValidateDownloaded.INSTANCE.validateDownloaded(session, this, nvp, dl, progress);
    }

    private IStatus doValidateDownloaded(IDownloadSession session, NotValidatedPolicy nvp, IDownloaded dl, ResumableDownloadProgress.IVerificationProgress progress) {
        ICicStatus statusDownload = dl.getStatus();
        if (!statusDownload.isOK()) {
            session.log(statusDownload);
        }
        if (statusDownload.matches(12)) {
            return statusDownload;
        }
        ReferenceContentInfo refContentInfo = AbstractContentLocator.getReferenceContentInfo(this);
        IStatus statusVsDownloadedComputed = ArtifactValidationUtil.validateDownloadedBytes(session, nvp, refContentInfo.getContentInfo(), dl, progress, null);
        return refContentInfo.getReportStatus(statusVsDownloadedComputed, Messages.download_validation_failed_expected_vs_downloaded, Messages.download_validation_failed_locator_vs_downloaded);
    }

    @Override
    protected IDownloadedFile doDownloadToFile(IDownloadSession session, IPath destination, ITransferMonitor transferPerformance, IProgressMonitor monitor) {
        ICicStatus statusDestination = FileUtil.checkDestination(destination.toFile());
        if (!statusDestination.isOK()) {
            return new DownloadedFile(statusDestination, null, null);
        }
        ResumeableDownload.IBytesRetriever retriever = null;
        try {
            retriever = this.getBytesRetriever(session, destination, transferPerformance);
        }
        catch (CoreException e) {
            return new DownloadedFile(StatusUtil.convertToCicStatus(e.getStatus()), null, null);
        }
        ResumeableDownload.ProgressFormatListener listener = null;
        if (session.getProgressFormatter() != null) {
            String locatorUserText = session.getProgressFormatter().format(this);
            listener = new ResumeableDownload.ProgressFormatListener(monitor, locatorUserText);
            ResumableProgressEvents.INSTANCE.addListener(listener);
        }
        ResumeableDownload.Progress progress = new ResumeableDownload.Progress(transferPerformance, retriever.willVerify());
        try {
            IDownloadedFile dlFile;
            IDownloadedFile iDownloadedFile = dlFile = ResumeableDownload.doRetrieveFile(retriever, progress);
            return iDownloadedFile;
        }
        finally {
            progress.endResumeableDownload();
            if (listener != null) {
                ResumableProgressEvents.INSTANCE.removeListener(listener);
            }
        }
    }

    private static File createTempFile(String simpleName) throws IOException, CoreException {
        return TempUtil.createTempFile("cic", simpleName);
    }

    public static File createTempFile(IArtifactKey key) throws IOException, CoreException {
        IPath path = ArtifactToPathUtil.getUniquePath(key);
        return AbstractContentLocator.createTempFile(path.lastSegment());
    }

    public static File createTempFile(IContentLocator locator) throws IOException, CoreException {
        if (locator instanceof IArtifactLocator) {
            IArtifactLocator al = (IArtifactLocator)locator;
            return AbstractContentLocator.createTempFile(al.getArtifactKey());
        }
        String systemName = locator.getUserNames().getSystemName();
        return AbstractContentLocator.createTempFile(systemName);
    }

    @Override
    public ICicStatus createErrorDownloadToFile(File destination, Exception e) {
        ICicStatus subStatus = super.createErrorDownloadToFile(destination, e);
        String msg = NLS.bind((String)Messages.AbstractContentLocator_downloadLocator, (Object)this.getUserNames().getLogicalName());
        if (msg.equals(subStatus.getMessage())) {
            return subStatus;
        }
        CicMultiStatus status = Statuses.ERROR.getMultiStatus(subStatus.getCode(), (IStatus[])new ICicStatus[]{subStatus}, Messages.AbstractContentLocator_downloadLocator, this.getUserNames().getLogicalName());
        return status;
    }

    @Override
    public CicMultiStatus createMultiStatusDownloadToFile(int severity, int code, File destination) {
        String msg = NLS.bind((String)Messages.AbstractContentLocator_downloadLocator, (Object)this.getUserNames().getLogicalName());
        CicMultiStatus status = Statuses.ST.createMultiStatus(code, msg, new Object[0]);
        ICicStatus child = Statuses.ST.createStatus(severity, code, null, super.createMultiStatusDownloadToFile(severity, code, destination).getMessage(), new Object[0]);
        status.add(child);
        return status;
    }

    private ResumeableDownload.IRetrievalHelper createRetrievalHelper(IDownloadSession session, IPath destination, ITransferMonitor transferPerformance) {
        return new ContentLocatorRetrievelHelper(this, session, destination, transferPerformance);
    }

    protected DownloadRetryLevel retryLevel(Exception exception) {
        return DownloadHandlerDefaultRetryLevel.retryLevel(exception);
    }

    protected abstract DownloadInProgressManager.NonValidatedDownload createNonValidatedDownloadRequest(TempUtil.UniqueTempDir var1, IPath var2) throws CoreException;

    private ResumeableDownload.IBytesRetriever getBytesRetriever(IDownloadSession session, IPath destination, ITransferMonitor transferPerformance) throws CoreException {
        TempUtil.UniqueTempDir dipRoot = session.getDownloadInProgressDir();
        if (dipRoot == null) {
            dipRoot = DownloadInProgressManager.createUniqueDownloadInProgressRoot(null, 2);
            session.setDownloadInProgressDir(dipRoot);
        } else {
            dipRoot.ensureCreated();
        }
        DownloadInProgressManager.ValidatedDownload dr = this.createValidatedDownloadRequest(session, destination);
        if (dr != null && session.getValidationPolicy().isValidationRequired()) {
            return new ResumeableDownload.ResumeableBytesRetriever(this.createRetrievalHelper(session, destination, transferPerformance), dr);
        }
        DownloadInProgressManager.NonValidatedDownload nrd = this.createNonValidatedDownloadRequest(session.getDownloadInProgressDir(), destination);
        return new ResumeableDownload.NonResumeableBytesRetriever(this.createRetrievalHelper(session, destination, transferPerformance), nrd);
    }

    public IPath getValidatedInProgressPath(IDownloadSession session, IPath destination) {
        DigestValue dv = DigestUtil.getDigestValueToUse(AbstractContentLocator.computeUnionValidExpected(this));
        if (dv == null) {
            dv = DigestUtil.getDigestValueToUse(this.getContentInfo());
        }
        if (dv == null) {
            return null;
        }
        String resumeableDownloadId = this.getResumeableDownloadId(destination);
        TempUtil.UniqueTempDir dipRoot = session.getDownloadInProgressDir();
        IPath inProgressPath = DownloadInProgressManager.getValidatedInProgressPath(dipRoot.getUniqueTempDir(), dv, resumeableDownloadId);
        return inProgressPath;
    }

    private DownloadInProgressManager.ValidatedDownload createValidatedDownloadRequest(IDownloadSession session, IPath destination) {
        DownloadInProgressManager dipm = DownloadInProgressManager.INSTANCE;
        DigestValue dv = DigestUtil.getDigestValueToUse(AbstractContentLocator.computeUnionValidExpected(this));
        if (dv == null) {
            dv = DigestUtil.getDigestValueToUse(this.getContentInfo());
        }
        if (dv == null) {
            return null;
        }
        String resumeableDownloadId = this.getResumeableDownloadId(destination);
        TempUtil.UniqueTempDir dipRoot = session.getDownloadInProgressDir();
        IPath inProgressPath = DownloadInProgressManager.getValidatedInProgressPath(dipRoot.getUniqueTempDir(), dv, resumeableDownloadId);
        return dipm.getValidatedDownload(this, dipRoot, dv, resumeableDownloadId, inProgressPath, destination);
    }

    protected String calcHashNameResumeableId(String resumeableName, String defaultId) {
        byte[] destBytes = Encodings.UTF8.toBytes(resumeableName);
        try {
            DigestValue destDv = ContentInfoComputation.computePreferredDigest(destBytes);
            return String.valueOf(destDv.getAlgorithm()) + "~" + destDv.getDigestAsString();
        }
        catch (NoSuchAlgorithmException e) {
            IDownloadSession.log.status(Statuses.WARNING.get(e, "Could not compute digest of resumeableName {0}. Using {1} as resumeableDownloadId. Download may clash with other concurrent downloads with same resumeableDownloadId and same content", resumeableName, defaultId));
            return defaultId;
        }
    }

    protected String getResumeableDownloadId(IPath destination) {
        String defaultId = destination.lastSegment();
        if (defaultId == null) {
            defaultId = "";
        }
        String resumeableDownloadId = this.calcHashNameResumeableId(destination.toPortableString(), defaultId);
        return resumeableDownloadId;
    }

    private IDownloadedFile doDownloadToFileWithValidationNoResumeRetry(IDownloadSession session, IPath destination, ITransferMonitor transferPerformance, ResumableDownloadProgress.IResumableDownloadProgress progress, long[] outReadBytes) {
        IDownloadedFile df = this.doDownloadToFileNoValidationNoResumeRetry(session, destination, transferPerformance, progress, outReadBytes);
        if (df.getStatus().matches(8)) {
            return df;
        }
        if (StatusCodes.isContentNotFound(df.getStatus())) {
            return df;
        }
        if (!session.getValidationPolicy().isValidationRequired()) {
            if (!df.getStatus().isOK()) {
                session.log(df.getStatus());
            }
            return df;
        }
        if (df.getStatus().matches(4)) {
            if (!df.getStatus().isOK()) {
                session.log(df.getStatus());
            }
            return df;
        }
        IStatus statusValidateDownload = this.validateDownloaded(session, session.getValidationPolicy().getNotValidatedPolicy(), df, progress);
        CicMultiStatus ms = this.createMultiStatusDownloadToFile(statusValidateDownload.getSeverity(), statusValidateDownload.getCode(), destination.toFile());
        for (IStatus child : MultiStatusUtil.getStatusNodes(statusValidateDownload)) {
            ms.merge(child);
        }
        return new DownloadedFileWrapper(df, ms);
    }

    protected abstract IDownloadedFile doDownloadToFileNoValidationNoResumeRetry(IDownloadSession var1, IPath var2, ITransferMonitor var3, ResumableDownloadProgress.IResumableDownloadProgress var4, long[] var5);

    public static IStatus computeOutContentInfo(IStatus status, IDownloadSession session, final IArtifact artifact, IContentLocator sourceLocator, IDownloaded dl, IProgressMonitor monitor, String[] digests, SimpleContentInfo outContentInfo) {
        if (digests == null) {
            outContentInfo.setSize(dl.getDownloadContentInfo().getSizeInfo().getDownloadSize());
            return status;
        }
        String[] algorithms = digests;
        if (algorithms.length == 0) {
            return status;
        }
        HashSet<String> digestsToCompute = new HashSet<String>();
        IContentInfo availableContentInfo = ContentInfoUtil.union(sourceLocator.getValidatedContentInfo(), dl.getDownloadContentInfo());
        String[] stringArray = algorithms;
        int n = algorithms.length;
        int n2 = 0;
        while (n2 < n) {
            String algorithm = stringArray[n2];
            DigestValue digest = availableContentInfo.getDigestValue(algorithm);
            if (digest != null) {
                outContentInfo.setDigestValue(digest);
            } else {
                digestsToCompute.add(algorithm);
            }
            ++n2;
        }
        if (digestsToCompute.size() > 0) {
            if (!status.isOK()) {
                session.log(status);
            }
            if ((status = ContentInfoComputation.computeDigests(session, new UserName(){

                @Override
                public String toString() {
                    return artifact.toUserString();
                }
            }, dl, digestsToCompute, monitor, outContentInfo)).matches(12)) {
                return status;
            }
        } else {
            outContentInfo.setSize(dl.getDownloadContentInfo().getSizeInfo().getDownloadSize());
        }
        return status;
    }

    public static TestDownloadFileHook.TestCallback getTestCallback() {
        return testCallbackHook;
    }

    public static void setTestCallback(TestDownloadFileHook.TestCallback testCallback) {
        testCallbackHook = testCallback;
    }

    private static IDownloadedFile doDownloadToFileWithValidationNoResumeRetry(IDownloadSession session, AbstractContentLocator locator, IPath destination, ITransferMonitor transferPerformance, ResumableDownloadProgress.IResumableDownloadProgress progress, long[] outReadBytes) {
        TestDownloadFileHook.TestCallback testCallback = AbstractContentLocator.getTestCallback();
        if (testCallback != null) {
            return testCallback.downloadNoResumeRetry(DoDownloadToFile.INSTANCE, session, locator, destination, transferPerformance, progress, outReadBytes);
        }
        return DoDownloadToFile.INSTANCE.downloadNoResumeRetry(session, locator, destination, transferPerformance, progress, outReadBytes);
    }

    private static class ContentLocatorRetrievelHelper
    implements ResumeableDownload.IRetrievalHelper {
        final AbstractContentLocator locator;
        final IDownloadSession session;
        final IPath destination;
        final ITransferMonitor transferPerformance;

        ContentLocatorRetrievelHelper(AbstractContentLocator locator, IDownloadSession session, IPath destination, ITransferMonitor transferPerformance) {
            this.locator = locator;
            this.session = session;
            this.destination = destination;
            this.transferPerformance = transferPerformance;
        }

        @Override
        public Object getSource() {
            return this.locator.getUserNames().getSystemName();
        }

        @Override
        public CicMultiStatus createValidationFailedMultiStatus() {
            ICicStatus status = this.locator.createErrorDownloadToFile(this.destination.toFile(), null);
            CicMultiStatus multiStatus = Statuses.ST.createMultiStatus(26, status.getMessage(), new Object[0]);
            return multiStatus;
        }

        @Override
        public boolean isNotFound(IStatus status) {
            return StatusCodes.isContentNotFound(status);
        }

        @Override
        public boolean isValidationFailed(IStatus status) {
            return MultiStatusUtil.hasStatus(status, 4, ComIbmCicCommonCorePlugin.getPluginId(), 26);
        }

        @Override
        public DownloadRetryLevel retryLevel(Exception exception) {
            return this.locator.retryLevel(exception);
        }

        @Override
        public ITransferMonitor getTransferPerformance() {
            return this.transferPerformance;
        }

        @Override
        public IDownloadedFile retrieve(DownloadInProgressManager.IDownloadInProgress dip, ResumableDownloadProgress.IResumableDownloadProgress progress, long[] bytesRetrieved) {
            if (progress.isCanceled()) {
                return new DownloadedFile(ICicStatus.CANCEL_STATUS, new DownloadedIncompleteUsingDip(dip, Collections.EMPTY_LIST));
            }
            IDownloadedFile dlFile = AbstractContentLocator.doDownloadToFileWithValidationNoResumeRetry(this.session, this.locator, dip.getInProgressLocation(), this.transferPerformance, progress, bytesRetrieved);
            return dlFile;
        }
    }

    private static class DoDownloadToFile
    implements TestDownloadFileHook.IDoDownload {
        static final DoDownloadToFile INSTANCE = new DoDownloadToFile();

        private DoDownloadToFile() {
        }

        @Override
        public IDownloadedFile downloadNoResumeRetry(IDownloadSession session, AbstractContentLocator locator, IPath destination, ITransferMonitor transferPerformance, ResumableDownloadProgress.IResumableDownloadProgress progress, long[] outReadBytes) {
            return locator.doDownloadToFileWithValidationNoResumeRetry(session, destination, transferPerformance, progress, outReadBytes);
        }
    }

    private static class DoValidateDownloaded
    implements TestDownloadFileHook.IDoValidateDownloaded {
        static final DoValidateDownloaded INSTANCE = new DoValidateDownloaded();

        private DoValidateDownloaded() {
        }

        @Override
        public IStatus validateDownloaded(IDownloadSession session, AbstractContentLocator locator, NotValidatedPolicy nvp, IDownloaded dl, ResumableDownloadProgress.IVerificationProgress progress) {
            return locator.doValidateDownloaded(session, nvp, dl, progress);
        }
    }

    public static class DownloadedFileWrapper
    implements IDownloadedFile {
        private final IDownloadedFile df;
        private final ICicStatus status;

        public DownloadedFileWrapper(IDownloadedFile df, ICicStatus status) {
            this.df = df;
            this.status = status;
        }

        @Override
        public File getFile() {
            return this.df.getFile();
        }

        @Override
        public ICicStatus getStatus() {
            return this.status;
        }

        @Override
        public IContentInfo getDownloadContentInfo() {
            return this.df.getDownloadContentInfo();
        }

        @Override
        public IMutableContentInfo getMutableDownloadContentInfo() {
            return this.df.getMutableDownloadContentInfo();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Wrapper with new status=");
            sb.append(this.status.toString());
            sb.append("[");
            sb.append(this.df.toString());
            sb.append("]");
            return sb.toString();
        }

        @Override
        public IDownloadIncomplete getIncompleteDownload() {
            return this.df.getIncompleteDownload();
        }
    }

    static class LocatorDigestCmp {
        private final IContentLocator locator;
        private final ReferenceContentInfo rciExpected;
        private final ReferenceContentInfo rciLocator;

        LocatorDigestCmp(IContentLocator locator) {
            this.locator = locator;
            IContentInfo expandedValidExpected = AbstractContentLocator.computeUnionValidExpected(locator);
            this.rciExpected = expandedValidExpected.getAvailableDigestsCount() > 0 ? new ReferenceContentInfo(expandedValidExpected, IStatusCodes.STATUS_OK_VALIDATION_EXPECTED_VS_DOWNLOADED) : null;
            this.rciLocator = new ReferenceContentInfo(locator.getContentInfo(), IStatusCodes.STATUS_OK_VALIDATION_EXPECTED_VS_DOWNLOADED);
        }

        IStatus compare(LocatorDigestCmp rhs, String msgExpectedVsGivenFailed, String msgLocatorVsGivenFailed) {
            if (rhs.rciExpected != null && this.rciExpected != null) {
                IStatus cmpStatus = ContentInfoUtil.validate(true, this.rciExpected.getContentInfo(), rhs.rciExpected.getContentInfo(), null);
                return this.rciExpected.getReportStatus(cmpStatus, msgExpectedVsGivenFailed, msgLocatorVsGivenFailed);
            }
            IStatus cmpStatus = ContentInfoUtil.validate(true, this.rciLocator.getContentInfo(), rhs.rciLocator.getContentInfo(), null);
            return this.rciLocator.getReportStatus(cmpStatus, msgExpectedVsGivenFailed, msgLocatorVsGivenFailed);
        }

        public String toString() {
            return "LocatorDigestCmp: " + this.locator.toString();
        }
    }

    public static class ReferenceContentInfo {
        private final IContentInfo contentInfo;
        private final IStatus successStatus;

        ReferenceContentInfo(IContentInfo contentInfo, IStatus successStatus) {
            this.contentInfo = contentInfo;
            this.successStatus = successStatus;
        }

        public IContentInfo getContentInfo() {
            return this.contentInfo;
        }

        IStatus getReportStatus(IStatus comparisonStatus, String msgExpectedVsGivenFailed, String msgLocatorVsGivenFailed) {
            if (StatusCodes.isEqualByCodeSeverityPlugin(comparisonStatus, IStatusCodes.STATUS_OK_VALIDATION_DIGESTS_VALIDATED)) {
                return this.successStatus;
            }
            if (comparisonStatus instanceof ContentInfoUtil.DigestMismatchStatus) {
                CicMultiStatus ms = StatusCodes.isEqualByCodeSeverityPlugin(this.successStatus, IStatusCodes.STATUS_OK_VALIDATION_EXPECTED_VS_DOWNLOADED) ? Statuses.ST.createMultiStatus(comparisonStatus.getCode(), msgExpectedVsGivenFailed, new Object[0]) : Statuses.ST.createMultiStatus(comparisonStatus.getCode(), msgLocatorVsGivenFailed, new Object[0]);
                ms.merge(comparisonStatus);
                return ms;
            }
            return comparisonStatus;
        }
    }

    public static interface TestCallFilter {
        public boolean isTestCall(StackTraceElement[] var1);
    }

    public static class TestDownloadFileHook {

        public static interface IDoDownload {
            public IDownloadedFile downloadNoResumeRetry(IDownloadSession var1, AbstractContentLocator var2, IPath var3, ITransferMonitor var4, ResumableDownloadProgress.IResumableDownloadProgress var5, long[] var6);
        }

        public static interface IDoValidateDownloaded {
            public IStatus validateDownloaded(IDownloadSession var1, AbstractContentLocator var2, NotValidatedPolicy var3, IDownloaded var4, ResumableDownloadProgress.IVerificationProgress var5);
        }

        public static class TestCallback {
            protected TestCallback prevCallback;
            private final TestCallFilter testCallFilter;

            public TestCallback(TestCallback prevCallback, TestCallFilter testCallFilter) {
                this.prevCallback = prevCallback;
                this.testCallFilter = testCallFilter;
            }

            protected boolean isTestCall() {
                if (this.testCallFilter == null) {
                    return true;
                }
                StackTraceElement[] stack = new Throwable().getStackTrace();
                return this.testCallFilter.isTestCall(stack);
            }

            public IDownloadedFile downloadNoResumeRetry(IDoDownload original, IDownloadSession session, AbstractContentLocator locator, IPath destination, ITransferMonitor transferPerformance, ResumableDownloadProgress.IResumableDownloadProgress progress, long[] outReadBytes) {
                if (this.prevCallback != null) {
                    return this.prevCallback.downloadNoResumeRetry(original, session, locator, destination, transferPerformance, progress, outReadBytes);
                }
                return original.downloadNoResumeRetry(session, locator, destination, transferPerformance, progress, outReadBytes);
            }

            public IStatus validateDownloaded(IDoValidateDownloaded original, IDownloadSession session, AbstractContentLocator locator, NotValidatedPolicy nvp, IDownloaded dl, ResumableDownloadProgress.IVerificationProgress progress) {
                if (this.prevCallback != null) {
                    return this.prevCallback.validateDownloaded(original, session, locator, nvp, dl, progress);
                }
                return original.validateDownloaded(session, locator, nvp, dl, progress);
            }
        }
    }
}

