/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.base;

import com.ibm.cic.common.core.artifactrepo.ArtifactProgressFormatter;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IArtifactSessionSettings;
import com.ibm.cic.common.core.artifactrepo.base.AddArtifacts;
import com.ibm.cic.common.core.artifactrepo.base.AddMultiThreadArtifacts;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperation;
import com.ibm.cic.common.core.artifactrepo.base.IMultiArtifactOperationArguments;
import com.ibm.cic.common.core.artifactrepo.base.MultiArtifactOperationOptions;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.internal.downloads.LastRates;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.downloads.FormatUtil;
import com.ibm.cic.common.downloads.ResumableProgressEvents;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class AddArtifactsProgress
extends MultiArtifactOperationOptions.ProcessRecordListener {
    private IProgressMonitor monitor;
    private static final int TICK_LIMIT = 100000;
    private ScaledUnits ticksRemaining;
    private static final long UPDATE_FREQUENCY_MS = 1000L;
    private long startTime;
    private long lastUpdateTime;
    private final TotalAndRemaining totalAndRemaining;
    private final Map mapThreadRates = Collections.synchronizedMap(new HashMap(10));
    private final Map mapThreadToOngoingDownload = Collections.synchronizedMap(new HashMap(10));
    private boolean justStarted;
    private ResumableProgressEvents.AbstractProgressListener listener;
    private DiskInfo diskInfo;

    public static long getTotalSize(IMultiArtifactOperationArguments multiArgs) {
        long bytes = 0L;
        for (IArtifactOperation.IArtifactOperationRecord element : multiArgs.getRecords()) {
            IArtifactOperation.IArtifactOperationRecord dlRecord = element;
            long size = AddArtifacts.getAddInputArtifactDownloadSize(dlRecord);
            if (size == Long.MIN_VALUE) continue;
            bytes += size;
        }
        return bytes;
    }

    private static long getArtifactSize(IArtifactOperation.IArtifactOperationRecord dlRecord) {
        AddArtifacts.AddInput input = AddArtifacts.getAddInput(dlRecord);
        if (input == null) {
            return Long.MIN_VALUE;
        }
        if (input.getArtifact() == null) {
            return Long.MIN_VALUE;
        }
        return input.getArtifact().getContentInfo().getSizeInfo().getDownloadSize();
    }

    private static long getLocatorSize(IArtifactOperation.IArtifactOperationRecord dlRecord) {
        AddArtifacts.AddInput input = AddArtifacts.getAddInput(dlRecord);
        if (input == null) {
            return Long.MIN_VALUE;
        }
        if (input.getLocator() == null) {
            return Long.MIN_VALUE;
        }
        return input.getLocator().getContentInfo().getSizeInfo().getDownloadSize();
    }

    public AddArtifactsProgress() {
        this.totalAndRemaining = new TotalAndRemaining();
    }

    public synchronized void begin(MultiArtifactOperationOptions options, IProgressMonitor theMonitor) {
        this.monitor = theMonitor;
        this.ticksRemaining = new ScaledUnits();
        long totalUnits = this.totalAndRemaining.getTotalSize();
        this.ticksRemaining.addUnits(100000L, totalUnits);
        assert (100000L == this.ticksRemaining.getTotalUnits());
        theMonitor.beginTask("", (int)this.ticksRemaining.getTotalUnits());
        this.startListening(options);
    }

    public synchronized void done(MultiArtifactOperationOptions options) {
        this.doneListening(options);
        this.monitor.done();
    }

    private void worked(IArtifactOperation.IArtifactOperationRecord record, OngoingDownload tdata) {
        if (tdata.remainUnits != null) {
            long size = tdata.remainUnits.getTotalUnits();
            long ticks = this.ticksRemaining.useInternalUnits(size);
            assert (ticks <= 100000L);
            this.monitor.worked((int)ticks);
        }
    }

    public void addRepositoryToTotals(IRepository repo, IMultiArtifactOperationArguments multiArgs) {
        this.totalAndRemaining.addRecords(multiArgs);
    }

    @Override
    public synchronized void onBeforeUseDisk(IRepository repo, IVolumeAccessByDisk.IDisk disk, IVolumeAccessByDisk.IDiskSetDisks allUsedDisks, IMultiArtifactOperationArguments diskArgs) {
        if (disk != null) {
            this.diskInfo = new DiskInfo(disk, diskArgs);
        }
    }

    @Override
    public synchronized void onUsedDisk(IRepository repo, IVolumeAccessByDisk.IDisk disk, IVolumeAccessByDisk.IDiskSetDisks allUsedDisks, IMultiArtifactOperationArguments diskArgs) {
        this.diskInfo = null;
    }

    @Override
    public void onBeforeRecord(MultiArtifactOperationOptions options, IArtifactOperation.IArtifactOperationRecord record) {
        long size = AddArtifacts.getAddInputArtifactDownloadSize(record);
        if (size != Long.MIN_VALUE) {
            this.beforeProcessRecord(record);
        }
    }

    @Override
    public void onProcessedRecord(MultiArtifactOperationOptions options, IMultiArtifactOperationArguments multiArgs, IArtifactOperation.IArtifactOperationRecord record, boolean processed) {
        if (processed) {
            IStatus dlStatus = record.getLastStatus();
            if (dlStatus.getSeverity() == 8) {
                this.doneProcessRecord(record, false);
                return;
            }
            boolean isError = dlStatus.matches(4);
            if (isError) {
                this.doneProcessRecord(record, false);
                return;
            }
            this.doneProcessRecord(record, true);
        }
    }

    public synchronized void startListening(MultiArtifactOperationOptions options) {
        this.startTime = System.currentTimeMillis();
        this.lastUpdateTime = this.startTime - 1000L;
        this.justStarted = true;
        this.listener = new ResumableProgressEvents.AbstractProgressListener(){

            @Override
            public void beginTransfer(long bytesToTransfer) {
                OngoingDownload tdata = (OngoingDownload)AddArtifactsProgress.this.mapThreadToOngoingDownload.get(Thread.currentThread());
                if (tdata == null) {
                    AddMultiThreadArtifacts.log.debug("download thread data should not be null");
                }
            }

            @Override
            public void endTransfer() {
                OngoingDownload tdata = (OngoingDownload)AddArtifactsProgress.this.mapThreadToOngoingDownload.get(Thread.currentThread());
                if (tdata == null) {
                    AddMultiThreadArtifacts.log.debug("download thread data should not be null");
                }
            }

            @Override
            public void updateTransfer(int percentDone, long bytesTransferred, long bytesToTransfer, long bytesPerSecondTotal, long bytesPerLastSecond) {
                OngoingDownload tdata = (OngoingDownload)AddArtifactsProgress.this.mapThreadToOngoingDownload.get(Thread.currentThread());
                if (tdata == null) {
                    AddMultiThreadArtifacts.log.debug("download thread data should not be null");
                    return;
                }
                tdata.transferedBytes = bytesTransferred;
                if (tdata.transferedBytes > 0L && bytesPerLastSecond != -1L) {
                    tdata.lastRates.add(bytesPerLastSecond);
                }
                AddArtifactsProgress.this.updateMonitor(false);
            }

            @Override
            public void beginVerification() {
                AddArtifactsProgress.this.updateMonitor(false);
            }

            @Override
            public void updateVerificationProgress(int percent) {
                OngoingDownload tdata = (OngoingDownload)AddArtifactsProgress.this.mapThreadToOngoingDownload.get(Thread.currentThread());
                if (tdata == null) {
                    AddMultiThreadArtifacts.log.debug("download thread data should not be null");
                    return;
                }
                tdata.verifiedPercent = percent;
                AddArtifactsProgress.this.updateMonitor(false);
            }
        };
        ResumableProgressEvents.INSTANCE.addListener(this.listener);
        options.addListener(this);
    }

    public synchronized void doneListening(MultiArtifactOperationOptions options) {
        options.removeListener(this);
        ResumableProgressEvents.INSTANCE.removeListener(this.listener);
        this.monitor.done();
    }

    public synchronized void beforeProcessRecord(IArtifactOperation.IArtifactOperationRecord record) {
        long size = AddArtifactsProgress.getLocatorSize(record);
        if (size != Long.MIN_VALUE) {
            LastRates threadRates = (LastRates)this.mapThreadRates.get(Thread.currentThread());
            if (threadRates == null) {
                threadRates = new LastRates(15);
                this.mapThreadRates.put(Thread.currentThread(), threadRates);
            }
            OngoingDownload tdata = new OngoingDownload(record, threadRates);
            this.mapThreadToOngoingDownload.put(Thread.currentThread(), tdata);
            this.updateMonitor(false);
        }
    }

    public synchronized void doneProcessRecord(IArtifactOperation.IArtifactOperationRecord record, boolean successful) {
        OngoingDownload tdata = (OngoingDownload)this.mapThreadToOngoingDownload.remove(Thread.currentThread());
        if (tdata == null) {
            AddMultiThreadArtifacts.log.debug("thread data should not be null");
            return;
        }
        this.mapThreadRates.put(Thread.currentThread(), tdata.lastRates);
        long size = AddArtifactsProgress.getArtifactSize(record);
        if (successful && size != Long.MIN_VALUE) {
            TotalAndRemaining tar;
            this.totalAndRemaining.decrRemainingSize(size);
            if (this.diskInfo != null && (tar = this.diskInfo.getTotalAndRemaining()) != null) {
                tar.decrRemainingSize(size);
            }
            this.worked(record, tdata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressInfo calcProgressInfo(RemainingSizeEstimates[] estimates) {
        ProgressInfo info = new ProgressInfo(estimates);
        Map map = this.mapThreadToOngoingDownload;
        synchronized (map) {
            for (Map.Entry entry : this.mapThreadToOngoingDownload.entrySet()) {
                OngoingDownload tdata = (OngoingDownload)entry.getValue();
                RemainingSizeEstimates[] remainingSizeEstimatesArray = info.remaining;
                int n = info.remaining.length;
                int n2 = 0;
                while (n2 < n) {
                    RemainingSizeEstimates remain = remainingSizeEstimatesArray[n2];
                    if (tdata.remainUnits != null) {
                        long size = tdata.remainUnits.useInternalUnits(tdata.transferedBytes);
                        remain.currentSize -= size;
                    }
                    ++n2;
                }
                info.ongoingVerifiedPercent += (long)tdata.verifiedPercent;
                LastRates rates = tdata.lastRates;
                long bps = rates.avgMaxData();
                if (bps == -1L) continue;
                if (info.ongoingBps == -1L) {
                    info.ongoingBps = bps;
                    continue;
                }
                info.ongoingBps += bps;
            }
        }
        return info;
    }

    public synchronized void updateMonitor(boolean force) {
        RemainingSizeEstimates[] confirmedRemaining = this.diskInfo != null ? new RemainingSizeEstimates[]{new RemainingSizeEstimates(this.diskInfo.totalAndRemaining), new RemainingSizeEstimates(this.totalAndRemaining)} : new RemainingSizeEstimates[]{new RemainingSizeEstimates(this.totalAndRemaining)};
        ProgressInfo info = this.calcProgressInfo(confirmedRemaining);
        RemainingSizeEstimates re = info.remaining[0];
        boolean bl = this.justStarted = this.justStarted && System.currentTimeMillis() - this.startTime <= 10000L;
        if (this.justStarted && 100.0 * (double)re.currentSize / (double)(re.totalSize + 1L) >= 10.0) {
            this.justStarted = false;
        }
        boolean showRates = !this.justStarted && info.ongoingBps != -1L;
        long currentTime = System.currentTimeMillis();
        if (re.currentSize == 0L) {
            if (info.ongoingVerifiedPercent > 0L) {
                this.monitor.subTask(Messages.AddArtifactsProgress_verifying);
            } else {
                this.monitor.subTask("");
            }
            this.lastUpdateTime = currentTime;
            return;
        }
        if (!force && currentTime - this.lastUpdateTime < 1000L) {
            return;
        }
        this.lastUpdateTime = currentTime;
        long totalSize = re.totalSize;
        long doneSizeEstimate = re.totalSize - re.currentSize;
        if (doneSizeEstimate < 0L) {
            doneSizeEstimate = 0L;
        }
        String doneSizeFormatted = FormatUtil.formatBytesHuman(doneSizeEstimate);
        double percentDoneExact = doneSizeEstimate * 100L / totalSize + 1L;
        long percentDone = (long)Math.ceil(percentDoneExact);
        if (percentDone >= 100L) {
            percentDone = 99L;
        }
        String msg = "";
        msg = this.diskInfo == null ? (!showRates ? NLS.bind(Messages.AddArtifactsProgress_fetching, doneSizeFormatted, FormatUtil.formatBytesHuman(totalSize), percentDone) : NLS.bind(Messages.AddArtifactsProgress_fetchingWithRate, doneSizeFormatted, FormatUtil.formatBytesHuman(totalSize), percentDone, FormatUtil.formatBytesPerSecond(info.ongoingBps))) : (!showRates ? NLS.bind(Messages.AddArtifactsProgress_fetchingFromDisk, doneSizeFormatted, FormatUtil.formatBytesHuman(totalSize), percentDone, this.diskInfo.getDiskNum()) : NLS.bind(Messages.AddArtifactsProgress_fetchingFromDiskWithRate, doneSizeFormatted, FormatUtil.formatBytesHuman(totalSize), percentDone, this.diskInfo.getDiskNum(), FormatUtil.formatBytesPerSecond(info.ongoingBps)));
        this.monitor.subTask(msg);
    }

    public static class AddArtifactsProgressHelper {
        private final IArtifactSession session;
        private final ArtifactProgressFormatter.IArtifactProgressMonitorFormatter prevFormatter;

        public AddArtifactsProgressHelper(IArtifactSession session) {
            this.session = session;
            IArtifactSessionSettings settings = session.getSettings();
            this.prevFormatter = settings.getProgressFormatter();
            settings.setProgressFormatter(null);
        }

        public void restorePrevious() {
            this.session.getSettings().setProgressFormatter(this.prevFormatter);
        }
    }

    private static class DiskInfo {
        private final IVolumeAccessByDisk.IDisk disk;
        private final TotalAndRemaining totalAndRemaining;

        public DiskInfo(IVolumeAccessByDisk.IDisk disk, IMultiArtifactOperationArguments diskArgs) {
            this.disk = disk;
            this.totalAndRemaining = new TotalAndRemaining();
            this.totalAndRemaining.addRecords(diskArgs);
        }

        public int getDiskNum() {
            return this.disk.getDiskNumber();
        }

        public TotalAndRemaining getTotalAndRemaining() {
            return this.totalAndRemaining;
        }
    }

    private static class OngoingDownload {
        public ScaledUnits remainUnits = null;
        public LastRates lastRates;
        public long transferedBytes;
        public int verifiedPercent;

        public OngoingDownload(IArtifactOperation.IArtifactOperationRecord record, LastRates threadRates) {
            long artifactSize = AddArtifactsProgress.getArtifactSize(record);
            long locatorSize = AddArtifactsProgress.getLocatorSize(record);
            if (artifactSize != Long.MIN_VALUE && locatorSize != Long.MIN_VALUE) {
                this.remainUnits = new ScaledUnits();
                this.remainUnits.addUnits(artifactSize, locatorSize);
            }
            this.lastRates = threadRates;
            this.transferedBytes = 0L;
            this.verifiedPercent = 0;
        }
    }

    private static class ProgressInfo {
        public long ongoingBps = -1L;
        public long ongoingVerifiedPercent = 0L;
        public RemainingSizeEstimates[] remaining;

        public ProgressInfo(RemainingSizeEstimates[] estimates) {
            this.remaining = estimates;
        }
    }

    private static class RemainingSizeEstimates {
        public long totalSize;
        public long confirmedSize;
        public long currentSize;

        public RemainingSizeEstimates(TotalAndRemaining tar) {
            this.totalSize = tar.getTotalSize();
            this.currentSize = this.confirmedSize = tar.getRemainingSize();
        }
    }

    static class ScaledUnits {
        private long totalExternalUnits;
        private long totalInternalUnits;
        private double scale;
        private double notYetAccounted;
        private long remainingInternal;

        public ScaledUnits() {
            this.totalExternalUnits = 0L;
            this.totalInternalUnits = 0L;
            this.scale = 0.0;
            this.notYetAccounted = 0.0;
            this.remainingInternal = 0L;
        }

        public ScaledUnits(ScaledUnits rhs) {
            this.totalExternalUnits = rhs.totalExternalUnits;
            this.totalInternalUnits = rhs.totalInternalUnits;
            this.scale = rhs.scale;
            this.notYetAccounted = rhs.notYetAccounted;
            this.remainingInternal = rhs.remainingInternal;
        }

        public long getTotalUnits() {
            return this.totalExternalUnits;
        }

        public long getRemainingUnits() {
            return (long)Math.floor((double)this.remainingInternal * this.scale);
        }

        public void addUnits(long externalUnits, long internalUnits) {
            assert (externalUnits != Long.MIN_VALUE);
            assert (internalUnits != Long.MIN_VALUE);
            this.totalExternalUnits += externalUnits;
            this.totalInternalUnits += internalUnits;
            this.remainingInternal += internalUnits;
            this.scale = this.totalInternalUnits == 0L ? 0.0 : (double)this.totalExternalUnits / (double)this.totalInternalUnits;
        }

        public long useInternalUnits(long internalUnits) {
            double externalUnits = internalUnits > 0L ? this.scale * (double)internalUnits : 0.0;
            double floorExternalUnits = Math.floor(externalUnits += this.notYetAccounted);
            long wholeExternalUnits = (int)floorExternalUnits;
            this.notYetAccounted = externalUnits - (double)wholeExternalUnits;
            this.remainingInternal -= internalUnits;
            return wholeExternalUnits;
        }
    }

    private static class TotalAndRemaining {
        private long totalSize = 0L;
        private long remainingSize = 0L;

        public void addRecords(IMultiArtifactOperationArguments multiArgs) {
            long artifactTotal = 0L;
            for (IArtifactOperation.IArtifactOperationRecord element : multiArgs.getRecords()) {
                IArtifactOperation.IArtifactOperationRecord dlRecord = element;
                long artifactSize = AddArtifactsProgress.getArtifactSize(dlRecord);
                if (artifactSize == Long.MIN_VALUE) continue;
                artifactTotal += artifactSize;
            }
            this.remainingSize += artifactTotal;
            this.totalSize += artifactTotal;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public long getRemainingSize() {
            return this.remainingSize;
        }

        public void decrRemainingSize(long size) {
            this.remainingSize -= size;
        }
    }
}

