/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo;

import com.ibm.cic.common.core.artifactrepo.FileContentLocator;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractContentLocator;
import com.ibm.cic.common.core.internal.downloads.DownloadedIncompleteUsingFile;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.PathUtil;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.core.utils.UserNames;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.downloads.DownloadInProgressManager;
import com.ibm.cic.common.downloads.DownloadedFile;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.downloads.IDownloadedFile;
import com.ibm.cic.common.downloads.ITransferMonitor;
import com.ibm.cic.common.downloads.ResumableDownloadProgress;
import com.ibm.cic.common.downloads.SimpleContentInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class StreamContentLocator
extends AbstractContentLocator {
    private final String userName;
    private final InputStream is;

    public StreamContentLocator(String userName, InputStream is, IContentInfo locatorContentInfo, IContentInfo expectedContentInfo) {
        super(locatorContentInfo, expectedContentInfo);
        this.userName = userName;
        this.is = is;
    }

    public StreamContentLocator(String userName, InputStream is, IContentInfo locatorContentInfo) {
        super(locatorContentInfo);
        this.userName = userName;
        this.is = is;
    }

    @Override
    public IStatus validateExists(int severity, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    @Override
    protected DownloadInProgressManager.NonValidatedDownload createNonValidatedDownloadRequest(TempUtil.UniqueTempDir dipRoot, IPath destination) throws CoreException {
        String simpleName = PathUtil.getSimpleName(this.userName);
        return FileContentLocator.createNonValidatedDownloadRequest(this, dipRoot, simpleName, destination);
    }

    public static IDownloadedFile downloadToFileNoValidationNoResumeRetry(AbstractContentLocator locator, IDownloadSession session, InputStream is, IPath destination, ITransferMonitor transferPerformance, ResumableDownloadProgress.IResumableDownloadProgress progress, long[] outReadBytes) {
        ICicStatus status;
        File copiedFile = destination.toFile();
        outReadBytes[0] = 0L;
        if (transferPerformance.isCanceled()) {
            return new DownloadedFile(ICicStatus.CANCEL_STATUS, null, null);
        }
        SimpleContentInfo ci = null;
        DownloadedIncompleteUsingFile downloadIncomplete = null;
        try {
            long streamLength = locator.getContentInfo().getSizeInfo().getDownloadSize();
            if (streamLength == Long.MIN_VALUE) {
                streamLength = -1L;
            }
            outReadBytes[0] = FileUtil.copyStream(streamLength, is, copiedFile, UserOptions.getDownloadSyncOnClose(), transferPerformance);
            downloadIncomplete = new DownloadedIncompleteUsingFile(copiedFile);
            if (!progress.isCanceled()) {
                SimpleContentInfo sci = new SimpleContentInfo();
                sci.setSize(outReadBytes[0]);
                ci = sci;
                status = ICicStatus.OK_STATUS;
            } else {
                status = ICicStatus.CANCEL_STATUS;
            }
        }
        catch (IOException e) {
            status = locator.createErrorDownloadToFile(copiedFile, e);
            downloadIncomplete = new DownloadedIncompleteUsingFile(copiedFile);
            copiedFile = null;
        }
        return new DownloadedFile(status, copiedFile, ci, downloadIncomplete);
    }

    @Override
    protected IDownloadedFile doDownloadToFileNoValidationNoResumeRetry(IDownloadSession session, IPath destination, ITransferMonitor transferPerformance, ResumableDownloadProgress.IResumableDownloadProgress progress, long[] outReadBytes) {
        return StreamContentLocator.downloadToFileNoValidationNoResumeRetry(this, session, this.is, destination, transferPerformance, progress, outReadBytes);
    }

    @Override
    public UserNames getUserNames() {
        return new UserNames(null, this.userName);
    }

    public String toString() {
        return this.userName;
    }
}

