/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;

final class RSAPrivateCrtKey
extends PrivateKeyInfo
implements java.security.interfaces.RSAPrivateCrtKey,
Serializable {
    static final long serialVersionUID = 4979297236007557055L;
    private BigInteger version = BigInteger.ZERO;
    private BigInteger modulus;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger primeP;
    private BigInteger primeQ;
    private BigInteger primeExponentP;
    private BigInteger primeExponentQ;
    private BigInteger crtCoefficient;
    private static final String[] z;

    public RSAPrivateCrtKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        byte[] byArray = bigInteger.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger.toByteArray();
        byte[] byArray2 = bigInteger2.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger2.toByteArray();
        byte[] byArray3 = bigInteger3.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger3.toByteArray();
        byte[] byArray4 = bigInteger4.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger4.toByteArray();
        byte[] byArray5 = bigInteger5.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger5.toByteArray();
        byte[] byArray6 = bigInteger6.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger6.toByteArray();
        byte[] byArray7 = bigInteger7.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger7.toByteArray();
        byte[] byArray8 = bigInteger8.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger8.toByteArray();
        byte[][] byArrayArray = new byte[][]{byArray, byArray2, byArray3, byArray4, byArray5, byArray6, byArray7, byArray8};
        try {
            RSAPrivateCrtKey.a(byArrayArray);
        }
        catch (Exception exception) {
            throw new InvalidKeyException(z[0] + exception.getMessage());
        }
        this.modulus = new BigInteger(byArrayArray[0]);
        this.privateExponent = new BigInteger(byArrayArray[1]);
        this.publicExponent = new BigInteger(byArrayArray[2]);
        this.primeP = new BigInteger(byArrayArray[3]);
        this.primeQ = new BigInteger(byArrayArray[4]);
        this.primeExponentP = new BigInteger(byArrayArray[5]);
        this.primeExponentQ = new BigInteger(byArrayArray[6]);
        this.crtCoefficient = new BigInteger(byArrayArray[7]);
        RSAKeyFactory.a(this.modulus.bitLength(), this.publicExponent);
        try {
            DerValue[] derValueArray = new DerValue[]{new DerValue(2, this.version.toByteArray()), new DerValue(2, this.modulus.toByteArray()), new DerValue(2, this.publicExponent.toByteArray()), new DerValue(2, this.privateExponent.toByteArray()), new DerValue(2, this.primeP.toByteArray()), new DerValue(2, this.primeQ.toByteArray()), new DerValue(2, this.primeExponentP.toByteArray()), new DerValue(2, this.primeExponentQ.toByteArray()), new DerValue(2, this.crtCoefficient.toByteArray())};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence(derValueArray);
            this.key = derOutputStream.toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[1] + iOException.getMessage());
        }
    }

    public RSAPrivateCrtKey(byte[] byArray) throws InvalidKeyException {
        try {
            this.decode(byArray);
            RSAKeyFactory.a(this.modulus.bitLength(), this.publicExponent);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.getMessage());
        }
    }

    @Override
    public BigInteger getModulus() {
        return this.modulus;
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    @Override
    public BigInteger getPrimeP() {
        return this.primeP;
    }

    @Override
    public BigInteger getPrimeQ() {
        return this.primeQ;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        return this.primeExponentP;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        return this.primeExponentQ;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        return this.crtCoefficient;
    }

    protected void parseKeyBits() throws IOException {
        try {
            DerValue derValue = new DerValue(this.key);
            this.version = derValue.getData().getInteger();
            this.modulus = derValue.getData().getInteger();
            this.publicExponent = derValue.getData().getInteger();
            this.privateExponent = derValue.getData().getInteger();
            this.primeP = derValue.getData().getInteger();
            this.primeQ = derValue.getData().getInteger();
            this.primeExponentP = derValue.getData().getInteger();
            this.primeExponentQ = derValue.getData().getInteger();
            this.crtCoefficient = derValue.getData().getInteger();
            if (derValue.getData().available() != 0) {
                throw new IOException(z[3]);
            }
        }
        catch (Exception exception) {
            throw new IOException(z[2] + exception.getMessage());
        }
    }

    private static void a(byte[][] byArray) {
        int n2;
        BigInteger[] bigIntegerArray = new BigInteger[8];
        for (n2 = 0; n2 < 8; ++n2) {
            if (byArray[n2] == null) continue;
            bigIntegerArray[n2] = new BigInteger(1, byArray[n2]);
        }
        if (bigIntegerArray[3].compareTo(bigIntegerArray[4]) < 0) {
            BigInteger bigInteger = bigIntegerArray[3];
            bigIntegerArray[3] = bigIntegerArray[4];
            bigIntegerArray[4] = bigInteger;
            bigInteger = bigIntegerArray[5];
            bigIntegerArray[5] = bigIntegerArray[6];
            bigIntegerArray[6] = bigInteger;
            bigIntegerArray[7] = null;
        }
        if (bigIntegerArray[7] == null) {
            bigIntegerArray[7] = bigIntegerArray[4].modInverse(bigIntegerArray[3]);
        }
        if (bigIntegerArray[0] == null) {
            bigIntegerArray[0] = bigIntegerArray[3].multiply(bigIntegerArray[4]);
        }
        if (bigIntegerArray[1] == null) {
            bigIntegerArray[1] = bigIntegerArray[2].modInverse(bigIntegerArray[3].subtract(BigInteger.ONE).multiply(bigIntegerArray[4].subtract(BigInteger.ONE)));
        }
        if (bigIntegerArray[5] == null) {
            bigIntegerArray[5] = bigIntegerArray[1].mod(bigIntegerArray[3].subtract(BigInteger.ONE));
        }
        if (bigIntegerArray[6] == null) {
            bigIntegerArray[6] = bigIntegerArray[1].mod(bigIntegerArray[4].subtract(BigInteger.ONE));
        }
        for (n2 = 0; n2 < 8; ++n2) {
            byArray[n2] = bigIntegerArray[n2].toByteArray();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "&'\u001dq7E&\u0007is\u0016-\u001c=\u00016\tHv6\u001crH";
        int n3 = -1;
        block11: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                block14: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block14;
                    n5 = n5;
                    if (n5 <= n4) break block15;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 101;
                            break;
                        }
                        case 1: {
                            n6 = 72;
                            break;
                        }
                        case 2: {
                            n6 = 104;
                            break;
                        }
                        case 3: {
                            n6 = 29;
                            break;
                        }
                        default: {
                            n6 = 83;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0006'\u001dq7E&\u0007is!\r:=6\u000b+\u0007y6_h";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = ",&\u001e|?\f,Hv6\u001ch\u001e|?\u0010-H\u0017";
                    n3 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = ",&\u001e|?\f,HO\u0000$\u0018\u001at%\u0004<\r^!\u0011\u0003\rds\u0000&\u000br7\f&\u000f1s\u0001)\u001c|s\n>\ro!\u0010&";
                    n3 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

