/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSAPrivateCrtKey;
import com.ibm.crypto.provider.RSAPrivateKey;
import com.ibm.crypto.provider.RSAPublicKey;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.action.GetPropertyAction;

public final class RSAKeyFactory
extends KeyFactorySpi {
    public static final int MIN_MODLEN = 512;
    public static final int MAX_MODLEN = 16384;
    public static final int MAX_MODLEN_RESTRICT_EXP = 3072;
    public static final int MAX_RESTRICTED_EXPLEN = 64;
    private static final boolean a;
    private static final RSAKeyFactory b;
    private static final String[] z;

    public static RSAKey toRSAKey(Key key) throws InvalidKeyException {
        java.security.interfaces.RSAPrivateCrtKey rSAPrivateCrtKey;
        if (key instanceof RSAPrivateCrtKey && (rSAPrivateCrtKey = (java.security.interfaces.RSAPrivateCrtKey)key).getCrtCoefficient() == null) {
            return new RSAPrivateKey(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent());
        }
        if (key instanceof RSAPrivateKey || key instanceof RSAPrivateCrtKey || key instanceof RSAPublicKey) {
            return (RSAKey)((Object)key);
        }
        return (RSAKey)((Object)b.engineTranslateKey(key));
    }

    public static void checkKeyLengths(int n2, BigInteger bigInteger, int n3, int n4) throws InvalidKeyException {
        if (n3 > 0 && n2 < n3) {
            throw new InvalidKeyException(z[10] + n3 + z[9]);
        }
        int n5 = Math.min(n4, 16384);
        if (n2 > n5) {
            throw new InvalidKeyException(z[11] + n5 + z[12]);
        }
        if (a && bigInteger != null && n2 > 3072 && bigInteger.bitLength() > 64) {
            throw new InvalidKeyException(z[13]);
        }
    }

    static void a(int n2, BigInteger bigInteger) throws InvalidKeyException {
        RSAKeyFactory.checkKeyLengths(n2 + 7 & 0xFFFFFFF8, bigInteger, 512, Integer.MAX_VALUE);
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof RSAPublicKeySpec) {
                RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
                return new RSAPublicKey(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new RSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException(z[1]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(z[0] + invalidKeyException.getMessage());
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                try {
                    return new RSAPrivateCrtKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                }
                catch (InvalidKeyException invalidKeyException) {
                    return new RSAPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                }
            }
            if (keySpec instanceof RSAPrivateCrtKeySpec) {
                RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec;
                return new RSAPrivateCrtKey(rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPrivateExponent(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrimeP(), rSAPrivateCrtKeySpec.getPrimeQ(), rSAPrivateCrtKeySpec.getPrimeExponentP(), rSAPrivateCrtKeySpec.getPrimeExponentQ(), rSAPrivateCrtKeySpec.getCrtCoefficient());
            }
            if (keySpec instanceof RSAPrivateKeySpec) {
                RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)keySpec;
                return new RSAPrivateKey(rSAPrivateKeySpec.getModulus(), rSAPrivateKeySpec.getPrivateExponent());
            }
            throw new InvalidKeySpecException(z[1]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(z[0] + invalidKeyException.getMessage());
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        try {
            if (key instanceof java.security.interfaces.RSAPublicKey) {
                Class<?> clazz2 = Class.forName(z[8]);
                Class<?> clazz3 = Class.forName(z[7]);
                if (clazz2.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)key;
                    return new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
                }
                if (clazz3.isAssignableFrom(clazz)) {
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(z[1]);
            }
            if (key instanceof java.security.interfaces.RSAPrivateCrtKey) {
                Class<?> clazz4 = Class.forName(z[3]);
                Class<?> clazz5 = Class.forName(z[2]);
                if (clazz4.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPrivateCrtKey rSAPrivateCrtKey = (java.security.interfaces.RSAPrivateCrtKey)key;
                    return new RSAPrivateCrtKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
                }
                if (clazz5.isAssignableFrom(clazz)) {
                    return new PKCS8EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(z[1]);
            }
            if (key instanceof java.security.interfaces.RSAPrivateKey) {
                Class<?> clazz6 = Class.forName(z[4]);
                Class<?> clazz7 = Class.forName(z[2]);
                if (clazz6.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPrivateKey rSAPrivateKey = (java.security.interfaces.RSAPrivateKey)key;
                    return new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
                }
                if (clazz7.isAssignableFrom(clazz)) {
                    return new PKCS8EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(z[1]);
            }
            throw new InvalidKeySpecException(z[6]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException(z[5] + classNotFoundException.getMessage());
        }
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (key instanceof java.security.interfaces.RSAPublicKey) {
                if (key instanceof RSAPublicKey) {
                    return key;
                }
                RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)this.engineGetKeySpec(key, RSAPublicKeySpec.class);
                return this.engineGeneratePublic(rSAPublicKeySpec);
            }
            if (key instanceof java.security.interfaces.RSAPrivateCrtKey) {
                if (key instanceof RSAPrivateCrtKey) {
                    return key;
                }
                RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)this.engineGetKeySpec(key, RSAPrivateCrtKeySpec.class);
                return this.engineGeneratePrivate(rSAPrivateKeySpec);
            }
            if (key instanceof java.security.interfaces.RSAPrivateKey) {
                if (key instanceof RSAPrivateKey) {
                    return key;
                }
                RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)this.engineGetKeySpec(key, RSAPrivateKeySpec.class);
                return this.engineGeneratePrivate(rSAPrivateKeySpec);
            }
            throw new InvalidKeyException(z[14]);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException(z[15] + invalidKeySpecException.getMessage());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[18];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\\jg\u0006\u0016gkv\u0004\u000ftpcV\rp}&\u0005\u0016pgo\u0010\u000fver\u001f\t{>&";
        int n3 = -1;
        block25: while (true) {
            char[] cArray;
            block29: {
                int n4;
                int n5;
                block28: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block28;
                    n5 = n5;
                    if (n5 <= n4) break block29;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 21;
                            break;
                        }
                        case 1: {
                            n6 = 4;
                            break;
                        }
                        case 2: {
                            n6 = 6;
                            break;
                        }
                        case 3: {
                            n6 = 118;
                            break;
                        }
                        default: {
                            n6 = 102;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\\jg\u0006\u0016gkv\u0004\u000ftpcV\rp}&\u0005\u0016pgo\u0010\u000fver\u001f\t{";
                    n3 = 0;
                    continue block25;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u007fep\u0017Hfae\u0003\u0014|p\u007fX\u0015eaeX6^GUN#{gi\u0012\u0003qOc\u000f5eae";
                    n3 = 1;
                    continue block25;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u007fep\u0017Hfae\u0003\u0014|p\u007fX\u0015eaeX4FEV\u0004\u000fcer\u0013%gpM\u0013\u001fFtc\u0015";
                    n3 = 2;
                    continue block25;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u007fep\u0017Hfae\u0003\u0014|p\u007fX\u0015eaeX4FEV\u0004\u000fcer\u0013-p}U\u0006\u0003v";
                    n3 = 3;
                    continue block25;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "@ju\u0003\u0016ekt\u0002\u0003q$m\u0013\u001f5wv\u0013\u0005|bo\u0015\u0007ami\u0018\\5";
                    n3 = 4;
                    continue block25;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\\jg\u0006\u0016gkv\u0004\u000ftpcV\rp}&\u0002\u001fea";
                    n3 = 5;
                    continue block25;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u007fep\u0017Hfae\u0003\u0014|p\u007fX\u0015eaeX> 4?3\bvkb\u0013\u0002^a\u007f%\u0016pg";
                    n3 = 6;
                    continue block25;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u007fep\u0017Hfae\u0003\u0014|p\u007fX\u0015eaeX4FEV\u0003\u0004yme=\u0003lWv\u0013\u0005";
                    n3 = 7;
                    continue block25;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "5fo\u0002\u00155hi\u0018\u0001";
                    n3 = 8;
                    continue block25;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "GWGV\rp}uV\u000b`wrV\u0004p$g\u0002Fyag\u0005\u00125";
                    n3 = 9;
                    continue block25;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "GWGV\rp}uV\u000b`wrV\u0004p$h\u0019Fykh\u0011\u0003g$r\u001e\u0007{$";
                    n3 = 10;
                    continue block25;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "5fo\u0002\u0015";
                    n3 = 11;
                    continue block25;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "GWGV\u0003mti\u0018\u0003{puV\u0005tj&\u0014\u00035jiV\nzja\u0013\u00145pn\u0017\b522V\u0004|puVF|b&\u001b\tqqj\u0003\u00155muV\u0001gag\u0002\u0003g$r\u001e\u0007{$5FQ'$d\u001f\u0012f";
                    n3 = 12;
                    continue block25;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "Bvi\u0018\u00015ej\u0011\tgmr\u001e\u000b5p\u007f\u0006\u0003";
                    n3 = 13;
                    continue block25;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "Veh\u0018\ta$r\u0004\u0007{wj\u0017\u0012p$m\u0013\u001f/$";
                    n3 = 14;
                    continue block25;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "vkkX\u000fwi(\u0015\u0014ltr\u0019Hevi\u0000\u000fqatX\u0014pwr\u0004\u000fvpT%'P|v\u0019\bpjr";
                    n3 = 15;
                    continue block25;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "avs\u0013";
                    n3 = 16;
                    continue block25;
                }
                case 16: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        a = z[17].equalsIgnoreCase(AccessController.doPrivileged(new GetPropertyAction(z[16], z[17])));
        b = new RSAKeyFactory();
    }
}

