/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileStoreAttributes;
import sun.nio.fs.UnixPath;
import sun.security.action.GetPropertyAction;

class UnixNativeDispatcher {
    static boolean isAIX;
    static boolean isZOS;
    static boolean isOs400;
    private static ByteToCharConverter btc_fe;
    private static CharToByteConverter ctb_se;
    private static ByteToCharConverter btc_se;
    private static CharToByteConverter ctb_fe;
    private static boolean conversionRequired;
    private static final boolean hasAtSysCalls;
    private static final int HAS_AT_SYSCALLS = 1;

    protected UnixNativeDispatcher() {
    }

    private static NativeBuffer copyToNativeBuffer(UnixPath unixPath) {
        int n;
        NativeBuffer nativeBuffer;
        byte[] byArray = unixPath.getByteArrayForSysCalls();
        if (conversionRequired) {
            byArray = UnixNativeDispatcher.atoeConverter(byArray);
        }
        if ((nativeBuffer = NativeBuffers.getNativeBufferFromCache(n = byArray.length + 1)) == null) {
            nativeBuffer = NativeBuffers.allocNativeBuffer(n);
        } else if (nativeBuffer.owner() == unixPath) {
            return nativeBuffer;
        }
        NativeBuffers.copyCStringToNativeBuffer(byArray, nativeBuffer);
        nativeBuffer.setOwner(unixPath);
        return nativeBuffer;
    }

    static native byte[] getcwd();

    static int dup(int n) throws UnixException {
        int n2 = UnixNativeDispatcher.dup0(n);
        if (isZOS) {
            FdCache.dupFd(n, n2);
        }
        return n2;
    }

    static native int dup0(int var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int open(UnixPath unixPath, int n, int n2) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            int n3 = UnixNativeDispatcher.open0(nativeBuffer.address(), n, n2);
            if (isZOS) {
                FdCache.putFdPath(n3, unixPath);
            }
            int n4 = n3;
            return n4;
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native int open0(long var0, int var2, int var3) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int openat(int n, byte[] byArray, int n2, int n3) throws UnixException {
        NativeBuffer nativeBuffer = NativeBuffers.asNativeBuffer(byArray);
        try {
            int n4 = UnixNativeDispatcher.openat0(n, nativeBuffer.address(), n2, n3);
            return n4;
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native int openat0(int var0, long var1, int var3, int var4) throws UnixException;

    static void close(int n) {
        UnixNativeDispatcher.close0(n);
        if (isZOS) {
            FdCache.closeFd(n);
        }
    }

    static native void close0(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long fopen(UnixPath unixPath, String string) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        NativeBuffer nativeBuffer2 = NativeBuffers.asNativeBuffer(string.getBytes());
        try {
            long l = UnixNativeDispatcher.fopen0(nativeBuffer.address(), nativeBuffer2.address());
            return l;
        }
        finally {
            nativeBuffer2.release();
            nativeBuffer.release();
        }
    }

    private static native long fopen0(long var0, long var2) throws UnixException;

    static native void fclose(long var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void link(UnixPath unixPath, UnixPath unixPath2) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        NativeBuffer nativeBuffer2 = UnixNativeDispatcher.copyToNativeBuffer(unixPath2);
        try {
            UnixNativeDispatcher.link0(nativeBuffer.address(), nativeBuffer2.address());
        }
        finally {
            nativeBuffer2.release();
            nativeBuffer.release();
        }
    }

    private static native void link0(long var0, long var2) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unlink(UnixPath unixPath) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.unlink0(nativeBuffer.address());
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void unlink0(long var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unlinkat(int n, byte[] byArray, int n2) throws UnixException {
        NativeBuffer nativeBuffer = NativeBuffers.asNativeBuffer(byArray);
        try {
            UnixNativeDispatcher.unlinkat0(n, nativeBuffer.address(), n2);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void unlinkat0(int var0, long var1, int var3) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void mknod(UnixPath unixPath, int n, long l) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.mknod0(nativeBuffer.address(), n, l);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void mknod0(long var0, int var2, long var3) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void rename(UnixPath unixPath, UnixPath unixPath2) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        NativeBuffer nativeBuffer2 = UnixNativeDispatcher.copyToNativeBuffer(unixPath2);
        try {
            UnixNativeDispatcher.rename0(nativeBuffer.address(), nativeBuffer2.address());
        }
        finally {
            nativeBuffer2.release();
            nativeBuffer.release();
        }
    }

    private static native void rename0(long var0, long var2) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void renameat(int n, byte[] byArray, int n2, byte[] byArray2) throws UnixException {
        NativeBuffer nativeBuffer = NativeBuffers.asNativeBuffer(byArray);
        NativeBuffer nativeBuffer2 = NativeBuffers.asNativeBuffer(byArray2);
        try {
            UnixNativeDispatcher.renameat0(n, nativeBuffer.address(), n2, nativeBuffer2.address());
        }
        finally {
            nativeBuffer2.release();
            nativeBuffer.release();
        }
    }

    private static native void renameat0(int var0, long var1, int var3, long var4) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void mkdir(UnixPath unixPath, int n) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.mkdir0(nativeBuffer.address(), n);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void mkdir0(long var0, int var2) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void rmdir(UnixPath unixPath) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.rmdir0(nativeBuffer.address());
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void rmdir0(long var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readlink(UnixPath unixPath) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            byte[] byArray = UnixNativeDispatcher.readlink0(nativeBuffer.address());
            return byArray;
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native byte[] readlink0(long var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] realpath(UnixPath unixPath) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            byte[] byArray = UnixNativeDispatcher.realpath0(nativeBuffer.address());
            if (conversionRequired) {
                byArray = UnixNativeDispatcher.etoaConverter(byArray);
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native byte[] realpath0(long var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void symlink(byte[] byArray, UnixPath unixPath) throws UnixException {
        if (conversionRequired) {
            byArray = UnixNativeDispatcher.atoeConverter(byArray);
        }
        NativeBuffer nativeBuffer = NativeBuffers.asNativeBuffer(byArray);
        NativeBuffer nativeBuffer2 = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.symlink0(nativeBuffer.address(), nativeBuffer2.address());
        }
        finally {
            nativeBuffer2.release();
            nativeBuffer.release();
        }
    }

    private static native void symlink0(long var0, long var2) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stat(UnixPath unixPath, UnixFileAttributes unixFileAttributes) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.stat0(nativeBuffer.address(), unixFileAttributes);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void stat0(long var0, UnixFileAttributes var2) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void lstat(UnixPath unixPath, UnixFileAttributes unixFileAttributes) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.lstat0(nativeBuffer.address(), unixFileAttributes);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void lstat0(long var0, UnixFileAttributes var2) throws UnixException;

    static native void fstat(int var0, UnixFileAttributes var1) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fstatat(int n, byte[] byArray, int n2, UnixFileAttributes unixFileAttributes) throws UnixException {
        NativeBuffer nativeBuffer = NativeBuffers.asNativeBuffer(byArray);
        try {
            UnixNativeDispatcher.fstatat0(n, nativeBuffer.address(), n2, unixFileAttributes);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void fstatat0(int var0, long var1, int var3, UnixFileAttributes var4) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void chown(UnixPath unixPath, int n, int n2) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.chown0(nativeBuffer.address(), n, n2);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void chown0(long var0, int var2, int var3) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void lchown(UnixPath unixPath, int n, int n2) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.lchown0(nativeBuffer.address(), n, n2);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void lchown0(long var0, int var2, int var3) throws UnixException;

    static native void fchown(int var0, int var1, int var2) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void chmod(UnixPath unixPath, int n) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.chmod0(nativeBuffer.address(), n);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void chmod0(long var0, int var2) throws UnixException;

    static native void fchmod(int var0, int var1) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void utimes(UnixPath unixPath, long l, long l2) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.utimes0(nativeBuffer.address(), l, l2);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void utimes0(long var0, long var2, long var4) throws UnixException;

    static void futimes(int n, long l, long l2, UnixPath unixPath) throws UnixException {
        if (isAIX || isZOS || isOs400) {
            UnixNativeDispatcher.utimes(unixPath, l, l2);
        } else {
            UnixNativeDispatcher.futimes0(n, l, l2);
        }
    }

    private static native void futimes0(int var0, long var1, long var3) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long opendir(UnixPath unixPath) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            long l = UnixNativeDispatcher.opendir0(nativeBuffer.address());
            return l;
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native long opendir0(long var0) throws UnixException;

    static long fdopendir(int n) throws UnixException {
        if (isZOS) {
            return UnixNativeDispatcher.opendir(FdCache.getPath(n));
        }
        return UnixNativeDispatcher.fdopendir0(n);
    }

    static native long fdopendir0(int var0) throws UnixException;

    static native void closedir(long var0) throws UnixException;

    static native byte[] readdir(long var0) throws UnixException;

    static native int read(int var0, long var1, int var3) throws UnixException;

    static native int write(int var0, long var1, int var3) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void access(UnixPath unixPath, int n) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.access0(nativeBuffer.address(), n);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void access0(long var0, int var2) throws UnixException;

    static native byte[] getpwuid(int var0) throws UnixException;

    static native byte[] getgrgid(int var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getpwnam(String string) throws UnixException {
        NativeBuffer nativeBuffer = NativeBuffers.asNativeBuffer(string.getBytes());
        try {
            int n = UnixNativeDispatcher.getpwnam0(nativeBuffer.address());
            return n;
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native int getpwnam0(long var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getgrnam(String string) throws UnixException {
        NativeBuffer nativeBuffer = NativeBuffers.asNativeBuffer(string.getBytes());
        try {
            int n = UnixNativeDispatcher.getgrnam0(nativeBuffer.address());
            return n;
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native int getgrnam0(long var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void statvfs(UnixPath unixPath, UnixFileStoreAttributes unixFileStoreAttributes) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.statvfs0(nativeBuffer.address(), unixFileStoreAttributes);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void statvfs0(long var0, UnixFileStoreAttributes var2) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long pathconf(UnixPath unixPath, int n) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            long l = UnixNativeDispatcher.pathconf0(nativeBuffer.address(), n);
            return l;
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static byte[] atoeConverter(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n];
        byte[] byArray2 = new byte[n * 4];
        byte[] byArray3 = null;
        try {
            int n2 = btc_fe.convert(byArray, 0, n, cArray, 0, n);
            n2 = ctb_se.convert(cArray, 0, n2, byArray2, 0, n * 4);
            byArray3 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray3, 0, n2);
        }
        catch (IOException iOException) {
            System.out.println("ASCII to EBCDIC Conversion failed in NIO");
            byArray3 = byArray;
        }
        return byArray3;
    }

    private static byte[] etoaConverter(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n];
        byte[] byArray2 = new byte[n * 4];
        byte[] byArray3 = null;
        try {
            int n2 = btc_se.convert(byArray, 0, n, cArray, 0, n);
            n2 = ctb_fe.convert(cArray, 0, n2, byArray2, 0, n * 4);
            byArray3 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray3, 0, n2);
        }
        catch (IOException iOException) {
            System.out.println("EBCDIC to ASCII Conversion failed in NIO");
            byArray3 = byArray;
        }
        return byArray3;
    }

    private static native long pathconf0(long var0, int var2) throws UnixException;

    static native long fpathconf(int var0, int var1) throws UnixException;

    static native byte[] strerror(int var0);

    static boolean supportsAtSysCalls() {
        return hasAtSysCalls;
    }

    static boolean supportsNoFollowLinks() {
        return true;
    }

    private static native int init();

    static {
        btc_fe = null;
        ctb_se = null;
        btc_se = null;
        ctb_fe = null;
        conversionRequired = false;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("os.name", "unknownOS");
                isAIX = string.equals("AIX");
                isZOS = string.equals("z/OS");
                isOs400 = string.equals("OS/400");
                return null;
            }
        });
        if (isZOS) {
            String string = AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
            String string2 = AccessController.doPrivileged(new GetPropertyAction("ibm.system.encoding"));
            if (!string2.equals(string)) {
                try {
                    btc_fe = ByteToCharConverter.getConverter(string);
                    ctb_se = CharToByteConverter.getConverter(string2);
                    btc_se = ByteToCharConverter.getConverter(string2);
                    ctb_fe = CharToByteConverter.getConverter(string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
                conversionRequired = true;
            }
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("nio");
                return null;
            }
        });
        int n = UnixNativeDispatcher.init();
        hasAtSysCalls = (n & 1) > 0;
    }

    private static class FdCache {
        private static final HashMap<Integer, UnixPath> fdCache = new HashMap();

        private FdCache() {
        }

        static UnixPath getPath(int n) {
            return fdCache.get(new Integer(n));
        }

        static boolean putFdPath(int n, UnixPath unixPath) {
            if (unixPath == null || fdCache.get(new Integer(n)) != null) {
                return false;
            }
            fdCache.put(new Integer(n), unixPath);
            return true;
        }

        static boolean dupFd(int n, int n2) {
            if (n != n2) {
                UnixPath unixPath = fdCache.get(new Integer(n));
                if (unixPath != null) {
                    fdCache.put(new Integer(n2), unixPath);
                }
                return true;
            }
            return false;
        }

        static boolean closeFd(int n) {
            return fdCache.remove(new Integer(n)) != null;
        }
    }
}

