/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.util.HashSet;
import sun.nio.ch.AllocatedNativeObject;

class PollsetArrayWrapper {
    static final short POLLIN = 1;
    static final short POLLOUT = 2;
    static final short POLLHUP = 8192;
    static final short POLLERR = 16384;
    static final short POLLNVAL = Short.MIN_VALUE;
    static final short PS_ADD = 0;
    static final short PS_MOD = 1;
    static final short PS_DELETE = 2;
    static final short SIZE_POLLFD = PollsetArrayWrapper.getPollfdSize();
    static final short FD_OFFSET = 0;
    static final short EVENT_OFFSET = PollsetArrayWrapper.getSizeOfInt();
    static final short REVENT_OFFSET = (short)(EVENT_OFFSET + 2);
    static final short SIZE_POLLCTL = PollsetArrayWrapper.getPollCtlSize();
    static final short CTL_CMD_OFFSET = 0;
    static final short CTL_EVENTS_OFFSET = 2;
    static final short CTL_FD_OFFSET = 4;
    static final int NUM_POLLCTLEVENTS = 64;
    static final int NUM_POLLSETEVENTS = PollsetArrayWrapper.getFDLimit();
    static final int CTL_EVENTS_ARRAY_SIZE = 64 * SIZE_POLLCTL;
    static final int POLL_EVENTS_ARRAY_SIZE = NUM_POLLSETEVENTS * SIZE_POLLFD;
    private final long pollArrayAddress;
    private final HashSet<Integer> idleSet;
    private final Object pollsetUpdatorLock = new Object();
    private int pollsetUpdatorCount = 0;
    private int pollsetNumEvents = 0;
    private AllocatedNativeObject pollArray;
    private AllocatedNativeNode pollCtlArrayCurrent;
    private AllocatedNativeNode pollCtlArrayHead;
    final int pollsetFD = this.pollsetCreate(-1);
    int interruptFD;
    int updated;

    PollsetArrayWrapper() {
        this.pollArray = new AllocatedNativeObject(POLL_EVENTS_ARRAY_SIZE, true);
        this.pollArrayAddress = this.pollArray.address();
        this.pollCtlArrayHead = this.pollCtlArrayCurrent = new AllocatedNativeNode(CTL_EVENTS_ARRAY_SIZE, true);
        this.idleSet = new HashSet();
    }

    private static int getFDLimit() {
        int n = PollsetArrayWrapper.fdLimit();
        if (n <= 0) {
            return 8192;
        }
        return Math.min(n, 8192);
    }

    void initInterrupt(int n, int n2) {
        this.interruptFD = n2;
        this.pollsetCtl(this.pollsetFD, (short)0, (short)1, n);
    }

    int getEventOps(int n) {
        int n2 = SIZE_POLLFD * n + EVENT_OFFSET;
        return this.pollArray.getShort(n2);
    }

    int getReventOps(int n) {
        int n2 = SIZE_POLLFD * n + REVENT_OFFSET;
        short s = this.pollArray.getShort(n2);
        return PollsetArrayWrapper.getPollRevents(s);
    }

    int getDescriptor(int n) {
        int n2 = SIZE_POLLFD * n + 0;
        return this.pollArray.getInt(n2);
    }

    private void putCtlEventsOps(int n, short s) {
        int n2 = SIZE_POLLCTL * n + 2;
        this.pollCtlArrayCurrent.putShort(n2, s);
    }

    private void putCtlCmdOps(int n, short s) {
        int n2 = SIZE_POLLCTL * n + 0;
        this.pollCtlArrayCurrent.putShort(n2, s);
    }

    private void putCtlFD(int n, int n2) {
        int n3 = SIZE_POLLFD * n + 4;
        this.pollCtlArrayCurrent.putInt(n3, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterest(int n, int n2) {
        Object object = this.pollsetUpdatorLock;
        synchronized (object) {
            if (n2 == 0) {
                if (this.idleSet.add(n)) {
                    this.updateRegistration((short)2, (short)0, n);
                }
                return;
            }
            if (!this.idleSet.isEmpty() && this.idleSet.remove(n)) {
                this.updateRegistration((short)0, (short)n2, n);
                return;
            }
            this.updateRegistration((short)2, (short)0, n);
            this.updateRegistration((short)0, (short)n2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(int n) {
        Object object = this.pollsetUpdatorLock;
        synchronized (object) {
            this.updateRegistration((short)0, (short)0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(int n) {
        Object object = this.pollsetUpdatorLock;
        synchronized (object) {
            if (!this.idleSet.remove(n)) {
                this.updateRegistration((short)2, (short)0, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closePollsetFD() throws IOException {
        Object object = this.pollsetUpdatorLock;
        synchronized (object) {
            this.pollsetDestroy(this.pollsetFD);
            this.pollArray.free();
            AllocatedNativeNode.free(this.pollCtlArrayHead);
            this.pollCtlArrayHead = null;
            this.pollCtlArrayCurrent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushBulkPollCtlEvents() {
        Object object = this.pollsetUpdatorLock;
        synchronized (object) {
            if (this.pollsetNumEvents <= 0) {
                return;
            }
            int n = this.pollsetNumEvents;
            int n2 = this.pollsetNumEvents;
            AllocatedNativeNode allocatedNativeNode = this.pollCtlArrayHead;
            while (n2 > 0) {
                n = n2 >= 64 ? 64 : n2;
                n2 -= n;
                this.pollsetBulkCtl(this.pollsetFD, allocatedNativeNode.address(), n);
                allocatedNativeNode = allocatedNativeNode.getNext();
            }
            this.pollsetUpdatorCount = 0;
            this.pollsetNumEvents = 0;
            this.pollCtlArrayCurrent = this.pollCtlArrayHead;
        }
    }

    int poll(long l) throws IOException {
        this.flushBulkPollCtlEvents();
        this.updated = this.pollsetPoll(this.pollsetFD, this.pollArrayAddress, NUM_POLLSETEVENTS, l);
        return this.updated;
    }

    private void updateRegistration(short s, short s2, int n) {
        if (this.pollsetUpdatorCount == 64) {
            if (this.pollCtlArrayCurrent.getNext() != null) {
                this.pollCtlArrayCurrent = this.pollCtlArrayCurrent.getNext();
            } else {
                AllocatedNativeNode allocatedNativeNode = new AllocatedNativeNode(CTL_EVENTS_ARRAY_SIZE, true);
                this.pollCtlArrayCurrent.setNext(allocatedNativeNode);
                this.pollCtlArrayCurrent = allocatedNativeNode;
            }
            this.pollsetUpdatorCount = 0;
        }
        this.putCtlCmdOps(this.pollsetUpdatorCount, s);
        this.putCtlEventsOps(this.pollsetUpdatorCount, PollsetArrayWrapper.getAIXEvent(s2));
        this.putCtlFD(this.pollsetUpdatorCount++, n);
        ++this.pollsetNumEvents;
    }

    private static short getAIXEvent(short s) {
        if ((s & 1) != 0) {
            s = (short)(s | 1);
        }
        if ((s & 4) != 0) {
            s = (short)(s | 2);
        }
        if ((s & 8) != 0) {
            s = (short)(s | 0x4000);
        }
        if ((s & 0x10) != 0) {
            s = (short)(s | 0x2000);
        }
        if ((s & 0x20) != 0) {
            s = (short)(s | Short.MIN_VALUE);
        }
        return s;
    }

    private static short getPollRevents(short s) {
        if ((s & 1) != 0) {
            s = (short)(s | 1);
        }
        if ((s & 2) != 0) {
            s = (short)(s | 4);
        }
        if ((s & 0x4000) != 0) {
            s = (short)(s | 8);
        }
        if ((s & 0x2000) != 0) {
            s = (short)(s | 0x10);
        }
        if ((s & Short.MIN_VALUE) != 0) {
            s = (short)(s | 0x20);
        }
        return s;
    }

    public void interrupt() {
        PollsetArrayWrapper.interrupt(this.interruptFD);
    }

    private native int pollsetCreate(int var1);

    private native int pollsetDestroy(int var1);

    private native void pollsetCtl(int var1, short var2, short var3, int var4);

    private native void pollsetBulkCtl(int var1, long var2, int var4);

    private native int pollsetPoll(int var1, long var2, int var4, long var5) throws IOException;

    private static native int fdLimit();

    private static native void interrupt(int var0);

    private static native void init();

    private static native short getPollfdSize();

    private static native short getSizeOfInt();

    private static native short getPollCtlSize();

    static {
        PollsetArrayWrapper.init();
    }

    private static class AllocatedNativeNode
    extends AllocatedNativeObject {
        private AllocatedNativeNode nextNode = null;

        AllocatedNativeNode(int n, boolean bl) {
            super(n, bl);
        }

        void setNext(AllocatedNativeNode allocatedNativeNode) {
            this.nextNode = allocatedNativeNode;
        }

        AllocatedNativeNode getNext() {
            return this.nextNode;
        }

        static void free(AllocatedNativeNode allocatedNativeNode) {
            AllocatedNativeNode allocatedNativeNode2 = allocatedNativeNode;
            while (allocatedNativeNode2 != null) {
                AllocatedNativeNode allocatedNativeNode3 = allocatedNativeNode2.getNext();
                allocatedNativeNode2.free();
                allocatedNativeNode2 = allocatedNativeNode3;
            }
        }
    }
}

