/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class CharToByteASCII
extends CharToByteConverter {
    private char highHalfZoneCode;

    @Override
    public String getCharacterEncoding() {
        return "ASCII";
    }

    @Override
    public int flush(byte[] byArray, int n, int n2) throws MalformedInputException {
        if (this.highHalfZoneCode != '\u0000') {
            this.highHalfZoneCode = '\u0000';
            throw new MalformedInputException("String ends with <High Half Zone code> of UTF16");
        }
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int convert(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws MalformedInputException, UnknownCharacterException, ConversionBufferFullException {
        char c;
        int n5;
        if (this.highHalfZoneCode != '\u0000') {
            this.charOff = n;
            this.byteOff = n3;
        } else {
            int n6;
            int n7 = n3;
            n5 = n4 - n3 >= n2 - n ? n2 : n + (n4 - n3);
            for (n6 = n; n6 < n5 && (c = cArray[n6]) < '\u0080'; ++n6) {
                byArray[n7++] = (byte)c;
            }
            this.charOff = n6;
            this.byteOff = n7;
            if (n6 == n2) {
                return n7 - n3;
            }
        }
        byte[] byArray2 = new byte[1];
        if (this.highHalfZoneCode != '\u0000') {
            c = this.highHalfZoneCode;
            this.highHalfZoneCode = '\u0000';
            if (cArray[n] >= '\udc00' && cArray[n] <= '\udfff') {
                this.badInputLength = 1;
                throw new UnknownCharacterException();
            }
            this.badInputLength = 0;
            throw new MalformedInputException("Previous converted string ends with <High Half Zone Code> of UTF16 , but this string is not begin with <Low Half Zone>");
        }
        while (this.charOff < n2) {
            int n8;
            byte[] byArray3;
            block20: {
                byArray3 = byArray2;
                c = cArray[this.charOff];
                n8 = 1;
                n5 = 1;
                if ((c & 0xF800) == 55296) {
                    if (c <= '\udbff') {
                        if (this.charOff + 1 == n2) {
                            this.highHalfZoneCode = c;
                            return this.byteOff - n3;
                        }
                        c = cArray[this.charOff + 1];
                        if (c >= '\udc00' && c <= '\udfff') {
                            if (!this.subMode) {
                                this.badInputLength = 2;
                                throw new UnknownCharacterException();
                            }
                            byArray3 = this.subBytes;
                            n8 = this.subBytes.length;
                            n5 = 2;
                            break block20;
                        } else {
                            this.badInputLength = 1;
                            throw new MalformedInputException();
                        }
                    }
                    if (c <= '\udfff') {
                        this.badInputLength = 1;
                        throw new MalformedInputException();
                    }
                } else if (c <= '\u007f') {
                    byArray3[0] = (byte)c;
                } else {
                    if (!this.subMode) {
                        this.badInputLength = 1;
                        throw new UnknownCharacterException();
                    }
                    byArray3 = this.subBytes;
                    n8 = this.subBytes.length;
                }
            }
            if (this.byteOff + n8 > n4) {
                throw new ConversionBufferFullException();
            }
            for (int i = 0; i < n8; ++i) {
                byArray[this.byteOff++] = byArray3[i];
            }
            this.charOff += n5;
        }
        return this.byteOff - n3;
    }

    @Override
    public boolean canConvert(char c) {
        return c <= '\u007f';
    }

    @Override
    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        this.highHalfZoneCode = '\u0000';
    }

    @Override
    public int getMaxBytesPerChar() {
        return 1;
    }
}

