/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTKeyStroke;
import sun.awt.X11.XAtom;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XKeysym;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;
import sun.util.logging.PlatformLogger;

public class XEmbedHelper {
    private static final PlatformLogger xembedLog = PlatformLogger.getLogger("sun.awt.X11.xembed");
    static final Unsafe unsafe = Unsafe.getUnsafe();
    static final int XEMBED_VERSION = 0;
    static final int XEMBED_MAPPED = 1;
    static final int XEMBED_EMBEDDED_NOTIFY = 0;
    static final int XEMBED_WINDOW_ACTIVATE = 1;
    static final int XEMBED_WINDOW_DEACTIVATE = 2;
    static final int XEMBED_REQUEST_FOCUS = 3;
    static final int XEMBED_FOCUS_IN = 4;
    static final int XEMBED_FOCUS_OUT = 5;
    static final int XEMBED_FOCUS_NEXT = 6;
    static final int XEMBED_FOCUS_PREV = 7;
    static final int XEMBED_GRAB_KEY = 8;
    static final int XEMBED_UNGRAB_KEY = 9;
    static final int XEMBED_MODALITY_ON = 10;
    static final int XEMBED_MODALITY_OFF = 11;
    static final int XEMBED_REGISTER_ACCELERATOR = 12;
    static final int XEMBED_UNREGISTER_ACCELERATOR = 13;
    static final int XEMBED_ACTIVATE_ACCELERATOR = 14;
    static final int NON_STANDARD_XEMBED_GTK_GRAB_KEY = 108;
    static final int NON_STANDARD_XEMBED_GTK_UNGRAB_KEY = 109;
    static final int XEMBED_FOCUS_CURRENT = 0;
    static final int XEMBED_FOCUS_FIRST = 1;
    static final int XEMBED_FOCUS_LAST = 2;
    static final int XEMBED_MODIFIER_SHIFT = 1;
    static final int XEMBED_MODIFIER_CONTROL = 2;
    static final int XEMBED_MODIFIER_ALT = 4;
    static final int XEMBED_MODIFIER_SUPER = 8;
    static final int XEMBED_MODIFIER_HYPER = 16;
    static XAtom XEmbedInfo;
    static XAtom XEmbed;

    XEmbedHelper() {
        if (XEmbed == null) {
            XEmbed = XAtom.get("_XEMBED");
            if (xembedLog.isLoggable(400)) {
                xembedLog.finer("Created atom " + XEmbed.toString());
            }
        }
        if (XEmbedInfo == null) {
            XEmbedInfo = XAtom.get("_XEMBED_INFO");
            if (xembedLog.isLoggable(400)) {
                xembedLog.finer("Created atom " + XEmbedInfo.toString());
            }
        }
    }

    void sendMessage(long l, int n) {
        this.sendMessage(l, n, 0L, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendMessage(long l, int n, long l2, long l3, long l4) {
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        xClientMessageEvent.set_type(33);
        xClientMessageEvent.set_window(l);
        xClientMessageEvent.set_message_type(XEmbed.getAtom());
        xClientMessageEvent.set_format(32);
        xClientMessageEvent.set_data(0, XToolkit.getCurrentServerTime());
        xClientMessageEvent.set_data(1, n);
        xClientMessageEvent.set_data(2, l2);
        xClientMessageEvent.set_data(3, l3);
        xClientMessageEvent.set_data(4, l4);
        XToolkit.awtLock();
        try {
            if (xembedLog.isLoggable(500)) {
                xembedLog.fine("Sending " + XEmbedHelper.XEmbedMessageToString(xClientMessageEvent));
            }
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), l, false, 0L, xClientMessageEvent.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
        xClientMessageEvent.dispose();
    }

    static String msgidToString(int n) {
        switch (n) {
            case 0: {
                return "XEMBED_EMBEDDED_NOTIFY";
            }
            case 1: {
                return "XEMBED_WINDOW_ACTIVATE";
            }
            case 2: {
                return "XEMBED_WINDOW_DEACTIVATE";
            }
            case 4: {
                return "XEMBED_FOCUS_IN";
            }
            case 5: {
                return "XEMBED_FOCUS_OUT";
            }
            case 3: {
                return "XEMBED_REQUEST_FOCUS";
            }
            case 6: {
                return "XEMBED_FOCUS_NEXT";
            }
            case 7: {
                return "XEMBED_FOCUS_PREV";
            }
            case 10: {
                return "XEMBED_MODALITY_ON";
            }
            case 11: {
                return "XEMBED_MODALITY_OFF";
            }
            case 12: {
                return "XEMBED_REGISTER_ACCELERATOR";
            }
            case 13: {
                return "XEMBED_UNREGISTER_ACCELERATOR";
            }
            case 14: {
                return "XEMBED_ACTIVATE_ACCELERATOR";
            }
            case 8: {
                return "XEMBED_GRAB_KEY";
            }
            case 9: {
                return "XEMBED_UNGRAB_KEY";
            }
            case 109: {
                return "NON_STANDARD_XEMBED_GTK_UNGRAB_KEY";
            }
            case 108: {
                return "NON_STANDARD_XEMBED_GTK_GRAB_KEY";
            }
            case 32770: {
                return "KeyPress";
            }
            case 32787: {
                return "MapNotify";
            }
            case 32796: {
                return "PropertyNotify";
            }
        }
        return "unknown XEMBED id " + n;
    }

    static String focusIdToString(int n) {
        switch (n) {
            case 0: {
                return "XEMBED_FOCUS_CURRENT";
            }
            case 1: {
                return "XEMBED_FOCUS_FIRST";
            }
            case 2: {
                return "XEMBED_FOCUS_LAST";
            }
        }
        return "unknown focus id " + n;
    }

    static String XEmbedMessageToString(XClientMessageEvent xClientMessageEvent) {
        return "XEmbed message to " + Long.toHexString(xClientMessageEvent.get_window()) + ": " + XEmbedHelper.msgidToString((int)xClientMessageEvent.get_data(1)) + ", detail: " + xClientMessageEvent.get_data(2) + ", data:[" + xClientMessageEvent.get_data(3) + "," + xClientMessageEvent.get_data(4) + "]";
    }

    int getModifiers(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 0x40;
        }
        if ((n & 2) != 0) {
            n2 |= 0x80;
        }
        if ((n & 4) != 0) {
            n2 |= 0x200;
        }
        if ((n & 8) != 0) {
            n2 |= 0x200;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AWTKeyStroke getKeyStrokeForKeySym(long l, long l2) {
        int n;
        XBaseWindow.checkSecurity();
        XToolkit.awtLock();
        try {
            XKeysym.Keysym2JavaKeycode keysym2JavaKeycode = XKeysym.getJavaKeycode(l);
            n = keysym2JavaKeycode == null ? 0 : keysym2JavaKeycode.getJavaKeycode();
        }
        finally {
            XToolkit.awtUnlock();
        }
        int n2 = this.getModifiers((int)l2);
        return AWTKeyStroke.getAWTKeyStroke(n, n2);
    }
}

