/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.InvalidDnDOperationException;
import java.util.Map;
import sun.awt.X11.MotifDnDConstants;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDragSourceProtocol;
import sun.awt.X11.XDragSourceProtocolListener;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XException;
import sun.awt.X11.XSelectionRequestEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

class MotifDnDDragSourceProtocol
extends XDragSourceProtocol
implements XEventDispatcher {
    private static final Unsafe unsafe = XlibWrapper.unsafe;
    private long targetEnterServerTime = 0L;

    protected MotifDnDDragSourceProtocol(XDragSourceProtocolListener xDragSourceProtocolListener) {
        super(xDragSourceProtocolListener);
        XToolkit.addEventDispatcher(XWindow.getXAWTRootWindow().getWindow(), this);
    }

    static XDragSourceProtocol createInstance(XDragSourceProtocolListener xDragSourceProtocolListener) {
        return new MotifDnDDragSourceProtocol(xDragSourceProtocolListener);
    }

    @Override
    public String getProtocolName() {
        return "MotifDnD";
    }

    @Override
    protected void initializeDragImpl(int n, Transferable transferable, Map map, long[] lArray) throws InvalidDnDOperationException, IllegalArgumentException, XException {
        long l = XDragSourceProtocol.getDragSourceWindow();
        try {
            int n2 = MotifDnDConstants.getIndexForTargetList(lArray);
            MotifDnDConstants.writeDragInitiatorInfoStruct(l, n2);
        }
        catch (XException xException) {
            this.cleanup();
            throw xException;
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            this.cleanup();
            throw invalidDnDOperationException;
        }
        if (!MotifDnDConstants.MotifDnDSelection.setOwner(transferable, map, lArray, 0L)) {
            this.cleanup();
            throw new InvalidDnDOperationException("Cannot acquire selection ownership");
        }
    }

    @Override
    public boolean processClientMessage(XClientMessageEvent xClientMessageEvent) {
        if (xClientMessageEvent.get_message_type() != MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom()) {
            return false;
        }
        long l = xClientMessageEvent.get_data();
        byte by = (byte)(unsafe.getByte(l) & 0x7F);
        byte by2 = (byte)(unsafe.getByte(l) & 0xFFFFFF80);
        byte by3 = unsafe.getByte(l + 1L);
        boolean bl = by3 != MotifDnDConstants.getByteOrderByte();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (by2 != -128) {
            return false;
        }
        switch (by) {
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                short s = unsafe.getShort(l + 2L);
                if (bl) {
                    s = MotifDnDConstants.Swapper.swap(s);
                }
                byte by4 = (byte)((s & 0xF0) >> 4);
                byte by5 = (byte)((s & 0xF) >> 0);
                n = by4 == 3 ? MotifDnDConstants.getJavaActionsForMotifActions(by5) : 0;
                this.getProtocolListener().handleDragReply(n);
                return true;
            }
            default: {
                return false;
            }
        }
        int n4 = unsafe.getInt(l + 4L);
        if (bl) {
            n4 = MotifDnDConstants.Swapper.swap(n4);
        }
        long l2 = (long)n4 & 0xFFFFFFFFL;
        if (this.targetEnterServerTime == 0L || l2 < this.targetEnterServerTime) {
            return true;
        }
        if (by != 4) {
            short s = unsafe.getShort(l + 2L);
            if (bl) {
                s = MotifDnDConstants.Swapper.swap(s);
            }
            byte by6 = (byte)((s & 0xF0) >> 4);
            byte by7 = (byte)((s & 0xF) >> 0);
            n = by6 == 3 ? MotifDnDConstants.getJavaActionsForMotifActions(by7) : 0;
            short s2 = unsafe.getShort(l + 8L);
            short s3 = unsafe.getShort(l + 10L);
            if (bl) {
                s2 = MotifDnDConstants.Swapper.swap(s2);
                s3 = MotifDnDConstants.Swapper.swap(s3);
            }
            n2 = s2;
            n3 = s3;
        }
        this.getProtocolListener().handleDragReply(n, n2, n3);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XDragSourceProtocol.TargetWindowInfo getTargetWindowInfo(long l) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l, MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO, 0L, 65535L, false, 0L);
        try {
            int n = windowPropertyGetter.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
            if (n == 0 && windowPropertyGetter.getData() != 0L && windowPropertyGetter.getActualType() != 0L && windowPropertyGetter.getActualFormat() == 8 && windowPropertyGetter.getNumberOfItems() >= 16) {
                long l2 = windowPropertyGetter.getData();
                byte by = unsafe.getByte(l2);
                byte by2 = unsafe.getByte(l2 + 2L);
                switch (by2) {
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: {
                        int n2 = unsafe.getInt(l2 + 4L);
                        if (by != MotifDnDConstants.getByteOrderByte()) {
                            n2 = MotifDnDConstants.Swapper.swap(n2);
                        }
                        byte by3 = unsafe.getByte(l2 + 1L);
                        XDragSourceProtocol.TargetWindowInfo targetWindowInfo = new XDragSourceProtocol.TargetWindowInfo(n2, by3);
                        return targetWindowInfo;
                    }
                }
                XDragSourceProtocol.TargetWindowInfo targetWindowInfo = null;
                return targetWindowInfo;
            }
            XDragSourceProtocol.TargetWindowInfo targetWindowInfo = null;
            return targetWindowInfo;
        }
        finally {
            windowPropertyGetter.dispose();
        }
    }

    private int createMotifActionFlag(int n, int n2) {
        int n3 = MotifDnDConstants.getMotifActionsForJavaActions(n);
        int n4 = MotifDnDConstants.getMotifActionsForJavaActions(n2);
        if (n3 != 1) {
            n4 = n3;
        }
        int n5 = n3 << 0 | n4 << 8;
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendEnterMessage(long[] lArray, int n, int n2, long l) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        assert (this.getTargetWindow() != 0L);
        assert (lArray != null);
        this.targetEnterServerTime = l;
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        try {
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(this.getTargetWindow());
            xClientMessageEvent.set_format(8);
            xClientMessageEvent.set_message_type(MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom());
            long l2 = xClientMessageEvent.get_data();
            int n3 = this.createMotifActionFlag(n, n2);
            unsafe.putByte(l2, (byte)0);
            unsafe.putByte(l2 + 1L, MotifDnDConstants.getByteOrderByte());
            unsafe.putShort(l2 + 2L, (short)n3);
            unsafe.putInt(l2 + 4L, (int)l);
            unsafe.putInt(l2 + 8L, (int)XDragSourceProtocol.getDragSourceWindow());
            unsafe.putInt(l2 + 12L, (int)MotifDnDConstants.XA_MOTIF_ATOM_0.getAtom());
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, xClientMessageEvent.pData);
        }
        finally {
            xClientMessageEvent.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMoveMessage(int n, int n2, int n3, int n4, long l) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        assert (this.getTargetWindow() != 0L);
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        try {
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(this.getTargetWindow());
            xClientMessageEvent.set_format(8);
            xClientMessageEvent.set_message_type(MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom());
            long l2 = xClientMessageEvent.get_data();
            int n5 = this.createMotifActionFlag(n3, n4);
            unsafe.putByte(l2, (byte)2);
            unsafe.putByte(l2 + 1L, MotifDnDConstants.getByteOrderByte());
            unsafe.putShort(l2 + 2L, (short)n5);
            unsafe.putInt(l2 + 4L, (int)l);
            unsafe.putShort(l2 + 8L, (short)n);
            unsafe.putShort(l2 + 10L, (short)n2);
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, xClientMessageEvent.pData);
        }
        finally {
            xClientMessageEvent.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendLeaveMessage(long l) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        assert (this.getTargetWindow() != 0L);
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        try {
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(this.getTargetWindow());
            xClientMessageEvent.set_format(8);
            xClientMessageEvent.set_message_type(MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom());
            long l2 = xClientMessageEvent.get_data();
            unsafe.putByte(l2, (byte)1);
            unsafe.putByte(l2 + 1L, MotifDnDConstants.getByteOrderByte());
            unsafe.putShort(l2 + 2L, (short)0);
            unsafe.putInt(l2 + 4L, (int)l);
            unsafe.putInt(l2 + 8L, (int)XDragSourceProtocol.getDragSourceWindow());
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, xClientMessageEvent.pData);
        }
        finally {
            xClientMessageEvent.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendDropMessage(int n, int n2, int n3, int n4, long l) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        assert (this.getTargetWindow() != 0L);
        this.sendLeaveMessage(l);
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        try {
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(this.getTargetWindow());
            xClientMessageEvent.set_format(8);
            xClientMessageEvent.set_message_type(MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom());
            long l2 = xClientMessageEvent.get_data();
            int n5 = this.createMotifActionFlag(n3, n4);
            unsafe.putByte(l2, (byte)5);
            unsafe.putByte(l2 + 1L, MotifDnDConstants.getByteOrderByte());
            unsafe.putShort(l2 + 2L, (short)n5);
            unsafe.putInt(l2 + 4L, (int)l);
            unsafe.putShort(l2 + 8L, (short)n);
            unsafe.putShort(l2 + 10L, (short)n2);
            unsafe.putInt(l2 + 12L, (int)MotifDnDConstants.XA_MOTIF_ATOM_0.getAtom());
            unsafe.putInt(l2 + 16L, (int)XDragSourceProtocol.getDragSourceWindow());
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, xClientMessageEvent.pData);
        }
        finally {
            xClientMessageEvent.dispose();
        }
    }

    @Override
    public boolean processProxyModeEvent(XClientMessageEvent xClientMessageEvent, long l) {
        return false;
    }

    @Override
    public void cleanupTargetInfo() {
        super.cleanupTargetInfo();
        this.targetEnterServerTime = 0L;
    }

    @Override
    public void dispatchEvent(XEvent xEvent) {
        switch (xEvent.get_type()) {
            case 30: {
                XSelectionRequestEvent xSelectionRequestEvent = xEvent.get_xselectionrequest();
                long l = xSelectionRequestEvent.get_selection();
                if (l != MotifDnDConstants.XA_MOTIF_ATOM_0.getAtom()) break;
                long l2 = xSelectionRequestEvent.get_target();
                if (l2 == MotifDnDConstants.XA_XmTRANSFER_SUCCESS.getAtom()) {
                    this.getProtocolListener().handleDragFinished(true);
                    break;
                }
                if (l2 != MotifDnDConstants.XA_XmTRANSFER_FAILURE.getAtom()) break;
                this.getProtocolListener().handleDragFinished(false);
            }
        }
    }
}

