/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.util;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class TwoKeyHashMap<E, K, V>
extends AbstractMap<String, V> {
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_INITIAL_SIZE = 16;
    private Set<Map.Entry<String, V>> entrySet;
    private Collection<V> values;
    private int size;
    private int arrSize;
    private int modCount;
    private Entry<E, K, V>[] arr;
    private float loadFactor;
    int threshold = 0;

    public TwoKeyHashMap() {
        this(16, 0.75f);
    }

    public TwoKeyHashMap(int n) {
        this(n, 0.75f);
    }

    public TwoKeyHashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("initialCapacity should be >= 0");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("initialLoadFactor should be > 0");
        }
        this.loadFactor = f;
        if (n == Integer.MAX_VALUE) {
            --n;
        }
        this.arrSize = n > 0 ? n : 1;
        this.threshold = (int)((float)this.arrSize * this.loadFactor);
        this.arr = new Entry[this.arrSize + 1];
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new ValuesCollectionImpl();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySetImpl();
        }
        return this.entrySet;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        Arrays.fill(this.arr, 0, this.arr.length, null);
    }

    public V remove(Object object, Object object2) {
        Entry<E, K, V> entry = this.removeEntry(object, object2);
        return null != entry ? (V)entry.value : null;
    }

    public V put(E e, K k, V v) {
        if (e == null && k == null) {
            int n = this.arrSize;
            if (this.arr[n] == null) {
                this.arr[n] = this.createEntry(0, null, null, v, null);
                ++this.size;
                ++this.modCount;
                return null;
            }
            Object v2 = this.arr[n].value;
            this.arr[n].value = v;
            return v2;
        }
        int n = e.hashCode() + k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.arrSize;
        Entry<E, K, V> entry = this.arr[n2];
        while (entry != null) {
            if (n == entry.hash && e.equals(entry.getKey1()) && k.equals(entry.getKey2())) {
                Object v3 = entry.value;
                entry.value = v;
                return v3;
            }
            entry = entry.next;
        }
        this.arr[n2] = this.createEntry(n, e, k, v, this.arr[n2]);
        ++this.size;
        ++this.modCount;
        if (this.size > this.threshold) {
            this.rehash();
        }
        return null;
    }

    void rehash() {
        int n = (this.arrSize + 1) * 2 + 1;
        if (n < 0) {
            n = 0x7FFFFFFE;
        }
        Entry[] entryArray = new Entry[n + 1];
        for (int i = 0; i < this.arr.length - 1; ++i) {
            Entry<E, K, V> entry = this.arr[i];
            while (entry != null) {
                Entry entry2 = entry.next;
                int n2 = (entry.hash & Integer.MAX_VALUE) % n;
                entry.next = entryArray[n2];
                entryArray[n2] = entry;
                entry = entry2;
            }
        }
        entryArray[n] = this.arr[this.arrSize];
        this.arrSize = n;
        if (this.arrSize == Integer.MAX_VALUE) {
            this.loadFactor *= 10.0f;
        }
        this.threshold = (int)((float)this.arrSize * this.loadFactor);
        this.arr = entryArray;
    }

    public boolean containsKey(Object object, Object object2) {
        return this.findEntry(object, object2) != null;
    }

    public V get(Object object, Object object2) {
        Entry<E, K, V> entry = this.findEntry(object, object2);
        if (entry != null) {
            return entry.value;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    Entry<E, K, V> createEntry(int n, E e, K k, V v, Entry<E, K, V> entry) {
        return new Entry<E, K, V>(n, e, k, v, entry);
    }

    Iterator<Map.Entry<String, V>> createEntrySetIterator() {
        return new EntryIteratorImpl();
    }

    Iterator<V> createValueCollectionIterator() {
        return new ValueIteratorImpl();
    }

    private final Entry<E, K, V> findEntry(Object object, Object object2) {
        if (object == null && object2 == null) {
            return this.arr[this.arrSize];
        }
        int n = object.hashCode() + object2.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.arrSize;
        Entry<E, K, V> entry = this.arr[n2];
        while (entry != null) {
            if (n == entry.hash && object.equals(entry.getKey1()) && object2.equals(entry.getKey2())) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    private final Entry<E, K, V> removeEntry(Object object, Object object2) {
        Entry<E, K, V> entry;
        if (object == null && object2 == null) {
            int n = this.arrSize;
            if (this.arr[n] != null) {
                Entry<E, K, V> entry2 = this.arr[n];
                this.arr[n] = null;
                --this.size;
                ++this.modCount;
                return entry2;
            }
            return null;
        }
        int n = object.hashCode() + object2.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.arrSize;
        Entry<E, K, V> entry3 = entry = this.arr[n2];
        while (entry != null) {
            if (n == entry.hash && object.equals(entry.getKey1()) && object2.equals(entry.getKey2())) {
                if (entry3 == entry) {
                    this.arr[n2] = entry.next;
                } else {
                    entry3.next = entry.next;
                }
                --this.size;
                ++this.modCount;
                return entry;
            }
            entry3 = entry;
            entry = entry.next;
        }
        return null;
    }

    class ValueIteratorImpl
    implements Iterator<V> {
        private EntryIteratorImpl itr;

        ValueIteratorImpl() {
            this.itr = new EntryIteratorImpl();
        }

        @Override
        public V next() {
            return this.itr.next().getValue();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }
    }

    class ValuesCollectionImpl
    extends AbstractCollection<V> {
        ValuesCollectionImpl() {
        }

        @Override
        public int size() {
            return TwoKeyHashMap.this.size;
        }

        @Override
        public void clear() {
            TwoKeyHashMap.this.clear();
        }

        @Override
        public boolean isEmpty() {
            return TwoKeyHashMap.this.size == 0;
        }

        @Override
        public Iterator<V> iterator() {
            return TwoKeyHashMap.this.createValueCollectionIterator();
        }

        @Override
        public boolean contains(Object object) {
            return TwoKeyHashMap.this.containsValue(object);
        }
    }

    class EntryIteratorImpl
    implements Iterator<Map.Entry<String, V>> {
        private int startModCount;
        private boolean found;
        private int curr = -1;
        private int returned_index = -1;
        private Entry<E, K, V> curr_entry;
        private Entry<E, K, V> returned_entry;

        EntryIteratorImpl() {
            this.startModCount = TwoKeyHashMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            if (this.found) {
                return true;
            }
            if (this.curr_entry != null) {
                this.curr_entry = this.curr_entry.next;
            }
            if (this.curr_entry == null) {
                ++this.curr;
                while (this.curr < TwoKeyHashMap.this.arr.length && TwoKeyHashMap.this.arr[this.curr] == null) {
                    ++this.curr;
                }
                if (this.curr < TwoKeyHashMap.this.arr.length) {
                    this.curr_entry = TwoKeyHashMap.this.arr[this.curr];
                }
            }
            this.found = this.curr_entry != null;
            return this.found;
        }

        @Override
        public Map.Entry<String, V> next() {
            if (TwoKeyHashMap.this.modCount != this.startModCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.found = false;
            this.returned_index = this.curr;
            this.returned_entry = this.curr_entry;
            return this.curr_entry;
        }

        @Override
        public void remove() {
            if (this.returned_index == -1) {
                throw new IllegalStateException();
            }
            if (TwoKeyHashMap.this.modCount != this.startModCount) {
                throw new ConcurrentModificationException();
            }
            Entry entry = null;
            Entry entry2 = TwoKeyHashMap.this.arr[this.returned_index];
            while (entry2 != this.returned_entry) {
                entry = entry2;
                entry2 = entry2.next;
            }
            if (entry != null) {
                entry.next = this.returned_entry.next;
            } else {
                ((TwoKeyHashMap)TwoKeyHashMap.this).arr[this.returned_index] = this.returned_entry.next;
            }
            TwoKeyHashMap.this.size--;
            TwoKeyHashMap.this.modCount++;
            ++this.startModCount;
            this.returned_index = -1;
        }
    }

    class EntrySetImpl
    extends AbstractSet<Map.Entry<String, V>> {
        EntrySetImpl() {
        }

        @Override
        public int size() {
            return TwoKeyHashMap.this.size;
        }

        @Override
        public void clear() {
            TwoKeyHashMap.this.clear();
        }

        @Override
        public boolean isEmpty() {
            return TwoKeyHashMap.this.size == 0;
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            Entry entry2 = TwoKeyHashMap.this.findEntry(entry.getKey1(), entry.getKey2());
            if (entry2 == null) {
                return false;
            }
            Object v = entry.getValue();
            Object v2 = entry2.getValue();
            return v == null ? v2 == null : v.equals(v2);
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            return TwoKeyHashMap.this.removeEntry(((Entry)object).getKey1(), ((Entry)object).getKey2()) != null;
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return TwoKeyHashMap.this.createEntrySetIterator();
        }
    }

    public static class Entry<E, K, V>
    implements Map.Entry<String, V> {
        int hash;
        E key1;
        K key2;
        V value;
        Entry<E, K, V> next;

        public Entry(int n, E e, K k, V v, Entry<E, K, V> entry) {
            this.hash = n;
            this.key1 = e;
            this.key2 = k;
            this.value = v;
            this.next = entry;
        }

        @Override
        public String getKey() {
            return this.key1.toString() + this.key2.toString();
        }

        public E getKey1() {
            return this.key1;
        }

        public K getKey2() {
            return this.key2;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            E e = entry.getKey1();
            K k = entry.getKey2();
            V v = entry.getValue();
            return !(this.key1 == null && e != null || this.key2 == null && k != null || this.value == null && v != null || !this.key1.equals(entry.getKey1()) || !this.key2.equals(entry.getKey2())) && this.value.equals(v);
        }

        @Override
        public int hashCode() {
            int n = this.key1 == null ? 0 : this.key1.hashCode();
            int n2 = this.key2 == null ? 0 : this.key2.hashCode();
            return n + n2 ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }
}

