/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.ibm.jvm.MemorySafetyService;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.security.AccessController;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import sun.misc.Hashing;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

public class Hashtable<K, V>
extends Dictionary<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final Entry<?, ?>[] EMPTY_TABLE = new Entry[0];
    private transient Entry<K, V>[] table = EMPTY_TABLE;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount = 0;
    private static final long serialVersionUID = 1421746759512286392L;
    static final int ALTERNATIVE_HASHING_THRESHOLD_DEFAULT = Integer.MAX_VALUE;
    transient int hashSeed;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private volatile transient Set<K> keySet = null;
    private volatile transient Set<Map.Entry<K, V>> entrySet = null;
    private volatile transient Collection<V> values = null;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;

    final boolean initHashSeedAsNeeded(int n) {
        boolean bl;
        boolean bl2 = this.hashSeed != 0;
        boolean bl3 = bl2 ^ (bl = VM.isBooted() && n >= Holder.ALTERNATIVE_HASHING_THRESHOLD);
        if (bl3) {
            this.hashSeed = bl ? Hashing.randomHashSeed(this) : 0;
        }
        return bl3;
    }

    private int hash(Object object) {
        return this.hashSeed ^ object.hashCode();
    }

    public Hashtable(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.threshold = n;
        this.initHashSeedAsNeeded(n);
    }

    public Hashtable(int n) {
        this(n, 0.75f);
    }

    public Hashtable() {
        this(11, 0.75f);
    }

    public Hashtable(Map<? extends K, ? extends V> map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        super.inflateTable(this.threshold);
        this.putAll(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inflateTable(int n) {
        int n2 = n;
        if (n2 == 0) {
            n2 = 1;
        }
        this.threshold = (int)Math.min((float)n2 * this.loadFactor, 2.1474836E9f);
        if (MemorySafetyService.isSafeMode()) {
            long l = -1L;
            try {
                l = MemorySafetyService.enterObjectsMemoryArea((Object)this);
                this.table = new Entry[n2];
            }
            finally {
                MemorySafetyService.exitLastMemoryArea((long)l);
            }
        } else {
            this.table = new Entry[n2];
        }
    }

    @Override
    public synchronized int size() {
        return this.count;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public synchronized Enumeration<K> keys() {
        return this.getEnumeration(0);
    }

    @Override
    public synchronized Enumeration<V> elements() {
        return this.getEnumeration(1);
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry<K, V>[] entryArray = this.table;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry<K, V> entry = entryArray[n];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    @Override
    public synchronized boolean containsKey(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.count == 0) {
            return false;
        }
        Entry<K, V>[] entryArray = this.table;
        int n = this.hash(object);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<K, V> entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    @Override
    public synchronized V get(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.count == 0) {
            return null;
        }
        Entry<K, V>[] entryArray = this.table;
        int n = this.hash(object);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<K, V> entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        Entry<K, V>[] entryArray = this.table;
        int n2 = (n << 1) + 1;
        if (n2 - 0x7FFFFFF7 > 0) {
            if (n == 0x7FFFFFF7) {
                return;
            }
            n2 = 0x7FFFFFF7;
        }
        Entry[] entryArray2 = new Entry[n2];
        ++this.modCount;
        this.threshold = (int)Math.min((float)n2 * this.loadFactor, 2.1474836E9f);
        boolean bl = this.initHashSeedAsNeeded(n2);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry<K, V> entry = entryArray[n3];
            while (entry != null) {
                Entry<K, V> entry2 = entry;
                entry = entry.next;
                if (bl) {
                    entry2.hash = this.hash(entry2.key);
                }
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    @Override
    public synchronized V put(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        if (this.table == EMPTY_TABLE) {
            this.inflateTable(this.threshold);
        }
        Entry<K, V>[] entryArray = this.table;
        int n = this.hash(k);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<K, V> entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(k)) {
                Object v2 = entry.value;
                entry.value = v;
                return v2;
            }
            entry = entry.next;
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n = this.hash(k);
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entry = entryArray[n2];
        entryArray[n2] = new Entry<K, V>(n, k, v, entry);
        ++this.count;
        return null;
    }

    @Override
    public synchronized V remove(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.count == 0) {
            return null;
        }
        Entry<K, V>[] entryArray = this.table;
        int n = this.hash(object);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<K, V> entry = entryArray[n2];
        Entry<K, V> entry2 = null;
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                ++this.modCount;
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                Object v = entry.value;
                entry.value = null;
                return v;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized void clear() {
        Entry<K, V>[] entryArray = this.table;
        ++this.modCount;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        try {
            Hashtable hashtable = (Hashtable)super.clone();
            if (this.table != EMPTY_TABLE) {
                hashtable.inflateTable(this.table.length);
            }
            int n = this.table.length;
            while (n-- > 0) {
                hashtable.table[n] = this.table[n] != null ? (Entry)this.table[n].clone() : null;
            }
            hashtable.keySet = null;
            hashtable.entrySet = null;
            hashtable.values = null;
            hashtable.modCount = 0;
            return hashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized String toString() {
        int n = this.size() - 1;
        if (n == -1) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        stringBuilder.append('{');
        int n2 = 0;
        while (true) {
            Map.Entry<K, V> entry = iterator.next();
            K k = entry.getKey();
            V v = entry.getValue();
            stringBuilder.append(k == this ? "(this Map)" : k.toString());
            stringBuilder.append('=');
            stringBuilder.append(v == this ? "(this Map)" : v.toString());
            if (n2 == n) {
                return stringBuilder.append('}').toString();
            }
            stringBuilder.append(", ");
            ++n2;
        }
    }

    private <T> Enumeration<T> getEnumeration(int n) {
        if (this.count == 0) {
            return Collections.emptyEnumeration();
        }
        return new Enumerator(n, false);
    }

    private <T> Iterator<T> getIterator(int n) {
        if (this.count == 0) {
            return Collections.emptyIterator();
        }
        return new Enumerator(n, true);
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = Collections.synchronizedSet(new KeySet(), this);
        }
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = Collections.synchronizedSet(new EntrySet(), this);
        }
        return this.entrySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = Collections.synchronizedCollection(new ValueCollection(), this);
        }
        return this.values;
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> entry : this.entrySet()) {
                K k = entry.getKey();
                V v = entry.getValue();
                if (!(v == null ? map.get(k) != null || !map.containsKey(k) : !v.equals(map.get(k)))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    @Override
    public synchronized int hashCode() {
        Entry<K, V>[] entryArray;
        int n = 0;
        if (this.count == 0 || this.loadFactor < 0.0f) {
            return n;
        }
        this.loadFactor = -this.loadFactor;
        for (Entry<K, V> entry : entryArray = this.table) {
            while (entry != null) {
                n += entry.hashCode();
                entry = entry.next;
            }
        }
        this.loadFactor = -this.loadFactor;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Entry entry = null;
        Hashtable hashtable = this;
        synchronized (hashtable) {
            objectOutputStream.defaultWriteObject();
            if (this.table == EMPTY_TABLE) {
                objectOutputStream.writeInt(this.threshold);
            } else {
                objectOutputStream.writeInt(this.table.length);
            }
            objectOutputStream.writeInt(this.count);
            for (int i = 0; i < this.table.length; ++i) {
                Entry<K, V> entry2 = this.table[i];
                while (entry2 != null) {
                    entry = new Entry(0, entry2.key, entry2.value, entry);
                    entry2 = entry2.next;
                }
            }
        }
        while (entry != null) {
            objectOutputStream.writeObject(entry.key);
            objectOutputStream.writeObject(entry.value);
            entry = entry.next;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.table = EMPTY_TABLE;
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this.loadFactor) + n2 / 20 + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if (n > 0 && n3 > n) {
            n3 = n;
        }
        Entry<?, ?>[] entryArray = EMPTY_TABLE;
        if (n2 > 0) {
            this.threshold = (int)Math.min((float)n3 * this.loadFactor, 2.1474836E9f);
            entryArray = new Entry[n3];
        } else {
            this.threshold = n3;
        }
        this.count = 0;
        this.initHashSeedAsNeeded(n3);
        while (n2 > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.reconstitutionPut(entryArray, object, object2);
            --n2;
        }
        this.table = entryArray;
    }

    private void reconstitutionPut(Entry<K, V>[] entryArray, K k, V v) throws StreamCorruptedException {
        if (v == null) {
            throw new StreamCorruptedException();
        }
        int n = this.hash(k);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<K, V> entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(k)) {
                throw new StreamCorruptedException();
            }
            entry = entry.next;
        }
        entry = entryArray[n2];
        entryArray[n2] = new Entry<K, V>(n, k, v, entry);
        ++this.count;
    }

    private class Enumerator<T>
    implements Enumeration<T>,
    Iterator<T> {
        Entry[] table;
        int index;
        Entry<K, V> entry;
        Entry<K, V> lastReturned;
        int type;
        boolean iterator;
        protected int expectedModCount;

        Enumerator(int n, boolean bl) {
            this.table = Hashtable.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = Hashtable.this.modCount;
            this.type = n;
            this.iterator = bl;
        }

        @Override
        public boolean hasMoreElements() {
            Entry entry = this.entry;
            int n = this.index;
            Entry[] entryArray = this.table;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.entry = entry;
            this.index = n;
            return entry != null;
        }

        @Override
        public T nextElement() {
            Entry entry = this.entry;
            int n = this.index;
            Entry[] entryArray = this.table;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.entry = entry;
            this.index = n;
            if (entry != null) {
                this.lastReturned = this.entry;
                Entry entry2 = this.lastReturned;
                this.entry = entry2.next;
                return (T)(this.type == 0 ? entry2.key : (this.type == 1 ? entry2.value : entry2));
            }
            throw new NoSuchElementException("Hashtable Enumerator");
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreElements();
        }

        @Override
        public T next() {
            if (Hashtable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.nextElement();
        }

        @Override
        public void remove() {
            if (!this.iterator) {
                throw new UnsupportedOperationException();
            }
            if (this.lastReturned == null) {
                throw new IllegalStateException("Hashtable Enumerator");
            }
            if (Hashtable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                Entry[] entryArray = Hashtable.this.table;
                int n = (this.lastReturned.hash & Integer.MAX_VALUE) % entryArray.length;
                Entry entry = entryArray[n];
                Entry entry2 = null;
                while (entry != null) {
                    if (entry == this.lastReturned) {
                        Hashtable.this.modCount++;
                        ++this.expectedModCount;
                        if (entry2 == null) {
                            entryArray[n] = entry.next;
                        } else {
                            entry2.next = entry.next;
                        }
                        Hashtable.this.count--;
                        this.lastReturned = null;
                        return;
                    }
                    entry2 = entry;
                    entry = entry.next;
                }
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        int hash;
        final K key;
        V value;
        Entry<K, V> next;

        protected Entry(int n, K k, V v, Entry<K, V> entry) {
            this.hash = n;
            this.key = k;
            this.value = v;
            this.next = entry;
        }

        protected Object clone() {
            return new Entry<K, V>(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            if (v == null) {
                throw new NullPointerException();
            }
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.key.equals(entry.getKey()) && this.value.equals(entry.getValue());
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
        }

        public String toString() {
            return this.key.toString() + "=" + this.value.toString();
        }
    }

    private class ValueCollection
    extends AbstractCollection<V> {
        private ValueCollection() {
        }

        @Override
        public Iterator<V> iterator() {
            return Hashtable.this.getIterator(1);
        }

        @Override
        public int size() {
            return Hashtable.this.count;
        }

        @Override
        public boolean contains(Object object) {
            return Hashtable.this.containsValue(object);
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return Hashtable.this.getIterator(2);
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            return super.add(entry);
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            Entry[] entryArray = Hashtable.this.table;
            int n = Hashtable.this.hash(k);
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry2 = entryArray[n2];
            while (entry2 != null) {
                if (entry2.hash == n && entry2.equals(entry)) {
                    return true;
                }
                entry2 = entry2.next;
            }
            return false;
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            Entry[] entryArray = Hashtable.this.table;
            int n = Hashtable.this.hash(k);
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry2 = entryArray[n2];
            Entry entry3 = null;
            while (entry2 != null) {
                if (entry2.hash == n && entry2.equals(entry)) {
                    Hashtable.this.modCount++;
                    if (entry3 != null) {
                        entry3.next = entry2.next;
                    } else {
                        entryArray[n2] = entry2.next;
                    }
                    Hashtable.this.count--;
                    entry2.value = null;
                    return true;
                }
                entry3 = entry2;
                entry2 = entry2.next;
            }
            return false;
        }

        @Override
        public int size() {
            return Hashtable.this.count;
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return Hashtable.this.getIterator(0);
        }

        @Override
        public int size() {
            return Hashtable.this.count;
        }

        @Override
        public boolean contains(Object object) {
            return Hashtable.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return Hashtable.this.remove(object) != null;
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }
    }

    private static class Holder {
        static final int ALTERNATIVE_HASHING_THRESHOLD;

        private Holder() {
        }

        static {
            int n;
            String string = AccessController.doPrivileged(new GetPropertyAction("jdk.map.althashing.threshold"));
            try {
                int n2 = n = null != string ? Integer.parseInt(string) : Integer.MAX_VALUE;
                if (n == -1) {
                    n = Integer.MAX_VALUE;
                }
                if (n < 0) {
                    throw new IllegalArgumentException("value must be positive integer.");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Error("Illegal value for 'jdk.map.althashing.threshold'", illegalArgumentException);
            }
            ALTERNATIVE_HASHING_THRESHOLD = n;
        }
    }
}

